/*
 * Decompiled with CFR 0.152.
 */
package org.teneighty.heap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.teneighty.heap.AbstractLinkedHeap;
import org.teneighty.heap.Heap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeftistHeap<TKey, TValue>
extends AbstractLinkedHeap<TKey, TValue>
implements Heap<TKey, TValue>,
Iterable<Heap.Entry<TKey, TValue>>,
Serializable {
    private Comparator<? super TKey> comp;
    private transient LeftistHeapEntry<TKey, TValue> minimum;
    private transient int size;
    private transient AbstractLinkedHeap.HeapReference source_heap;
    private volatile transient int mod_count;
    private static final long serialVersionUID = 574934853L;

    private void cut(LeftistHeapEntry<TKey, TValue> a2) {
        LeftistHeap a3;
        boolean a4 = a2.parent.left == a2;
        LeftistHeapEntry a5 = a3.link(a2.left, a2.right);
        LeftistHeapEntry a6 = a2.parent;
        if (a4) {
            a6.left = a5;
        } else {
            a6.right = a5;
        }
        if (a5 != null) {
            a5.parent = a6;
        }
        if (a6.right != null && a6.left == null) {
            LeftistHeapEntry a7 = a6.right;
            a6.right = a6.left;
            a6.left = a7;
            a6.nullPathLength = 0;
        } else if (a6.right != null && a6.left != null && a6.right.nullPathLength > a6.left.nullPathLength) {
            LeftistHeapEntry a8 = a6.right;
            a6.right = a6.left;
            a6.left = a8;
            a6.nullPathLength = a6.right.nullPathLength + 1;
        } else {
            a6.nullPathLength = 0;
        }
        a2.right = null;
        a2.left = null;
        a2.parent = null;
    }

    @Override
    public Iterator<Heap.Entry<TKey, TValue>> iterator() {
        return new EntryIterator();
    }

    @Override
    public Heap.Entry<TKey, TValue> extractMinimum() throws NoSuchElementException {
        if (this.minimum == null) {
            throw new NoSuchElementException();
        }
        LeftistHeapEntry<TKey, TValue> a2 = this.minimum;
        this.minimum = this.link(a2.left, a2.right);
        if (this.minimum != null) {
            this.minimum.parent = null;
        }
        --this.size;
        ++this.mod_count;
        a2.clearSourceReference();
        a2.right = null;
        a2.left = null;
        a2.parent = null;
        return a2;
    }

    @Override
    public void clear() {
        this.minimum = null;
        this.size = 0;
        ++this.mod_count;
        this.source_heap.clearHeap();
        this.source_heap = new AbstractLinkedHeap.HeapReference(this);
    }

    public LeftistHeap(Comparator<? super TKey> comp) {
        this.comp = comp;
        this.source_heap = new AbstractLinkedHeap.HeapReference(this);
        this.minimum = null;
        this.size = 0;
        this.mod_count = 0;
    }

    private LeftistHeapEntry<TKey, TValue> link(LeftistHeapEntry<TKey, TValue> a2, LeftistHeapEntry<TKey, TValue> a3) {
        LeftistHeap a4;
        if (a2 == null) {
            return a3;
        }
        if (a3 == null) {
            return a2;
        }
        if (a4.compare(a2, a3) < 0) {
            a4.linkLeft(a2, a3);
            return a2;
        }
        a4.linkLeft(a3, a2);
        return a3;
    }

    public LeftistHeap() {
        this(null);
    }

    @Override
    public Heap.Entry<TKey, TValue> insert(TKey key, TValue value) throws ClassCastException, NullPointerException {
        LeftistHeapEntry<TKey, TValue> a2 = new LeftistHeapEntry<TKey, TValue>(key, value, this.source_heap);
        this.minimum = this.link(this.minimum, a2);
        ++this.size;
        ++this.mod_count;
        return a2;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream a2) throws IOException {
        LeftistHeap a3;
        a2.defaultWriteObject();
        a2.writeInt(a3.size);
        EntryIterator a4 = a3.new EntryIterator();
        Heap.Entry a5 = null;
        while (a4.hasNext()) {
            try {
                a5 = (Heap.Entry)a4.next();
                a2.writeObject(a5.getKey());
                a2.writeObject(a5.getValue());
            }
            catch (ConcurrentModificationException a6) {
                throw (IOException)new IOException("Heap structure changed during serialization").initCause(a6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void union(Heap<TKey, TValue> other) throws ClassCastException, NullPointerException, IllegalArgumentException {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this == other) {
            throw new IllegalArgumentException();
        }
        if (other.isEmpty()) {
            return;
        }
        if (other.getClass().equals(LeftistHeap.class)) {
            LeftistHeap a2 = (LeftistHeap)other;
            try {
                this.minimum = this.link(this.minimum, a2.minimum);
                this.size += a2.size;
                ++this.mod_count;
                a2.source_heap.setHeap(this);
                a2.source_heap = new AbstractLinkedHeap.HeapReference(a2);
            }
            finally {
                a2.clear();
            }
        } else {
            throw new ClassCastException();
        }
    }

    @Override
    public boolean holdsEntry(Heap.Entry<TKey, TValue> e2) throws NullPointerException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (!e2.getClass().equals(LeftistHeapEntry.class)) {
            return false;
        }
        LeftistHeapEntry a2 = (LeftistHeapEntry)e2;
        return a2.isContainedBy(this);
    }

    @Override
    public Heap.Entry<TKey, TValue> getMinimum() throws NoSuchElementException {
        if (this.minimum == null) {
            throw new NoSuchElementException();
        }
        return this.minimum;
    }

    @Override
    public void decreaseKey(Heap.Entry<TKey, TValue> e2, TKey k2) throws IllegalArgumentException, ClassCastException {
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        LeftistHeapEntry a2 = (LeftistHeapEntry)e2;
        if (this.compareKeys(k2, a2.getKey()) > 0) {
            throw new IllegalArgumentException();
        }
        if (a2 == this.minimum) {
            a2.setKey(k2);
            return;
        }
        this.cut(a2);
        a2.setKey(k2);
        this.minimum = this.link(this.minimum, a2);
    }

    private void linkLeft(LeftistHeapEntry<TKey, TValue> a2, LeftistHeapEntry<TKey, TValue> a3) throws NullPointerException {
        if (a2.left == null) {
            a2.left = a3;
            a3.parent = a2;
        } else {
            LeftistHeap a4;
            LeftistHeapEntry a5 = a4.link(a2.right, a3);
            a2.right = a5;
            a5.parent = a2;
            if (a2.right.nullPathLength > a2.left.nullPathLength) {
                LeftistHeapEntry a6 = a2.right;
                a2.right = a2.left;
                a2.left = a6;
            }
            a2.nullPathLength = a2.right.nullPathLength + 1;
        }
    }

    @Override
    public void delete(Heap.Entry<TKey, TValue> e2) throws IllegalArgumentException, NullPointerException {
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        LeftistHeapEntry a2 = (LeftistHeapEntry)e2;
        if (a2 == this.minimum) {
            this.extractMinimum();
            return;
        }
        this.cut(a2);
        --this.size;
        ++this.mod_count;
        a2.clearSourceReference();
    }

    @Override
    public Comparator<? super TKey> getComparator() {
        return this.comp;
    }

    private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
        LeftistHeap a3;
        a2.defaultReadObject();
        int a4 = a2.readInt();
        a3.source_heap = new AbstractLinkedHeap.HeapReference(a3);
        for (int a5 = 0; a5 < a4; ++a5) {
            Object a6 = a2.readObject();
            Object a7 = a2.readObject();
            a3.insert(a6, a7);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LeftistHeapEntry<K, V>
    extends AbstractLinkedHeap.AbstractLinkedHeapEntry<K, V>
    implements Heap.Entry<K, V>,
    Serializable {
        transient LeftistHeapEntry<K, V> right;
        transient LeftistHeapEntry<K, V> parent;
        transient LeftistHeapEntry<K, V> left;
        private static final long serialVersionUID = 547584523L;
        transient int nullPathLength;

        LeftistHeapEntry(K a2, V a3, AbstractLinkedHeap.HeapReference a4) {
            super(a2, a3, a4);
            LeftistHeapEntry a5;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Heap.Entry<TKey, TValue>> {
        private LeftistHeapEntry<TKey, TValue> next;
        private int my_mod_count;

        EntryIterator() {
            EntryIterator a2;
            a2.next = a2.LeftistHeap.this.minimum;
            if (a2.next != null) {
                while (a2.next.left != null) {
                    a2.next = a2.next.left;
                }
            }
            a2.my_mod_count = a2.LeftistHeap.this.mod_count;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() throws ConcurrentModificationException {
            if (this.my_mod_count != LeftistHeap.this.mod_count) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        private LeftistHeapEntry<TKey, TValue> getSuccessor(LeftistHeapEntry<TKey, TValue> a2) {
            if (a2 == null) {
                return null;
            }
            if (a2.right != null) {
                LeftistHeapEntry a3 = a2.right;
                while (a3.left != null) {
                    a3 = a3.left;
                }
                return a3;
            }
            LeftistHeapEntry a4 = a2.parent;
            LeftistHeapEntry<Object, Object> a5 = a2;
            while (a4 != null && a5 == a4.right) {
                a5 = a4;
                a4 = a4.parent;
            }
            return a4;
        }

        @Override
        public Heap.Entry<TKey, TValue> next() throws NoSuchElementException, ConcurrentModificationException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LeftistHeapEntry a2 = this.next;
            this.next = this.getSuccessor(this.next);
            return a2;
        }
    }
}

