/*
 * Decompiled with CFR 0.152.
 */
package org.teneighty.heap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.teneighty.heap.AbstractLinkedHeap;
import org.teneighty.heap.Heap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinomialHeap<TKey, TValue>
extends AbstractLinkedHeap<TKey, TValue>
implements Heap<TKey, TValue>,
Iterable<Heap.Entry<TKey, TValue>>,
Serializable {
    private Comparator<? super TKey> comp;
    private static final long serialVersionUID = 458754L;
    private BinomialHeapEntry<TKey, TValue> head;
    private AbstractLinkedHeap.HeapReference source_heap;
    private int size;
    private volatile long mod_count;

    @Override
    public void decreaseKey(Heap.Entry<TKey, TValue> e2, TKey k2) throws IllegalArgumentException, ClassCastException {
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        HeapEntryProxy a2 = (HeapEntryProxy)e2;
        BinomialHeapEntry a3 = a2.entry;
        if (this.compareKeys(k2, a3.getKey()) > 0) {
            throw new IllegalArgumentException();
        }
        a3.setKey(k2);
        this.decreaseKeyImpl(a3);
    }

    public BinomialHeap() {
        this(null);
    }

    private void decreaseKeyImpl(BinomialHeapEntry<TKey, TValue> a2) {
        BinomialHeap a3;
        BinomialHeapEntry<Object, Object> a4 = a2;
        BinomialHeapEntry a5 = a4.parent;
        HeapEntryProxy a6 = null;
        while (a5 != null && a3.compare(a4, a5) < 0) {
            Object a7 = a4.getKey();
            Object a8 = a4.getValue();
            boolean a9 = a4.is_infinite;
            a6 = a4.proxy;
            a4.setKey(a5.getKey());
            a4.setValue(a5.getValue());
            a4.is_infinite = a5.is_infinite;
            a4.proxy = a5.proxy;
            a4.proxy.entry = a4;
            a5.setKey(a7);
            a5.setValue(a8);
            a5.is_infinite = a9;
            a5.proxy = a6;
            a5.proxy.entry = a5;
            a4 = a5;
            a5 = a4.parent;
        }
    }

    @Override
    public Heap.Entry<TKey, TValue> extractMinimum() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        BinomialHeapEntry<Object, Object> a2 = this.head;
        BinomialHeapEntry<TKey, TValue> a3 = null;
        BinomialHeapEntry a4 = a2.sibling;
        BinomialHeapEntry<Object, Object> a5 = a2;
        while (a4 != null) {
            if (this.compare(a2, a4) > 0) {
                a3 = a5;
                a2 = a4;
            }
            a5 = a4;
            a4 = a4.sibling;
        }
        if (a3 != null) {
            a3.sibling = a2.sibling;
        } else {
            this.head = a2.sibling;
        }
        a2.sibling = null;
        if (a2.child != null) {
            BinomialHeapEntry a6 = a2.child;
            a2.child = null;
            BinomialHeapEntry a7 = null;
            BinomialHeapEntry a8 = null;
            while (a6 != null) {
                a8 = a6.sibling;
                a6.sibling = a7;
                a7 = a6;
                a6.parent = null;
                a6 = a8;
            }
            a6 = a7;
            this.head = this.unionEntries(this.head, a6);
        }
        --this.size;
        ++this.mod_count;
        a2.clearSourceReference();
        return a2.proxy;
    }

    @Override
    public Comparator<? super TKey> getComparator() {
        return this.comp;
    }

    public BinomialHeap(Comparator<? super TKey> comp) {
        this.comp = comp;
        this.source_heap = new AbstractLinkedHeap.HeapReference(this);
        this.head = null;
    }

    private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
        BinomialHeap a3;
        int a4 = a2.readInt();
        a3.source_heap = new AbstractLinkedHeap.HeapReference(a3);
        a3.mod_count = 0L;
        for (int a5 = 0; a5 < a4; ++a5) {
            Object a6 = a2.readObject();
            Object a7 = a2.readObject();
            a3.insert(a6, a7);
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Iterator<Heap.Entry<TKey, TValue>> iterator() {
        return new EntryIterator();
    }

    private BinomialHeapEntry<TKey, TValue> mergeEntries(BinomialHeapEntry<TKey, TValue> a2, BinomialHeapEntry<TKey, TValue> a3) {
        if (a2 == null) {
            return a3;
        }
        if (a3 == null) {
            return a2;
        }
        BinomialHeapEntry<TKey, TValue> a4 = null;
        if (a2.degree < a3.degree) {
            a4 = a2;
            a2 = a2.sibling;
        } else {
            a4 = a3;
            a3 = a3.sibling;
        }
        BinomialHeapEntry<Object, Object> a5 = a4;
        while (a2 != null && a3 != null) {
            if (a2.degree < a3.degree) {
                a5.sibling = a2;
                a2 = a2.sibling;
            } else {
                a5.sibling = a3;
                a3 = a3.sibling;
            }
            a5 = a5.sibling;
        }
        a5.sibling = a2 == null ? a3 : a2;
        return a4;
    }

    @Override
    public void delete(Heap.Entry<TKey, TValue> e2) throws IllegalArgumentException, NullPointerException {
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        HeapEntryProxy a2 = (HeapEntryProxy)e2;
        BinomialHeapEntry a3 = a2.entry;
        a3.is_infinite = true;
        this.decreaseKeyImpl(a3);
        a2 = (HeapEntryProxy)this.extractMinimum();
        a3 = a2.entry;
        a3.is_infinite = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void union(Heap<TKey, TValue> other) throws ClassCastException, NullPointerException, IllegalArgumentException {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this == other) {
            throw new IllegalArgumentException();
        }
        if (other.isEmpty()) {
            return;
        }
        if (other.getClass().equals(BinomialHeap.class)) {
            BinomialHeap a2 = (BinomialHeap)other;
            try {
                this.compare(this.head, a2.head);
                this.head = this.unionEntries(a2.head, this.head);
                this.size += a2.size;
                ++this.mod_count;
                a2.source_heap.setHeap(this);
                a2.source_heap = new AbstractLinkedHeap.HeapReference(a2);
            }
            finally {
                a2.clear();
            }
        } else {
            throw new ClassCastException();
        }
    }

    @Override
    public void clear() {
        this.head = null;
        this.size = 0;
        ++this.mod_count;
        this.source_heap.clearHeap();
        this.source_heap = new AbstractLinkedHeap.HeapReference(this);
    }

    private void writeObject(ObjectOutputStream a2) throws IOException {
        BinomialHeap a3;
        a2.writeInt(a3.size);
        Iterator<Heap.Entry<TKey, TValue>> a4 = a3.iterator();
        Heap.Entry<TKey, TValue> a5 = null;
        while (a4.hasNext()) {
            try {
                a5 = a4.next();
                a2.writeObject(a5.getKey());
                a2.writeObject(a5.getValue());
            }
            catch (ConcurrentModificationException a6) {
                throw (IOException)new IOException("Heap structure changed during serialization").initCause(a6);
            }
        }
    }

    @Override
    public boolean holdsEntry(Heap.Entry<TKey, TValue> e2) throws NullPointerException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (!e2.getClass().equals(HeapEntryProxy.class)) {
            return false;
        }
        HeapEntryProxy a2 = (HeapEntryProxy)e2;
        return a2.entry.isContainedBy(this);
    }

    private void link(BinomialHeapEntry<TKey, TValue> a2, BinomialHeapEntry<TKey, TValue> a3) {
        a2.parent = a3;
        a2.sibling = a3.child;
        a3.child = a2;
        ++a3.degree;
    }

    private BinomialHeapEntry<TKey, TValue> unionEntries(BinomialHeapEntry<TKey, TValue> a2, BinomialHeapEntry<TKey, TValue> a3) {
        BinomialHeap a4;
        BinomialHeapEntry<Object, Object> a5 = a4.mergeEntries(a2, a3);
        if (a5 == null) {
            return null;
        }
        BinomialHeapEntry<TKey, TValue> a6 = null;
        BinomialHeapEntry<Object, Object> a7 = a5;
        BinomialHeapEntry a8 = a7.sibling;
        while (a8 != null) {
            if (a7.degree != a8.degree || a8.sibling != null && a8.sibling.degree == a7.degree) {
                a6 = a7;
                a7 = a8;
            } else if (a4.compare(a7, a8) <= 0) {
                a7.sibling = a8.sibling;
                a4.link(a8, a7);
            } else {
                if (a6 == null) {
                    a5 = a8;
                } else {
                    a6.sibling = a8;
                }
                a4.link(a7, a8);
                a7 = a8;
            }
            a8 = a7.sibling;
        }
        return a5;
    }

    @Override
    public Heap.Entry<TKey, TValue> getMinimum() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        BinomialHeapEntry<Object, Object> a2 = this.head;
        BinomialHeapEntry a3 = a2.sibling;
        while (a3 != null) {
            if (this.compare(a2, a3) > 0) {
                a2 = a3;
            }
            a3 = a3.sibling;
        }
        return a2.proxy;
    }

    @Override
    public Heap.Entry<TKey, TValue> insert(TKey key, TValue value) throws ClassCastException {
        BinomialHeapEntry<TKey, TValue> a2 = new BinomialHeapEntry<TKey, TValue>(key, value, this.source_heap);
        if (this.head == null) {
            this.head = a2;
            this.size = 1;
        } else {
            this.head = this.unionEntries(this.head, a2);
            ++this.size;
        }
        ++this.mod_count;
        HeapEntryProxy a3 = new HeapEntryProxy();
        a3.entry = a2;
        a2.proxy = a3;
        return a3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BinomialHeapEntry<K, V>
    extends AbstractLinkedHeap.AbstractLinkedHeapEntry<K, V>
    implements Heap.Entry<K, V>,
    Serializable {
        transient HeapEntryProxy<K, V> proxy;
        transient int degree = 0;
        transient BinomialHeapEntry<K, V> parent = null;
        private static final long serialVersionUID = 93424L;
        transient BinomialHeapEntry<K, V> child = null;
        transient BinomialHeapEntry<K, V> sibling = null;

        BinomialHeapEntry(K a2, V a3, AbstractLinkedHeap.HeapReference a4) {
            super(a2, a3, a4);
            BinomialHeapEntry a5;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HeapEntryProxy<TKey, TValue>
    implements Heap.Entry<TKey, TValue>,
    Serializable {
        private static final long serialVersionUID = 23497862L;
        BinomialHeapEntry<TKey, TValue> entry;

        public String toString() {
            return this.entry.toString();
        }

        @Override
        public TValue getValue() {
            return this.entry.getValue();
        }

        @Override
        public TValue setValue(TValue value) {
            return this.entry.setValue(value);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }

        HeapEntryProxy() {
            HeapEntryProxy a2;
        }

        private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
            HeapEntryProxy a3;
            a2.defaultReadObject();
            a3.entry.proxy = a3;
        }

        @Override
        public TKey getKey() {
            return this.entry.getKey();
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            return this.entry.equals(other);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Heap.Entry<TKey, TValue>> {
        private final long my_mod_count;
        private BinomialHeapEntry<TKey, TValue> next;

        EntryIterator() {
            EntryIterator a2;
            a2.next = a2.BinomialHeap.this.head;
            a2.my_mod_count = a2.BinomialHeap.this.mod_count;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        private BinomialHeapEntry<TKey, TValue> eulerianSuccessor(BinomialHeapEntry<TKey, TValue> a2) {
            if (a2 == null) {
                return null;
            }
            if (a2.child != null) {
                return a2.child;
            }
            if (a2.parent == null) {
                return a2.sibling;
            }
            return a2.parent.sibling;
        }

        @Override
        public Heap.Entry<TKey, TValue> next() throws NoSuchElementException, ConcurrentModificationException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BinomialHeapEntry a2 = this.next;
            this.next = this.eulerianSuccessor(this.next);
            return a2.proxy;
        }

        @Override
        public boolean hasNext() {
            if (this.my_mod_count != BinomialHeap.this.mod_count) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }
    }
}

