/*
 * Decompiled with CFR 0.152.
 */
package org.teneighty.heap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.teneighty.heap.AbstractHeap;
import org.teneighty.heap.DynamicArray;
import org.teneighty.heap.Heap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryHeap<TKey, TValue>
extends AbstractHeap<TKey, TValue>
implements Heap<TKey, TValue>,
Iterable<Heap.Entry<TKey, TValue>>,
Serializable,
Cloneable {
    private int rec_capacity;
    private volatile int mod_count;
    private DynamicArray<BinaryHeapEntry<TKey, TValue>> heap;
    private int size;
    private static final long serialVersionUID = 3874378L;
    private Comparator<? super TKey> comp;
    private static final int DEFAULT_HEAP_CAPACITY = 16;

    @Override
    public Heap.Entry<TKey, TValue> getMinimum() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.heap.get(1);
    }

    @Override
    public Heap.Entry<TKey, TValue> insert(TKey key, TValue value) throws ClassCastException {
        BinaryHeapEntry<TKey, TValue> a2 = new BinaryHeapEntry<TKey, TValue>(key, value);
        if (!this.isEmpty()) {
            this.compare(a2, this.heap.get(1));
        }
        this.ensureCapacityUp();
        int a3 = ++this.size;
        this.heap.set(a3, a2);
        a2.heap_index = a3;
        this.heapify(a3);
        ++this.mod_count;
        return a2;
    }

    public int getCapacity() {
        return this.heap.capacity();
    }

    private void ensureCapacityUp() {
        BinaryHeap a2;
        int a3 = a2.getCapacity();
        if (a2.getSize() >= a2.getCapacity() - 1) {
            a3 = a2.getCapacity() * 2;
        }
        a2.heap.ensureCapacity(a3);
    }

    private void ensureCapacityDown() {
        BinaryHeap a2;
        int a3 = a2.getCapacity();
        if (a2.getSize() == 0) {
            a3 = a2.rec_capacity;
        } else if (a2.getSize() < a2.getCapacity() / 2) {
            a3 = a2.getCapacity() / 2;
            a3 = a3 < a2.rec_capacity ? a2.rec_capacity : a3;
        }
        a2.heap.ensureCapacity(a3);
    }

    private void heapify(int a2) {
        int a3 = a2;
        int a4 = a2;
        int a5 = a2;
        int a6 = a2;
        int a7 = a2;
        BinaryHeapEntry<TKey, TValue> a8 = null;
        while (true) {
            BinaryHeap a9;
            if ((a7 = a6 / 2) >= 1 && a9.compare(a9.heap.get(a7), a9.heap.get(a6)) > 0) {
                a8 = a9.heap.get(a6);
                a9.heap.set(a6, a9.heap.get(a7));
                a9.heap.get((int)a6).heap_index = a6;
                a9.heap.set(a7, a8);
                a8.heap_index = a7;
                a6 = a7;
                continue;
            }
            a3 = a6 << 1;
            a4 = a3 + 1;
            a5 = a6;
            if (a3 <= a9.size && a9.compare(a9.heap.get(a3), a9.heap.get(a5)) < 0) {
                a5 = a3;
            }
            if (a4 <= a9.size && a9.compare(a9.heap.get(a4), a9.heap.get(a5)) < 0) {
                a5 = a4;
            }
            if (a5 == a6) break;
            a8 = a9.heap.get(a6);
            a9.heap.set(a6, a9.heap.get(a5));
            a9.heap.get((int)a6).heap_index = a6;
            a9.heap.set(a5, a8);
            a8.heap_index = a5;
            a6 = a5;
        }
    }

    private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
        BinaryHeap a3;
        a3.comp = (Comparator)a2.readObject();
        int a4 = a2.readInt();
        a3.size = a2.readInt();
        a3.rec_capacity = a2.readInt();
        a3.heap = new DynamicArray(a4);
        BinaryHeapEntry<Object, Object> a5 = null;
        for (int a6 = 1; a6 <= a3.size; ++a6) {
            a5 = new BinaryHeapEntry<Object, Object>(a2.readObject(), a2.readObject());
            a5.heap_index = a6;
            a3.heap.set(a6, a5);
        }
    }

    @Override
    public void clear() {
        this.size = 0;
        ++this.mod_count;
        int a2 = 1;
        while (this.heap.get(a2) != null) {
            this.heap.set(a2, null);
        }
        this.heap.reallocate(this.rec_capacity);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void delete(Heap.Entry<TKey, TValue> e2) throws IllegalArgumentException, NullPointerException {
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        BinaryHeapEntry a2 = (BinaryHeapEntry)e2;
        if (this.size == 1) {
            this.heap.set(1, null);
            this.size = 0;
            ++this.mod_count;
            return;
        }
        if (a2.heap_index == this.size) {
            this.heap.set(a2.heap_index, null);
            --this.size;
        } else {
            this.heap.set(a2.heap_index, this.heap.get(this.size));
            this.heap.get((int)a2.heap_index).heap_index = a2.heap_index;
            this.heap.set(this.size, null);
            --this.size;
            this.heapify(a2.heap_index);
        }
        ++this.mod_count;
        this.ensureCapacityDown();
    }

    @Override
    public Heap.Entry<TKey, TValue> extractMinimum() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        BinaryHeapEntry<TKey, TValue> a2 = this.heap.get(1);
        this.delete(a2);
        return a2;
    }

    public BinaryHeap(int initial_capacity) throws IllegalArgumentException {
        this(null, initial_capacity);
    }

    @Override
    public Object clone() {
        try {
            BinaryHeap a2 = (BinaryHeap)super.clone();
            a2.heap = new DynamicArray(this.getCapacity());
            BinaryHeapEntry<TKey, TValue> a3 = null;
            for (int a4 = 1; a4 <= this.getSize(); ++a4) {
                a3 = this.heap.get(a4);
                a2.heap.set(a4, (BinaryHeapEntry)a3.clone());
            }
            a2.mod_count = 0;
            return a2;
        }
        catch (CloneNotSupportedException a5) {
            throw (InternalError)new InternalError("BinaryHeap supports the Cloneable interface").initCause(a5);
        }
    }

    @Override
    public boolean holdsEntry(Heap.Entry<TKey, TValue> e2) throws NullPointerException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (!e2.getClass().equals(BinaryHeapEntry.class)) {
            return false;
        }
        BinaryHeapEntry a2 = (BinaryHeapEntry)e2;
        if (a2.heap_index >= this.heap.capacity()) {
            return false;
        }
        return this.heap.get(a2.heap_index) == a2;
    }

    @Override
    public void decreaseKey(Heap.Entry<TKey, TValue> e2, TKey k2) throws IllegalArgumentException, ClassCastException, NullPointerException {
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        BinaryHeapEntry a2 = (BinaryHeapEntry)e2;
        if (this.compareKeys(k2, a2.getKey()) > 0) {
            throw new IllegalArgumentException();
        }
        a2.setKey(k2);
        this.heapify(a2.heap_index);
        ++this.mod_count;
    }

    @Override
    public Comparator<? super TKey> getComparator() {
        return this.comp;
    }

    public BinaryHeap(Comparator<? super TKey> comp, int initial_capacity) throws IllegalArgumentException {
        if (initial_capacity < 0) {
            throw new IllegalArgumentException("Invalid initial capacity");
        }
        this.comp = comp;
        this.rec_capacity = initial_capacity + 1;
        this.heap = new DynamicArray(this.rec_capacity);
        this.size = 0;
        this.mod_count = 0;
    }

    private void writeObject(ObjectOutputStream a2) throws IOException {
        BinaryHeap a3;
        a2.writeObject(a3.comp);
        a2.writeInt(a3.heap.capacity());
        a2.writeInt(a3.size);
        a2.writeInt(a3.rec_capacity);
        BinaryHeapEntry<TKey, TValue> a4 = null;
        for (int a5 = 1; a5 <= a3.getSize(); ++a5) {
            a4 = a3.heap.get(a5);
            a2.writeObject(a4.getKey());
            a2.writeObject(a4.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void union(Heap<TKey, TValue> other) throws ClassCastException, NullPointerException, IllegalArgumentException {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            throw new IllegalArgumentException();
        }
        if (other.getClass().equals(BinaryHeap.class)) {
            BinaryHeap a2 = (BinaryHeap)other;
            try {
                int a3 = this.size + a2.size;
                this.heap.ensureCapacity(a3 + 1);
                int a4 = this.size + 1;
                int a5 = 1;
                while (a5 <= a2.size) {
                    BinaryHeapEntry<TKey, TValue> a6 = a2.heap.get(a5);
                    a6.heap_index = a4;
                    this.heap.set(a4, a6);
                    this.heapify(a4);
                    ++a5;
                    ++a4;
                }
                this.size = a3;
                ++this.mod_count;
            }
            finally {
                a2.clear();
            }
        } else {
            throw new ClassCastException();
        }
    }

    @Override
    public Iterator<Heap.Entry<TKey, TValue>> iterator() {
        return new EntryIterator();
    }

    public BinaryHeap() {
        this(null, 16);
    }

    public BinaryHeap(Comparator<? super TKey> comp) {
        this(comp, 16);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BinaryHeapEntry<TKey, TValue>
    extends AbstractHeap.AbstractHeapEntry<TKey, TValue>
    implements Heap.Entry<TKey, TValue>,
    Cloneable,
    Serializable {
        transient int heap_index;
        private static final long serialVersionUID = 23498234L;

        BinaryHeapEntry(TKey a2, TValue a3) {
            super(a2, a3);
            BinaryHeapEntry a4;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException a2) {
                throw (InternalError)new InternalError("BinaryHeapEntry supports the Cloneable interface").initCause(a2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    implements Iterator<Heap.Entry<TKey, TValue>> {
        private int it_mod_count;
        private int it_count = 1;

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        EntryIterator() {
            EntryIterator a2;
            a2.it_mod_count = a2.BinaryHeap.this.mod_count;
        }

        @Override
        public boolean hasNext() throws ConcurrentModificationException {
            if (BinaryHeap.this.mod_count != this.it_mod_count) {
                throw new ConcurrentModificationException();
            }
            return this.it_count <= BinaryHeap.this.getSize();
        }

        @Override
        public Heap.Entry<TKey, TValue> next() throws NoSuchElementException, ConcurrentModificationException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("The iterator is empty");
            }
            return (Heap.Entry)BinaryHeap.this.heap.get(this.it_count++);
        }
    }
}

