/*
 * Decompiled with CFR 0.152.
 */
package org.teneighty.heap;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.teneighty.heap.Action;
import org.teneighty.heap.Heap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHeap<TKey, TValue>
implements Heap<TKey, TValue>,
Iterable<Heap.Entry<TKey, TValue>> {
    private volatile transient Collection<Heap.Entry<TKey, TValue>> entries;
    private volatile transient Collection<TKey> keys;
    private volatile transient Collection<TValue> values;

    @Override
    public int hashCode() {
        int a2 = 0;
        Iterator<Heap.Entry<TKey, TValue>> a3 = this.getEntries().iterator();
        while (a3.hasNext()) {
            a2 += ((Object)a3.next()).hashCode();
        }
        return a2;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractHeap a2 = (AbstractHeap)super.clone();
        a2.keys = null;
        a2.values = null;
        a2.entries = null;
        return a2;
    }

    @Override
    public Collection<Heap.Entry<TKey, TValue>> getEntries() {
        if (this.entries == null) {
            this.entries = new EntryCollection();
        }
        return this.entries;
    }

    protected int compareKeys(TKey k1, TKey k2) throws ClassCastException {
        return this.getComparator() == null ? ((Comparable)k1).compareTo(k2) : this.getComparator().compare(k1, k2);
    }

    @Override
    public void forEach(Action<Heap.Entry<TKey, TValue>> action) throws NullPointerException {
        if (action == null) {
            throw new NullPointerException();
        }
        Iterator a2 = this.iterator();
        while (a2.hasNext()) {
            action.action(a2.next());
        }
    }

    @Override
    public boolean containsEntry(Heap.Entry<TKey, TValue> entry) throws NullPointerException {
        if (entry == null) {
            throw new NullPointerException();
        }
        Iterator<Heap.Entry<TKey, TValue>> a2 = this.getEntries().iterator();
        Heap.Entry<TKey, TValue> a3 = null;
        while (a2.hasNext()) {
            a3 = a2.next();
            if (!((Object)a3).equals(entry)) continue;
            return true;
        }
        return false;
    }

    static boolean objectEquals(Object a2, Object a3) {
        return a2 == null ? a3 == null : a2.equals(a3);
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        a2.append(this.getClass().getName());
        a2.append("(");
        a2.append(this.getSize());
        a2.append(") ");
        a2.append("[");
        Iterator<Heap.Entry<TKey, TValue>> a3 = this.getEntries().iterator();
        boolean a4 = a3.hasNext();
        Heap.Entry<TKey, TValue> a5 = null;
        Object a6 = null;
        Object a7 = null;
        while (a4) {
            a5 = a3.next();
            a6 = a5.getKey();
            a7 = a5.getValue();
            a2.append(a6 == this ? "[self-reference]" : String.valueOf(a6));
            a2.append("->");
            a2.append(a7 == this ? "[self-reference]" : String.valueOf(a7));
            a4 = a3.hasNext();
            if (!a4) continue;
            a2.append(", ");
        }
        a2.append("]");
        return a2.toString();
    }

    @Override
    public Collection<TKey> getKeys() {
        if (this.keys == null) {
            this.keys = new KeyCollection();
        }
        return this.keys;
    }

    static int objectHashCode(Object a2) {
        return a2 == null ? 0 : a2.hashCode();
    }

    @Override
    public void insertAll(Heap<? extends TKey, ? extends TValue> other) throws NullPointerException, ClassCastException, IllegalArgumentException {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            throw new IllegalArgumentException();
        }
        if (other.isEmpty()) {
            return;
        }
        for (Heap.Entry<TKey, TValue> a2 : other.getEntries()) {
            this.insert(a2.getKey(), a2.getValue());
        }
    }

    protected int compare(Heap.Entry<TKey, TValue> node1, Heap.Entry<TKey, TValue> node2) throws ClassCastException, NullPointerException {
        return this.compareKeys(node1.getKey(), node2.getKey());
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!Heap.class.isInstance(other)) {
            return false;
        }
        Heap a2 = (Heap)other;
        return ((Object)this.getEntries()).equals(a2.getEntries());
    }

    protected AbstractHeap() {
    }

    @Override
    public Collection<TValue> getValues() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractHeapEntry<TKey, TValue>
    implements Heap.Entry<TKey, TValue> {
        private TValue value;
        private TKey key;

        @Override
        public final boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!Heap.Entry.class.isInstance(other)) {
                return false;
            }
            Heap.Entry a2 = (Heap.Entry)other;
            return AbstractHeap.objectEquals(this.key, a2.getKey()) && AbstractHeap.objectEquals(this.value, a2.getValue());
        }

        protected AbstractHeapEntry(TKey key, TValue value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public final TKey getKey() {
            return this.key;
        }

        public String toString() {
            StringBuilder a2 = new StringBuilder();
            a2.append(this.getKey() == this ? "[self-reference]" : String.valueOf(this.getKey()));
            a2.append("->");
            a2.append(this.getValue() == this ? "[self-reference]" : String.valueOf(this.getValue()));
            return a2.toString();
        }

        @Override
        public final TValue getValue() {
            return this.value;
        }

        @Override
        public final TValue setValue(TValue value) {
            TValue a2 = this.value;
            this.value = value;
            return a2;
        }

        @Override
        public final int hashCode() {
            return AbstractHeap.objectHashCode(this.key) ^ AbstractHeap.objectHashCode(this.value);
        }

        public final void setKey(TKey key) {
            this.key = key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueCollection
    extends AbstractHeapCollection<TValue>
    implements Collection<TValue> {
        @Override
        public Iterator<TValue> iterator() {
            return new ValueIterator();
        }

        ValueCollection() {
            ValueCollection a2;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ValueIterator
        implements Iterator<TValue> {
            private Iterator<Heap.Entry<TKey, TValue>> backingIterator;

            @Override
            public TValue next() {
                return this.backingIterator.next().getValue();
            }

            @Override
            public void remove() {
                this.backingIterator.remove();
            }

            @Override
            public boolean hasNext() {
                return this.backingIterator.hasNext();
            }

            ValueIterator() {
                ValueIterator a2;
                a2.backingIterator = a2.AbstractHeap.this.iterator();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyCollection
    extends AbstractHeapCollection<TKey>
    implements Collection<TKey> {
        KeyCollection() {
            KeyCollection a2;
        }

        @Override
        public Iterator<TKey> iterator() {
            return new KeyIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class KeyIterator
        implements Iterator<TKey> {
            private Iterator<Heap.Entry<TKey, TValue>> backingIterator;

            KeyIterator() {
                KeyIterator a2;
                a2.backingIterator = a2.AbstractHeap.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.backingIterator.hasNext();
            }

            @Override
            public void remove() {
                this.backingIterator.remove();
            }

            @Override
            public TKey next() {
                return this.backingIterator.next().getKey();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryCollection
    extends AbstractHeapCollection<Heap.Entry<TKey, TValue>>
    implements Collection<Heap.Entry<TKey, TValue>> {
        EntryCollection() {
            EntryCollection a2;
        }

        @Override
        public final boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            if (!Heap.Entry.class.isAssignableFrom(o.getClass())) {
                return false;
            }
            Heap.Entry a2 = (Heap.Entry)o;
            return AbstractHeap.this.containsEntry(a2);
        }

        @Override
        public Iterator<Heap.Entry<TKey, TValue>> iterator() {
            return AbstractHeap.this.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractHeapCollection<TElement>
    extends AbstractCollection<TElement>
    implements Collection<TElement> {
        @Override
        public final int hashCode() {
            int a2 = 0;
            for (Object a3 : this) {
                a2 ^= AbstractHeap.objectHashCode(a3);
            }
            return a2;
        }

        @Override
        public final boolean remove(Object objectToRemove) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(Collection<?> objectsToRemove) throws NullPointerException, UnsupportedOperationException {
            if (objectsToRemove == null) {
                throw new NullPointerException();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object objectToCheck) {
            Iterator a2 = this.iterator();
            while (a2.hasNext()) {
                if (!AbstractHeap.objectEquals(objectToCheck, a2.next())) continue;
                return true;
            }
            return false;
        }

        @Override
        public final void clear() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(Collection<?> objectsToRetain) throws NullPointerException, UnsupportedOperationException {
            if (objectsToRetain == null) {
                throw new NullPointerException();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final int size() {
            return AbstractHeap.this.getSize();
        }

        @Override
        public final boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!Collection.class.isInstance(other)) {
                return false;
            }
            Collection a2 = (Collection)other;
            if (a2.size() != this.size()) {
                return false;
            }
            LinkedList a3 = new LinkedList(this);
            LinkedList a4 = new LinkedList(a2);
            while (a3.size() > 0) {
                boolean a5 = false;
                Object a6 = a3.remove(0);
                Iterator a7 = a4.iterator();
                while (a7.hasNext()) {
                    Object a8 = a7.next();
                    if (!AbstractHeap.objectEquals(a6, a8)) continue;
                    a7.remove();
                    a5 = true;
                    break;
                }
                if (a5) continue;
                return false;
            }
            return true;
        }

        protected AbstractHeapCollection() {
        }

        @Override
        public boolean addAll(Collection<? extends TElement> collectionToAdd) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(TElement objectToAdd) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

