/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.joda.time.DurationFieldType;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodFormatterBuilder {
    private static final int SECONDS_MILLIS = 8;
    private static final int MILLIS = 7;
    private static final int MAX_FIELD = 9;
    private int iPrintZeroSetting;
    private boolean iNotParser;
    private static final int PRINT_ZERO_IF_SUPPORTED = 3;
    private static final int PRINT_ZERO_NEVER = 5;
    private boolean iRejectSignedValues;
    private static final int HOURS = 4;
    private boolean iNotPrinter;
    private static final int PRINT_ZERO_ALWAYS = 4;
    private static final int PRINT_ZERO_RARELY_LAST = 2;
    private static final int MINUTES = 5;
    private static final ConcurrentMap<String, Pattern> PATTERNS = new ConcurrentHashMap<String, Pattern>();
    private static final int PRINT_ZERO_RARELY_FIRST = 1;
    private static final int DAYS = 3;
    private PeriodFieldAffix iPrefix;
    private List<Object> iElementPairs;
    private int iMaxParsedDigits;
    private static final int SECONDS_OPTIONAL_MILLIS = 9;
    private static final int WEEKS = 2;
    private static final int YEARS = 0;
    private int iMinPrintedDigits;
    private FieldFormatter[] iFieldFormatters;
    private static final int MONTHS = 1;
    private static final int SECONDS = 6;

    private PeriodFormatterBuilder append0(PeriodPrinter a2, PeriodParser a3) {
        PeriodFormatterBuilder a4;
        a4.iElementPairs.add(a2);
        a4.iElementPairs.add(a3);
        a4.iNotPrinter = a4.iNotPrinter | a2 == null;
        a4.iNotParser = a4.iNotParser | a3 == null;
        return a4;
    }

    public PeriodFormatterBuilder appendLiteral(String arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        this.clearPrefix();
        Literal literal = new Literal(arg0);
        this.append0(literal, literal);
        return this;
    }

    public PeriodFormatterBuilder appendPrefix(String arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new SimpleAffix(arg0));
    }

    public PeriodFormatterBuilder appendSeparatorIfFieldsAfter(String arg0) {
        return this.appendSeparator(arg0, arg0, null, false, true);
    }

    private PeriodFormatterBuilder appendSuffix(PeriodFieldAffix a2) {
        Object object;
        Object object2;
        PeriodFormatterBuilder a3;
        if (a3.iElementPairs.size() > 0) {
            object2 = a3.iElementPairs.get(a3.iElementPairs.size() - 2);
            object = a3.iElementPairs.get(a3.iElementPairs.size() - 1);
        } else {
            object2 = null;
            object = null;
        }
        if (object2 == null || object == null || object2 != object || !(object2 instanceof FieldFormatter)) {
            throw new IllegalStateException("No field to apply suffix to");
        }
        a3.clearPrefix();
        FieldFormatter fieldFormatter = new FieldFormatter((FieldFormatter)object2, a2);
        a3.iElementPairs.set(a3.iElementPairs.size() - 2, fieldFormatter);
        a3.iElementPairs.set(a3.iElementPairs.size() - 1, fieldFormatter);
        a3.iFieldFormatters[fieldFormatter.getFieldType()] = fieldFormatter;
        return a3;
    }

    public PeriodFormatterBuilder appendDays() {
        this.appendField(3);
        return this;
    }

    private PeriodFormatterBuilder appendPrefix(PeriodFieldAffix a2) {
        PeriodFormatterBuilder a3;
        if (a2 == null) {
            throw new IllegalArgumentException();
        }
        if (a3.iPrefix != null) {
            a2 = new CompositeAffix(a3.iPrefix, a2);
        }
        a3.iPrefix = a2;
        return a3;
    }

    public PeriodFormatterBuilder printZeroRarelyLast() {
        this.iPrintZeroSetting = 2;
        return this;
    }

    public PeriodFormatterBuilder appendSeconds() {
        this.appendField(6);
        return this;
    }

    private void appendField(int a2, int a3) {
        PeriodFormatterBuilder a4;
        FieldFormatter fieldFormatter = new FieldFormatter(a3, a4.iPrintZeroSetting, a4.iMaxParsedDigits, a4.iRejectSignedValues, a2, a4.iFieldFormatters, a4.iPrefix, null);
        a4.append0(fieldFormatter, fieldFormatter);
        a4.iFieldFormatters[a2] = fieldFormatter;
        a4.iPrefix = null;
    }

    public PeriodFormatterBuilder append(PeriodPrinter arg0, PeriodParser arg1) {
        if (arg0 == null && arg1 == null) {
            throw new IllegalArgumentException("No printer or parser supplied");
        }
        this.clearPrefix();
        this.append0(arg0, arg1);
        return this;
    }

    public PeriodFormatter toFormatter() {
        PeriodFormatter periodFormatter = PeriodFormatterBuilder.toFormatter(this.iElementPairs, this.iNotPrinter, this.iNotParser);
        for (FieldFormatter fieldFormatter : this.iFieldFormatters) {
            if (fieldFormatter == null) continue;
            fieldFormatter.finish(this.iFieldFormatters);
        }
        this.iFieldFormatters = (FieldFormatter[])this.iFieldFormatters.clone();
        return periodFormatter;
    }

    public PeriodFormatterBuilder minimumPrintedDigits(int arg0) {
        this.iMinPrintedDigits = arg0;
        return this;
    }

    public PeriodFormatterBuilder printZeroIfSupported() {
        this.iPrintZeroSetting = 3;
        return this;
    }

    public PeriodFormatterBuilder printZeroAlways() {
        this.iPrintZeroSetting = 4;
        return this;
    }

    private void appendField(int a2) {
        PeriodFormatterBuilder a3;
        a3.appendField(a2, a3.iMinPrintedDigits);
    }

    public PeriodFormatterBuilder appendSecondsWithMillis() {
        this.appendField(8);
        return this;
    }

    public PeriodFormatterBuilder appendSuffix(String arg0, String arg1) {
        if (arg0 == null || arg1 == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new PluralAffix(arg0, arg1));
    }

    private static PeriodFormatter toFormatter(List<Object> a2, boolean a3, boolean a4) {
        Object object;
        if (a3 && a4) {
            throw new IllegalStateException("Builder has created neither a printer nor a parser");
        }
        int n = a2.size();
        if (n >= 2 && a2.get(0) instanceof Separator && ((Separator)(object = (Separator)a2.get(0))).iAfterParser == null && ((Separator)object).iAfterPrinter == null) {
            PeriodFormatter periodFormatter = PeriodFormatterBuilder.toFormatter(a2.subList(2, n), a3, a4);
            object = ((Separator)object).finish(periodFormatter.getPrinter(), periodFormatter.getParser());
            return new PeriodFormatter((PeriodPrinter)object, (PeriodParser)object);
        }
        object = PeriodFormatterBuilder.createComposite(a2);
        if (a3) {
            return new PeriodFormatter(null, (PeriodParser)object[1]);
        }
        if (a4) {
            return new PeriodFormatter((PeriodPrinter)object[0], null);
        }
        return new PeriodFormatter((PeriodPrinter)object[0], (PeriodParser)object[1]);
    }

    public PeriodFormatterBuilder appendMillis() {
        this.appendField(7);
        return this;
    }

    public PeriodFormatterBuilder printZeroRarelyFirst() {
        this.iPrintZeroSetting = 1;
        return this;
    }

    public PeriodFormatterBuilder appendSeparatorIfFieldsBefore(String arg0) {
        return this.appendSeparator(arg0, arg0, null, true, false);
    }

    public void clear() {
        this.iMinPrintedDigits = 1;
        this.iPrintZeroSetting = 2;
        this.iMaxParsedDigits = 10;
        this.iRejectSignedValues = false;
        this.iPrefix = null;
        if (this.iElementPairs == null) {
            this.iElementPairs = new ArrayList<Object>();
        } else {
            this.iElementPairs.clear();
        }
        this.iNotPrinter = false;
        this.iNotParser = false;
        this.iFieldFormatters = new FieldFormatter[10];
    }

    public PeriodFormatterBuilder appendSecondsWithOptionalMillis() {
        this.appendField(9);
        return this;
    }

    private static Object[] createComposite(List<Object> a2) {
        switch (a2.size()) {
            case 0: {
                return new Object[]{Literal.EMPTY, Literal.EMPTY};
            }
            case 1: {
                return new Object[]{a2.get(0), a2.get(1)};
            }
        }
        Composite composite = new Composite(a2);
        return new Object[]{composite, composite};
    }

    public PeriodFormatterBuilder printZeroNever() {
        this.iPrintZeroSetting = 5;
        return this;
    }

    public PeriodFormatterBuilder appendPrefix(String arg0, String arg1) {
        if (arg0 == null || arg1 == null) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new PluralAffix(arg0, arg1));
    }

    public PeriodParser toParser() {
        if (this.iNotParser) {
            return null;
        }
        return this.toFormatter().getParser();
    }

    public PeriodFormatterBuilder appendMillis3Digit() {
        this.appendField(7, 3);
        return this;
    }

    private void clearPrefix() throws IllegalStateException {
        PeriodFormatterBuilder a2;
        if (a2.iPrefix != null) {
            throw new IllegalStateException("Prefix not followed by field");
        }
        a2.iPrefix = null;
    }

    public PeriodFormatterBuilder maximumParsedDigits(int arg0) {
        this.iMaxParsedDigits = arg0;
        return this;
    }

    public PeriodFormatterBuilder rejectSignedValues(boolean arg0) {
        this.iRejectSignedValues = arg0;
        return this;
    }

    public PeriodFormatterBuilder appendWeeks() {
        this.appendField(2);
        return this;
    }

    public PeriodFormatterBuilder appendSeparator(String arg0, String arg1) {
        return this.appendSeparator(arg0, arg1, null, true, true);
    }

    public PeriodFormatterBuilder appendMonths() {
        this.appendField(1);
        return this;
    }

    public PeriodFormatterBuilder appendPrefix(String[] arg0, String[] arg1) {
        if (arg0 == null || arg1 == null || arg0.length < 1 || arg0.length != arg1.length) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new RegExAffix(arg0, arg1));
    }

    public PeriodFormatterBuilder() {
        this.clear();
    }

    private PeriodFormatterBuilder appendSeparator(String a2, String a3, String[] a4, boolean a5, boolean a6) {
        PeriodFormatterBuilder a7;
        if (a2 == null || a3 == null) {
            throw new IllegalArgumentException();
        }
        a7.clearPrefix();
        List<Object> list = a7.iElementPairs;
        if (list.size() == 0) {
            if (a6 && !a5) {
                Separator separator = new Separator(a2, a3, a4, Literal.EMPTY, Literal.EMPTY, a5, a6);
                a7.append0(separator, separator);
            }
            return a7;
        }
        Separator separator = null;
        int n = list.size();
        while (--n >= 0) {
            if (list.get(n) instanceof Separator) {
                separator = (Separator)list.get(n);
                list = list.subList(n + 1, list.size());
                break;
            }
            --n;
        }
        if (separator != null && list.size() == 0) {
            throw new IllegalStateException("Cannot have two adjacent separators");
        }
        Object[] objectArray = PeriodFormatterBuilder.createComposite(list);
        list.clear();
        Separator separator2 = new Separator(a2, a3, a4, (PeriodPrinter)objectArray[0], (PeriodParser)objectArray[1], a5, a6);
        list.add(separator2);
        list.add(separator2);
        return a7;
    }

    public PeriodFormatterBuilder appendSuffix(String[] arg0, String[] arg1) {
        if (arg0 == null || arg1 == null || arg0.length < 1 || arg0.length != arg1.length) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new RegExAffix(arg0, arg1));
    }

    public PeriodFormatterBuilder appendMinutes() {
        this.appendField(5);
        return this;
    }

    public PeriodFormatterBuilder appendSuffix(String arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new SimpleAffix(arg0));
    }

    public PeriodPrinter toPrinter() {
        if (this.iNotPrinter) {
            return null;
        }
        return this.toFormatter().getPrinter();
    }

    public PeriodFormatterBuilder appendYears() {
        this.appendField(0);
        return this;
    }

    public PeriodFormatterBuilder appendSeparator(String arg0) {
        return this.appendSeparator(arg0, arg0, null, true, true);
    }

    public PeriodFormatterBuilder append(PeriodFormatter arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        this.clearPrefix();
        this.append0(arg0.getPrinter(), arg0.getParser());
        return this;
    }

    public PeriodFormatterBuilder appendSeparator(String arg0, String arg1, String[] arg2) {
        return this.appendSeparator(arg0, arg1, arg2, true, true);
    }

    public PeriodFormatterBuilder appendHours() {
        this.appendField(4);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Composite
    implements PeriodPrinter,
    PeriodParser {
        private final PeriodParser[] iParsers;
        private final PeriodPrinter[] iPrinters;

        private void addArrayToList(List<Object> a2, Object[] a3) {
            if (a3 != null) {
                for (int i2 = 0; i2 < a3.length; ++i2) {
                    a2.add(a3[i2]);
                }
            }
        }

        @Override
        public int parseInto(ReadWritablePeriod arg0, String arg1, int arg2, Locale arg3) {
            PeriodParser[] periodParserArray = this.iParsers;
            if (periodParserArray == null) {
                throw new UnsupportedOperationException();
            }
            int n = periodParserArray.length;
            for (int i2 = 0; i2 < n && arg2 >= 0; ++i2) {
                arg2 = periodParserArray[i2].parseInto(arg0, arg1, arg2, arg3);
            }
            return arg2;
        }

        @Override
        public int calculatePrintedLength(ReadablePeriod arg0, Locale arg1) {
            int n = 0;
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n2 = periodPrinterArray.length;
            while (--n2 >= 0) {
                n += periodPrinterArray[n2].calculatePrintedLength(arg0, arg1);
            }
            return n;
        }

        @Override
        public void printTo(Writer arg0, ReadablePeriod arg1, Locale arg2) throws IOException {
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n = periodPrinterArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                periodPrinterArray[i2].printTo(arg0, arg1, arg2);
            }
        }

        @Override
        public int countFieldsToPrint(ReadablePeriod arg0, int arg1, Locale arg2) {
            int n;
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n2 = periodPrinterArray.length;
            for (n = 0; n < arg1 && --n2 >= 0; n += periodPrinterArray[n2].countFieldsToPrint(arg0, Integer.MAX_VALUE, arg2)) {
            }
            return n;
        }

        Composite(List<Object> a2) {
            Composite a3;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            a3.decompose(a2, arrayList, arrayList2);
            a3.iPrinters = arrayList.size() <= 0 ? null : arrayList.toArray(new PeriodPrinter[arrayList.size()]);
            a3.iParsers = arrayList2.size() <= 0 ? null : arrayList2.toArray(new PeriodParser[arrayList2.size()]);
        }

        @Override
        public void printTo(StringBuffer arg0, ReadablePeriod arg1, Locale arg2) {
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n = periodPrinterArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                periodPrinterArray[i2].printTo(arg0, arg1, arg2);
            }
        }

        private void decompose(List<Object> a2, List<Object> a3, List<Object> a4) {
            int n = a2.size();
            for (int i2 = 0; i2 < n; i2 += 2) {
                Composite a5;
                Object object = a2.get(i2);
                if (object instanceof PeriodPrinter) {
                    if (object instanceof Composite) {
                        a5.addArrayToList(a3, ((Composite)object).iPrinters);
                    } else {
                        a3.add(object);
                    }
                }
                if (!((object = a2.get(i2 + 1)) instanceof PeriodParser)) continue;
                if (object instanceof Composite) {
                    a5.addArrayToList(a4, ((Composite)object).iParsers);
                    continue;
                }
                a4.add(object);
            }
        }
    }

    static class Separator
    implements PeriodPrinter,
    PeriodParser {
        private volatile PeriodParser iAfterParser;
        private final String iText;
        private final PeriodParser iBeforeParser;
        private final String[] iParsedForms;
        private final PeriodPrinter iBeforePrinter;
        private volatile PeriodPrinter iAfterPrinter;
        private final boolean iUseAfter;
        private final String iFinalText;
        private final boolean iUseBefore;

        public int calculatePrintedLength(ReadablePeriod arg0, Locale arg1) {
            PeriodPrinter periodPrinter = this.iBeforePrinter;
            PeriodPrinter periodPrinter2 = this.iAfterPrinter;
            int n = periodPrinter.calculatePrintedLength(arg0, arg1) + periodPrinter2.calculatePrintedLength(arg0, arg1);
            if (this.iUseBefore) {
                if (periodPrinter.countFieldsToPrint(arg0, 1, arg1) > 0) {
                    if (this.iUseAfter) {
                        int n2 = periodPrinter2.countFieldsToPrint(arg0, 2, arg1);
                        if (n2 > 0) {
                            n += (n2 > 1 ? this.iText : this.iFinalText).length();
                        }
                    } else {
                        n += this.iText.length();
                    }
                }
            } else if (this.iUseAfter && periodPrinter2.countFieldsToPrint(arg0, 1, arg1) > 0) {
                n += this.iText.length();
            }
            return n;
        }

        public int countFieldsToPrint(ReadablePeriod arg0, int arg1, Locale arg2) {
            int n = this.iBeforePrinter.countFieldsToPrint(arg0, arg1, arg2);
            if (n < arg1) {
                n += this.iAfterPrinter.countFieldsToPrint(arg0, arg1, arg2);
            }
            return n;
        }

        public int parseInto(ReadWritablePeriod arg0, String arg1, int arg2, Locale arg3) {
            int n = arg2;
            if ((arg2 = this.iBeforeParser.parseInto(arg0, arg1, arg2, arg3)) < 0) {
                return arg2;
            }
            boolean bl = false;
            int n2 = -1;
            if (arg2 > n) {
                for (String string : this.iParsedForms) {
                    if (string != null && string.length() != 0 && !arg1.regionMatches(true, arg2, string, 0, string.length())) continue;
                    n2 = string == null ? 0 : string.length();
                    arg2 += n2;
                    bl = true;
                    break;
                }
            }
            n = arg2;
            if ((arg2 = this.iAfterParser.parseInto(arg0, arg1, arg2, arg3)) < 0) {
                return arg2;
            }
            if (bl && arg2 == n && n2 > 0) {
                return ~n;
            }
            if (arg2 > n && !bl && !this.iUseBefore) {
                return ~n;
            }
            return arg2;
        }

        Separator finish(PeriodPrinter a2, PeriodParser a3) {
            Separator a4;
            a4.iAfterPrinter = a2;
            a4.iAfterParser = a3;
            return a4;
        }

        public void printTo(Writer arg0, ReadablePeriod arg1, Locale arg2) throws IOException {
            PeriodPrinter periodPrinter = this.iBeforePrinter;
            PeriodPrinter periodPrinter2 = this.iAfterPrinter;
            periodPrinter.printTo(arg0, arg1, arg2);
            if (this.iUseBefore) {
                if (periodPrinter.countFieldsToPrint(arg1, 1, arg2) > 0) {
                    if (this.iUseAfter) {
                        int n = periodPrinter2.countFieldsToPrint(arg1, 2, arg2);
                        if (n > 0) {
                            arg0.write(n > 1 ? this.iText : this.iFinalText);
                        }
                    } else {
                        arg0.write(this.iText);
                    }
                }
            } else if (this.iUseAfter && periodPrinter2.countFieldsToPrint(arg1, 1, arg2) > 0) {
                arg0.write(this.iText);
            }
            periodPrinter2.printTo(arg0, arg1, arg2);
        }

        Separator(String a2, String a3, String[] a4, PeriodPrinter a5, PeriodParser a6, boolean a7, boolean a8) {
            Separator a9;
            a9.iText = a2;
            a9.iFinalText = a3;
            if (!(a3 != null && !a2.equals(a3) || a4 != null && a4.length != 0)) {
                a9.iParsedForms = new String[]{a2};
            } else {
                TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                treeSet.add(a2);
                treeSet.add(a3);
                if (a4 != null) {
                    int n = a4.length;
                    while (--n >= 0) {
                        treeSet.add(a4[n]);
                    }
                }
                ArrayList arrayList = new ArrayList(treeSet);
                Collections.reverse(arrayList);
                a9.iParsedForms = arrayList.toArray(new String[arrayList.size()]);
            }
            a9.iBeforePrinter = a5;
            a9.iBeforeParser = a6;
            a9.iUseBefore = a7;
            a9.iUseAfter = a8;
        }

        public void printTo(StringBuffer arg0, ReadablePeriod arg1, Locale arg2) {
            PeriodPrinter periodPrinter = this.iBeforePrinter;
            PeriodPrinter periodPrinter2 = this.iAfterPrinter;
            periodPrinter.printTo(arg0, arg1, arg2);
            if (this.iUseBefore) {
                if (periodPrinter.countFieldsToPrint(arg1, 1, arg2) > 0) {
                    if (this.iUseAfter) {
                        int n = periodPrinter2.countFieldsToPrint(arg1, 2, arg2);
                        if (n > 0) {
                            arg0.append(n > 1 ? this.iText : this.iFinalText);
                        }
                    } else {
                        arg0.append(this.iText);
                    }
                }
            } else if (this.iUseAfter && periodPrinter2.countFieldsToPrint(arg1, 1, arg2) > 0) {
                arg0.append(this.iText);
            }
            periodPrinter2.printTo(arg0, arg1, arg2);
        }
    }

    static class Literal
    implements PeriodPrinter,
    PeriodParser {
        static final Literal EMPTY = new Literal("");
        private final String iText;

        public void printTo(Writer arg0, ReadablePeriod arg1, Locale arg2) throws IOException {
            arg0.write(this.iText);
        }

        public int calculatePrintedLength(ReadablePeriod arg0, Locale arg1) {
            return this.iText.length();
        }

        public int parseInto(ReadWritablePeriod arg0, String arg1, int arg2, Locale arg3) {
            if (arg1.regionMatches(true, arg2, this.iText, 0, this.iText.length())) {
                return arg2 + this.iText.length();
            }
            return ~arg2;
        }

        Literal(String a2) {
            Literal a3;
            a3.iText = a2;
        }

        public void printTo(StringBuffer arg0, ReadablePeriod arg1, Locale arg2) {
            arg0.append(this.iText);
        }

        public int countFieldsToPrint(ReadablePeriod arg0, int arg1, Locale arg2) {
            return 0;
        }
    }

    static class FieldFormatter
    implements PeriodPrinter,
    PeriodParser {
        private final int iPrintZeroSetting;
        private final int iMaxParsedDigits;
        private final int iMinPrintedDigits;
        private final PeriodFieldAffix iSuffix;
        private final FieldFormatter[] iFieldFormatters;
        private final PeriodFieldAffix iPrefix;
        private final boolean iRejectSignedValues;
        private final int iFieldType;

        public int parseInto(ReadWritablePeriod arg0, String arg1, int arg2, Locale arg3) {
            int n;
            boolean bl;
            boolean bl2 = bl = this.iPrintZeroSetting == 4;
            if (arg2 >= arg1.length()) {
                return bl ? ~arg2 : arg2;
            }
            if (this.iPrefix != null) {
                if ((arg2 = this.iPrefix.parse(arg1, arg2)) >= 0) {
                    bl = true;
                } else {
                    if (!bl) {
                        return ~arg2;
                    }
                    return arg2;
                }
            }
            int n2 = -1;
            if (this.iSuffix != null && !bl) {
                n2 = this.iSuffix.scan(arg1, arg2);
                if (n2 >= 0) {
                    bl = true;
                } else {
                    if (!bl) {
                        return ~n2;
                    }
                    return n2;
                }
            }
            if (!bl && !this.isSupported(arg0.getPeriodType(), this.iFieldType)) {
                return arg2;
            }
            int n3 = n2 > 0 ? Math.min(this.iMaxParsedDigits, n2 - arg2) : Math.min(this.iMaxParsedDigits, arg1.length() - arg2);
            int n4 = 0;
            int n5 = -1;
            boolean bl3 = false;
            boolean bl4 = false;
            while (n4 < n3) {
                n = arg1.charAt(arg2 + n4);
                if (!(n4 != 0 || n != 45 && n != 43 || this.iRejectSignedValues)) {
                    boolean bl5 = bl4 = n == 45;
                    if (n4 + 1 >= n3) break;
                    char c2 = arg1.charAt(arg2 + n4 + 1);
                    n = c2;
                    if (c2 < '0' || n > 57) break;
                    if (bl4) {
                        ++n4;
                    } else {
                        ++arg2;
                    }
                    n3 = Math.min(n3 + 1, arg1.length() - arg2);
                    continue;
                }
                if (n >= 48 && n <= 57) {
                    bl3 = true;
                } else {
                    if (n != 46 && n != 44 || this.iFieldType != 8 && this.iFieldType != 9 || n5 >= 0) break;
                    n5 = arg2 + n4 + 1;
                    n3 = Math.min(n3 + 1, arg1.length() - arg2);
                }
                ++n4;
            }
            if (!bl3) {
                return ~arg2;
            }
            if (n2 >= 0 && arg2 + n4 != n2) {
                return arg2;
            }
            if (this.iFieldType != 8 && this.iFieldType != 9) {
                this.setFieldValue(arg0, this.iFieldType, this.parseInt(arg1, arg2, n4));
            } else if (n5 < 0) {
                this.setFieldValue(arg0, 6, this.parseInt(arg1, arg2, n4));
                this.setFieldValue(arg0, 7, 0);
            } else {
                int n6;
                n = this.parseInt(arg1, arg2, n5 - arg2 - 1);
                this.setFieldValue(arg0, 6, n);
                int n7 = arg2 + n4 - n5;
                if (n7 <= 0) {
                    n6 = 0;
                } else {
                    if (n7 >= 3) {
                        n6 = this.parseInt(arg1, n5, 3);
                    } else {
                        n6 = this.parseInt(arg1, n5, n7);
                        n6 = n7 == 1 ? (n6 *= 100) : (n6 *= 10);
                    }
                    if (bl4 || n < 0) {
                        n6 = -n6;
                    }
                }
                this.setFieldValue(arg0, 7, n6);
            }
            if ((arg2 += n4) >= 0 && this.iSuffix != null) {
                arg2 = this.iSuffix.parse(arg1, arg2);
            }
            return arg2;
        }

        public void printTo(Writer arg0, ReadablePeriod arg1, Locale arg2) throws IOException {
            int n;
            long l2 = this.getFieldValue(arg1);
            if (l2 == Long.MAX_VALUE) {
                return;
            }
            int n2 = (int)l2;
            if (this.iFieldType >= 8) {
                n2 = (int)(l2 / 1000L);
            }
            if (this.iPrefix != null) {
                this.iPrefix.printTo(arg0, n2);
            }
            if ((n = this.iMinPrintedDigits) <= 1) {
                FormatUtils.writeUnpaddedInteger(arg0, n2);
            } else {
                FormatUtils.writePaddedInteger(arg0, n2, n);
            }
            if (this.iFieldType >= 8) {
                int n3 = (int)(Math.abs(l2) % 1000L);
                if (this.iFieldType == 8 || n3 > 0) {
                    arg0.write(46);
                    FormatUtils.writePaddedInteger(arg0, n3, 3);
                }
            }
            if (this.iSuffix != null) {
                this.iSuffix.printTo(arg0, n2);
            }
        }

        public void finish(FieldFormatter[] arg0) {
            HashSet<PeriodFieldAffix> hashSet = new HashSet<PeriodFieldAffix>();
            HashSet<PeriodFieldAffix> hashSet2 = new HashSet<PeriodFieldAffix>();
            for (FieldFormatter fieldFormatter : arg0) {
                if (fieldFormatter == null || this.equals(fieldFormatter)) continue;
                hashSet.add(fieldFormatter.iPrefix);
                hashSet2.add(fieldFormatter.iSuffix);
            }
            if (this.iPrefix != null) {
                this.iPrefix.finish(hashSet);
            }
            if (this.iSuffix != null) {
                this.iSuffix.finish(hashSet2);
            }
        }

        int getFieldType() {
            FieldFormatter a2;
            return a2.iFieldType;
        }

        private int parseInt(String a2, int a3, int a4) {
            boolean bl;
            if (a4 >= 10) {
                return Integer.parseInt(a2.substring(a3, a3 + a4));
            }
            if (a4 <= 0) {
                return 0;
            }
            int n = a2.charAt(a3++);
            --a4;
            if (n == 45) {
                if (--a4 < 0) {
                    return 0;
                }
                bl = true;
                n = a2.charAt(a3++);
            } else {
                bl = false;
            }
            n -= 48;
            while (a4-- > 0) {
                n = (n << 3) + (n << 1) + a2.charAt(a3++) - 48;
            }
            return bl ? -n : n;
        }

        public void printTo(StringBuffer arg0, ReadablePeriod arg1, Locale arg2) {
            long l2 = this.getFieldValue(arg1);
            if (l2 == Long.MAX_VALUE) {
                return;
            }
            int n = (int)l2;
            if (this.iFieldType >= 8) {
                n = (int)(l2 / 1000L);
            }
            if (this.iPrefix != null) {
                this.iPrefix.printTo(arg0, n);
            }
            int n2 = arg0.length();
            int n3 = this.iMinPrintedDigits;
            if (n3 <= 1) {
                FormatUtils.appendUnpaddedInteger(arg0, n);
            } else {
                FormatUtils.appendPaddedInteger(arg0, n, n3);
            }
            if (this.iFieldType >= 8) {
                int n4 = (int)(Math.abs(l2) % 1000L);
                if (this.iFieldType == 8 || n4 > 0) {
                    if (l2 < 0L && l2 > -1000L) {
                        arg0.insert(n2, '-');
                    }
                    arg0.append('.');
                    FormatUtils.appendPaddedInteger(arg0, n4, 3);
                }
            }
            if (this.iSuffix != null) {
                this.iSuffix.printTo(arg0, n);
            }
        }

        FieldFormatter(int a2, int a3, int a4, boolean a5, int a6, FieldFormatter[] a7, PeriodFieldAffix a8, PeriodFieldAffix a9) {
            FieldFormatter a10;
            a10.iMinPrintedDigits = a2;
            a10.iPrintZeroSetting = a3;
            a10.iMaxParsedDigits = a4;
            a10.iRejectSignedValues = a5;
            a10.iFieldType = a6;
            a10.iFieldFormatters = a7;
            a10.iPrefix = a8;
            a10.iSuffix = a9;
        }

        public int calculatePrintedLength(ReadablePeriod arg0, Locale arg1) {
            long l2 = this.getFieldValue(arg0);
            if (l2 == Long.MAX_VALUE) {
                return 0;
            }
            int n = Math.max(FormatUtils.calculateDigitCount(l2), this.iMinPrintedDigits);
            if (this.iFieldType >= 8) {
                n = l2 < 0L ? Math.max(n, 5) : Math.max(n, 4);
                ++n;
                if (this.iFieldType == 9 && Math.abs(l2) % 1000L == 0L) {
                    n -= 4;
                }
                l2 /= 1000L;
            }
            int n2 = (int)l2;
            if (this.iPrefix != null) {
                n += this.iPrefix.calculatePrintedLength(n2);
            }
            if (this.iSuffix != null) {
                n += this.iSuffix.calculatePrintedLength(n2);
            }
            return n;
        }

        boolean isSupported(PeriodType a2, int a3) {
            switch (a3) {
                default: {
                    return false;
                }
                case 0: {
                    return a2.isSupported(DurationFieldType.years());
                }
                case 1: {
                    return a2.isSupported(DurationFieldType.months());
                }
                case 2: {
                    return a2.isSupported(DurationFieldType.weeks());
                }
                case 3: {
                    return a2.isSupported(DurationFieldType.days());
                }
                case 4: {
                    return a2.isSupported(DurationFieldType.hours());
                }
                case 5: {
                    return a2.isSupported(DurationFieldType.minutes());
                }
                case 6: {
                    return a2.isSupported(DurationFieldType.seconds());
                }
                case 7: {
                    return a2.isSupported(DurationFieldType.millis());
                }
                case 8: 
                case 9: 
            }
            return a2.isSupported(DurationFieldType.seconds()) || a2.isSupported(DurationFieldType.millis());
        }

        public int countFieldsToPrint(ReadablePeriod arg0, int arg1, Locale arg2) {
            if (arg1 <= 0) {
                return 0;
            }
            if (this.iPrintZeroSetting == 4 || this.getFieldValue(arg0) != Long.MAX_VALUE) {
                return 1;
            }
            return 0;
        }

        FieldFormatter(FieldFormatter a2, PeriodFieldAffix a3) {
            FieldFormatter a4;
            a4.iMinPrintedDigits = a2.iMinPrintedDigits;
            a4.iPrintZeroSetting = a2.iPrintZeroSetting;
            a4.iMaxParsedDigits = a2.iMaxParsedDigits;
            a4.iRejectSignedValues = a2.iRejectSignedValues;
            a4.iFieldType = a2.iFieldType;
            a4.iFieldFormatters = a2.iFieldFormatters;
            a4.iPrefix = a2.iPrefix;
            if (a2.iSuffix != null) {
                a3 = new CompositeAffix(a2.iSuffix, a3);
            }
            a4.iSuffix = a3;
        }

        void setFieldValue(ReadWritablePeriod a2, int a3, int a4) {
            switch (a3) {
                default: {
                    break;
                }
                case 0: {
                    a2.setYears(a4);
                    break;
                }
                case 1: {
                    a2.setMonths(a4);
                    break;
                }
                case 2: {
                    a2.setWeeks(a4);
                    break;
                }
                case 3: {
                    a2.setDays(a4);
                    break;
                }
                case 4: {
                    a2.setHours(a4);
                    break;
                }
                case 5: {
                    a2.setMinutes(a4);
                    break;
                }
                case 6: {
                    a2.setSeconds(a4);
                    break;
                }
                case 7: {
                    a2.setMillis(a4);
                }
            }
        }

        long getFieldValue(ReadablePeriod a2) {
            int n;
            long l2;
            FieldFormatter a3;
            PeriodType periodType = a3.iPrintZeroSetting == 4 ? null : a2.getPeriodType();
            if (periodType != null && !a3.isSupported(periodType, a3.iFieldType)) {
                return Long.MAX_VALUE;
            }
            switch (a3.iFieldType) {
                default: {
                    return Long.MAX_VALUE;
                }
                case 0: {
                    l2 = a2.get(DurationFieldType.years());
                    break;
                }
                case 1: {
                    l2 = a2.get(DurationFieldType.months());
                    break;
                }
                case 2: {
                    l2 = a2.get(DurationFieldType.weeks());
                    break;
                }
                case 3: {
                    l2 = a2.get(DurationFieldType.days());
                    break;
                }
                case 4: {
                    l2 = a2.get(DurationFieldType.hours());
                    break;
                }
                case 5: {
                    l2 = a2.get(DurationFieldType.minutes());
                    break;
                }
                case 6: {
                    l2 = a2.get(DurationFieldType.seconds());
                    break;
                }
                case 7: {
                    l2 = a2.get(DurationFieldType.millis());
                    break;
                }
                case 8: 
                case 9: {
                    n = a2.get(DurationFieldType.seconds());
                    int n2 = a2.get(DurationFieldType.millis());
                    l2 = (long)n * 1000L + (long)n2;
                }
            }
            if (l2 == 0L) {
                switch (a3.iPrintZeroSetting) {
                    case 5: {
                        return Long.MAX_VALUE;
                    }
                    case 2: {
                        if (a3.isZero(a2) && a3.iFieldFormatters[a3.iFieldType] == a3) {
                            for (n = a3.iFieldType + 1; n <= 9; ++n) {
                                if (!a3.isSupported(periodType, n) || a3.iFieldFormatters[n] == null) continue;
                                return Long.MAX_VALUE;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                    case 1: {
                        if (a3.isZero(a2) && a3.iFieldFormatters[a3.iFieldType] == a3) {
                            n = Math.min(a3.iFieldType, 8);
                            --n;
                            while (n >= 0 && n <= 9) {
                                if (a3.isSupported(periodType, n) && a3.iFieldFormatters[n] != null) {
                                    return Long.MAX_VALUE;
                                }
                                --n;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                }
            }
            return l2;
        }

        boolean isZero(ReadablePeriod a2) {
            int n = a2.size();
            for (int i2 = 0; i2 < n; ++i2) {
                if (a2.getValue(i2) == 0) continue;
                return false;
            }
            return true;
        }
    }

    static class CompositeAffix
    extends IgnorableAffix {
        private final PeriodFieldAffix iRight;
        private final PeriodFieldAffix iLeft;
        private final String[] iLeftRightCombinations;

        public void printTo(StringBuffer arg0, int arg1) {
            this.iLeft.printTo(arg0, arg1);
            this.iRight.printTo(arg0, arg1);
        }

        public int parse(String arg0, int arg1) {
            int n = this.iLeft.parse(arg0, arg1);
            if (n >= 0 && (n = this.iRight.parse(arg0, n)) >= 0 && this.matchesOtherAffix(this.parse(arg0, n) - n, arg0, arg1)) {
                return ~arg1;
            }
            return n;
        }

        public int calculatePrintedLength(int arg0) {
            return this.iLeft.calculatePrintedLength(arg0) + this.iRight.calculatePrintedLength(arg0);
        }

        public int scan(String arg0, int arg1) {
            int n;
            int n2 = this.iLeft.scan(arg0, arg1);
            if (!(n2 < 0 || (n = this.iRight.scan(arg0, this.iLeft.parse(arg0, n2))) >= 0 && this.matchesOtherAffix(this.iRight.parse(arg0, n) - n2, arg0, arg1))) {
                if (n2 > 0) {
                    return n2;
                }
                return n;
            }
            return ~arg1;
        }

        CompositeAffix(PeriodFieldAffix a2, PeriodFieldAffix a3) {
            CompositeAffix a4;
            a4.iLeft = a2;
            a4.iRight = a3;
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : a4.iLeft.getAffixes()) {
                for (String string2 : a4.iRight.getAffixes()) {
                    hashSet.add(string + string2);
                }
            }
            a4.iLeftRightCombinations = hashSet.toArray(new String[hashSet.size()]);
        }

        public String[] getAffixes() {
            return (String[])this.iLeftRightCombinations.clone();
        }

        public void printTo(Writer arg0, int arg1) throws IOException {
            this.iLeft.printTo(arg0, arg1);
            this.iRight.printTo(arg0, arg1);
        }
    }

    static class RegExAffix
    extends IgnorableAffix {
        private final String[] iSuffixesSortedDescByLength;
        private final Pattern[] iPatterns;
        private static final Comparator<String> LENGTH_DESC_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg1.length() - arg0.length();
            }
            {
                1 a2;
            }
        };
        private final String[] iSuffixes;

        public String[] getAffixes() {
            return (String[])this.iSuffixes.clone();
        }

        public void printTo(Writer arg0, int arg1) throws IOException {
            arg0.write(this.iSuffixes[this.selectSuffixIndex(arg1)]);
        }

        public int calculatePrintedLength(int arg0) {
            return this.iSuffixes[this.selectSuffixIndex(arg0)].length();
        }

        public int parse(String arg0, int arg1) {
            for (String string : this.iSuffixesSortedDescByLength) {
                if (!arg0.regionMatches(true, arg1, string, 0, string.length()) || this.matchesOtherAffix(string.length(), arg0, arg1)) continue;
                return arg1 + string.length();
            }
            return ~arg1;
        }

        RegExAffix(String[] a2, String[] a3) {
            RegExAffix a4;
            a4.iSuffixes = (String[])a3.clone();
            a4.iPatterns = new Pattern[a2.length];
            for (int i2 = 0; i2 < a2.length; ++i2) {
                Pattern pattern = (Pattern)PATTERNS.get(a2[i2]);
                if (pattern == null) {
                    pattern = Pattern.compile(a2[i2]);
                    PATTERNS.putIfAbsent(a2[i2], pattern);
                }
                a4.iPatterns[i2] = pattern;
            }
            a4.iSuffixesSortedDescByLength = (String[])a4.iSuffixes.clone();
            Arrays.sort(a4.iSuffixesSortedDescByLength, LENGTH_DESC_COMPARATOR);
        }

        public void printTo(StringBuffer arg0, int arg1) {
            arg0.append(this.iSuffixes[this.selectSuffixIndex(arg1)]);
        }

        public int scan(String arg0, int arg1) {
            int n = arg0.length();
            for (int i2 = arg1; i2 < n; ++i2) {
                for (String string : this.iSuffixesSortedDescByLength) {
                    if (!arg0.regionMatches(true, i2, string, 0, string.length()) || this.matchesOtherAffix(string.length(), arg0, i2)) continue;
                    return i2;
                }
            }
            return ~arg1;
        }

        private int selectSuffixIndex(int a2) {
            RegExAffix a3;
            String string = String.valueOf(a2);
            for (int i2 = 0; i2 < a3.iPatterns.length; ++i2) {
                if (!a3.iPatterns[i2].matcher(string).matches()) continue;
                return i2;
            }
            return a3.iPatterns.length - 1;
        }
    }

    static class PluralAffix
    extends IgnorableAffix {
        private final String iSingularText;
        private final String iPluralText;

        public String[] getAffixes() {
            return new String[]{this.iSingularText, this.iPluralText};
        }

        public int calculatePrintedLength(int arg0) {
            return (arg0 == 1 ? this.iSingularText : this.iPluralText).length();
        }

        public int parse(String arg0, int arg1) {
            String string = this.iPluralText;
            String string2 = this.iSingularText;
            if (string.length() < string2.length()) {
                String string3 = string;
                string = string2;
                string2 = string3;
            }
            if (arg0.regionMatches(true, arg1, string, 0, string.length()) && !this.matchesOtherAffix(string.length(), arg0, arg1)) {
                return arg1 + string.length();
            }
            if (arg0.regionMatches(true, arg1, string2, 0, string2.length()) && !this.matchesOtherAffix(string2.length(), arg0, arg1)) {
                return arg1 + string2.length();
            }
            return ~arg1;
        }

        public int scan(String arg0, int arg1) {
            String string = this.iPluralText;
            String string2 = this.iSingularText;
            if (string.length() < string2.length()) {
                String string3 = string;
                string = string2;
                string2 = string3;
            }
            int n = string.length();
            int n2 = string2.length();
            int n3 = arg0.length();
            for (int i2 = arg1; i2 < n3; ++i2) {
                if (arg0.regionMatches(true, i2, string, 0, n) && !this.matchesOtherAffix(string.length(), arg0, i2)) {
                    return i2;
                }
                if (!arg0.regionMatches(true, i2, string2, 0, n2) || this.matchesOtherAffix(string2.length(), arg0, i2)) continue;
                return i2;
            }
            return ~arg1;
        }

        PluralAffix(String a2, String a3) {
            PluralAffix a4;
            a4.iSingularText = a2;
            a4.iPluralText = a3;
        }

        public void printTo(StringBuffer arg0, int arg1) {
            arg0.append(arg1 == 1 ? this.iSingularText : this.iPluralText);
        }

        public void printTo(Writer arg0, int arg1) throws IOException {
            arg0.write(arg1 == 1 ? this.iSingularText : this.iPluralText);
        }
    }

    static class SimpleAffix
    extends IgnorableAffix {
        private final String iText;

        public int calculatePrintedLength(int arg0) {
            return this.iText.length();
        }

        public void printTo(StringBuffer arg0, int arg1) {
            arg0.append(this.iText);
        }

        SimpleAffix(String a2) {
            SimpleAffix a3;
            a3.iText = a2;
        }

        public int scan(String arg0, int arg1) {
            String string = this.iText;
            int n = string.length();
            int n2 = arg0.length();
            block3: for (int i2 = arg1; i2 < n2; ++i2) {
                if (arg0.regionMatches(true, i2, string, 0, n) && !this.matchesOtherAffix(n, arg0, i2)) {
                    return i2;
                }
                switch (arg0.charAt(i2)) {
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        continue block3;
                    }
                }
            }
            return ~arg1;
        }

        public int parse(String arg0, int arg1) {
            String string = this.iText;
            int n = string.length();
            if (arg0.regionMatches(true, arg1, string, 0, n) && !this.matchesOtherAffix(n, arg0, arg1)) {
                return arg1 + n;
            }
            return ~arg1;
        }

        public String[] getAffixes() {
            return new String[]{this.iText};
        }

        public void printTo(Writer arg0, int arg1) throws IOException {
            arg0.write(this.iText);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class IgnorableAffix
    implements PeriodFieldAffix {
        private volatile String[] iOtherAffixes;

        protected boolean matchesOtherAffix(int arg0, String arg1, int arg2) {
            if (this.iOtherAffixes != null) {
                for (String string : this.iOtherAffixes) {
                    int n = string.length();
                    if ((arg0 >= n || !arg1.regionMatches(true, arg2, string, 0, n)) && (arg0 != n || !arg1.regionMatches(false, arg2, string, 0, n))) continue;
                    return true;
                }
            }
            return false;
        }

        IgnorableAffix() {
            IgnorableAffix a2;
        }

        @Override
        public void finish(Set<PeriodFieldAffix> arg0) {
            if (this.iOtherAffixes == null) {
                int n = Integer.MAX_VALUE;
                String stringArray = null;
                for (String stringArray2 : this.getAffixes()) {
                    if (stringArray2.length() >= n) continue;
                    n = stringArray2.length();
                    stringArray = stringArray2;
                }
                HashSet hashSet = new HashSet();
                for (PeriodFieldAffix periodFieldAffix : arg0) {
                    if (periodFieldAffix == null) continue;
                    for (String string : periodFieldAffix.getAffixes()) {
                        if (string.length() <= n && (!string.equalsIgnoreCase(stringArray) || string.equals(stringArray))) continue;
                        hashSet.add(string);
                    }
                }
                this.iOtherAffixes = hashSet.toArray(new String[hashSet.size()]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface PeriodFieldAffix {
        public void finish(Set<PeriodFieldAffix> var1);

        public int calculatePrintedLength(int var1);

        public void printTo(Writer var1, int var2) throws IOException;

        public int parse(String var1, int var2);

        public String[] getAffixes();

        public void printTo(StringBuffer var1, int var2);

        public int scan(String var1, int var2);
    }
}

