/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

public class PeriodFormat {
    private static final String BUNDLE_NAME = "org.joda.time.format.messages";
    private static final ConcurrentMap<Locale, PeriodFormatter> FORMATTERS = new ConcurrentHashMap<Locale, PeriodFormatter>();

    public static PeriodFormatter wordBased(Locale arg0) {
        DynamicWordBased dynamicWordBased;
        PeriodFormatter periodFormatter;
        PeriodFormatter periodFormatter2 = (PeriodFormatter)FORMATTERS.get(arg0);
        if (periodFormatter2 == null && (periodFormatter = FORMATTERS.putIfAbsent(arg0, periodFormatter2 = new PeriodFormatter(dynamicWordBased = new DynamicWordBased(PeriodFormat.buildWordBased(arg0)), dynamicWordBased, arg0, null))) != null) {
            periodFormatter2 = periodFormatter;
        }
        return periodFormatter2;
    }

    private static boolean containsKey(ResourceBundle a2, String a3) {
        Enumeration<String> enumeration = a2.getKeys();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(a3)) continue;
            return true;
        }
        return false;
    }

    private static PeriodFormatter buildWordBased(Locale a2) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, a2);
        if (PeriodFormat.containsKey(resourceBundle, "PeriodFormat.regex.separator")) {
            return PeriodFormat.buildRegExFormatter(resourceBundle, a2);
        }
        return PeriodFormat.buildNonRegExFormatter(resourceBundle, a2);
    }

    private static PeriodFormatter buildRegExFormatter(ResourceBundle a2, Locale a3) {
        String[] stringArray = PeriodFormat.retrieveVariants(a2);
        String string = a2.getString("PeriodFormat.regex.separator");
        PeriodFormatterBuilder periodFormatterBuilder = new PeriodFormatterBuilder();
        periodFormatterBuilder.appendYears();
        if (PeriodFormat.containsKey(a2, "PeriodFormat.years.regex")) {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.years.regex").split(string), a2.getString("PeriodFormat.years.list").split(string));
        } else {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.year"), a2.getString("PeriodFormat.years"));
        }
        periodFormatterBuilder.appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray);
        periodFormatterBuilder.appendMonths();
        if (PeriodFormat.containsKey(a2, "PeriodFormat.months.regex")) {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.months.regex").split(string), a2.getString("PeriodFormat.months.list").split(string));
        } else {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.month"), a2.getString("PeriodFormat.months"));
        }
        periodFormatterBuilder.appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray);
        periodFormatterBuilder.appendWeeks();
        if (PeriodFormat.containsKey(a2, "PeriodFormat.weeks.regex")) {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.weeks.regex").split(string), a2.getString("PeriodFormat.weeks.list").split(string));
        } else {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.week"), a2.getString("PeriodFormat.weeks"));
        }
        periodFormatterBuilder.appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray);
        periodFormatterBuilder.appendDays();
        if (PeriodFormat.containsKey(a2, "PeriodFormat.days.regex")) {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.days.regex").split(string), a2.getString("PeriodFormat.days.list").split(string));
        } else {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.day"), a2.getString("PeriodFormat.days"));
        }
        periodFormatterBuilder.appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray);
        periodFormatterBuilder.appendHours();
        if (PeriodFormat.containsKey(a2, "PeriodFormat.hours.regex")) {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.hours.regex").split(string), a2.getString("PeriodFormat.hours.list").split(string));
        } else {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.hour"), a2.getString("PeriodFormat.hours"));
        }
        periodFormatterBuilder.appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray);
        periodFormatterBuilder.appendMinutes();
        if (PeriodFormat.containsKey(a2, "PeriodFormat.minutes.regex")) {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.minutes.regex").split(string), a2.getString("PeriodFormat.minutes.list").split(string));
        } else {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.minute"), a2.getString("PeriodFormat.minutes"));
        }
        periodFormatterBuilder.appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray);
        periodFormatterBuilder.appendSeconds();
        if (PeriodFormat.containsKey(a2, "PeriodFormat.seconds.regex")) {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.seconds.regex").split(string), a2.getString("PeriodFormat.seconds.list").split(string));
        } else {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.second"), a2.getString("PeriodFormat.seconds"));
        }
        periodFormatterBuilder.appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray);
        periodFormatterBuilder.appendMillis();
        if (PeriodFormat.containsKey(a2, "PeriodFormat.milliseconds.regex")) {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.milliseconds.regex").split(string), a2.getString("PeriodFormat.milliseconds.list").split(string));
        } else {
            periodFormatterBuilder.appendSuffix(a2.getString("PeriodFormat.millisecond"), a2.getString("PeriodFormat.milliseconds"));
        }
        return periodFormatterBuilder.toFormatter().withLocale(a3);
    }

    public static PeriodFormatter getDefault() {
        return PeriodFormat.wordBased(Locale.ENGLISH);
    }

    private static String[] retrieveVariants(ResourceBundle a2) {
        return new String[]{a2.getString("PeriodFormat.space"), a2.getString("PeriodFormat.comma"), a2.getString("PeriodFormat.commandand"), a2.getString("PeriodFormat.commaspaceand")};
    }

    public static PeriodFormatter wordBased() {
        return PeriodFormat.wordBased(Locale.getDefault());
    }

    private static PeriodFormatter buildNonRegExFormatter(ResourceBundle a2, Locale a3) {
        String[] stringArray = PeriodFormat.retrieveVariants(a2);
        return new PeriodFormatterBuilder().appendYears().appendSuffix(a2.getString("PeriodFormat.year"), a2.getString("PeriodFormat.years")).appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray).appendMonths().appendSuffix(a2.getString("PeriodFormat.month"), a2.getString("PeriodFormat.months")).appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray).appendWeeks().appendSuffix(a2.getString("PeriodFormat.week"), a2.getString("PeriodFormat.weeks")).appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray).appendDays().appendSuffix(a2.getString("PeriodFormat.day"), a2.getString("PeriodFormat.days")).appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray).appendHours().appendSuffix(a2.getString("PeriodFormat.hour"), a2.getString("PeriodFormat.hours")).appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray).appendMinutes().appendSuffix(a2.getString("PeriodFormat.minute"), a2.getString("PeriodFormat.minutes")).appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray).appendSeconds().appendSuffix(a2.getString("PeriodFormat.second"), a2.getString("PeriodFormat.seconds")).appendSeparator(a2.getString("PeriodFormat.commaspace"), a2.getString("PeriodFormat.spaceandspace"), stringArray).appendMillis().appendSuffix(a2.getString("PeriodFormat.millisecond"), a2.getString("PeriodFormat.milliseconds")).toFormatter().withLocale(a3);
    }

    protected PeriodFormat() {
    }

    static class DynamicWordBased
    implements PeriodPrinter,
    PeriodParser {
        private final PeriodFormatter iFormatter;

        private PeriodParser getParser(Locale a2) {
            DynamicWordBased a3;
            if (a2 != null && !a2.equals(a3.iFormatter.getLocale())) {
                return PeriodFormat.wordBased(a2).getParser();
            }
            return a3.iFormatter.getParser();
        }

        public void printTo(StringBuffer arg0, ReadablePeriod arg1, Locale arg2) {
            this.getPrinter(arg2).printTo(arg0, arg1, arg2);
        }

        public int countFieldsToPrint(ReadablePeriod arg0, int arg1, Locale arg2) {
            return this.getPrinter(arg2).countFieldsToPrint(arg0, arg1, arg2);
        }

        private PeriodPrinter getPrinter(Locale a2) {
            DynamicWordBased a3;
            if (a2 != null && !a2.equals(a3.iFormatter.getLocale())) {
                return PeriodFormat.wordBased(a2).getPrinter();
            }
            return a3.iFormatter.getPrinter();
        }

        DynamicWordBased(PeriodFormatter a2) {
            DynamicWordBased a3;
            a3.iFormatter = a2;
        }

        public int calculatePrintedLength(ReadablePeriod arg0, Locale arg1) {
            return this.getPrinter(arg1).calculatePrintedLength(arg0, arg1);
        }

        public int parseInto(ReadWritablePeriod arg0, String arg1, int arg2, Locale arg3) {
            return this.getParser(arg3).parseInto(arg0, arg1, arg2, arg3);
        }

        public void printTo(Writer arg0, ReadablePeriod arg1, Locale arg2) throws IOException {
            this.getPrinter(arg2).printTo(arg0, arg1, arg2);
        }
    }
}

