/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.Arrays;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.IllegalInstantException;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserInternalParser;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.InternalParser;

public class DateTimeParserBucket {
    private final Integer iDefaultPivotYear;
    private final long iMillis;
    private final DateTimeZone iDefaultZone;
    private final Locale iLocale;
    private final int iDefaultYear;
    private Object iSavedState;
    private Integer iPivotYear;
    private boolean iSavedFieldsShared;
    private final Chronology iChrono;
    private DateTimeZone iZone;
    private int iSavedFieldsCount;
    private Integer iOffset;
    private SavedField[] iSavedFields;

    public void reset() {
        this.iZone = this.iDefaultZone;
        this.iOffset = null;
        this.iPivotYear = this.iDefaultPivotYear;
        this.iSavedFieldsCount = 0;
        this.iSavedFieldsShared = false;
        this.iSavedState = null;
    }

    public void saveField(DateTimeFieldType arg0, int arg1) {
        this.obtainSaveField().init(arg0.getField(this.iChrono), arg1);
    }

    public boolean restoreState(Object arg0) {
        if (arg0 instanceof SavedState && ((SavedState)arg0).restoreState(this)) {
            this.iSavedState = arg0;
            return true;
        }
        return false;
    }

    static int compareReverse(DurationField a2, DurationField a3) {
        if (a2 == null || !a2.isSupported()) {
            if (a3 == null || !a3.isSupported()) {
                return 0;
            }
            return -1;
        }
        if (a3 == null || !a3.isSupported()) {
            return 1;
        }
        return -a2.compareTo(a3);
    }

    public DateTimeParserBucket(long arg0, Chronology arg1, Locale arg2, Integer arg3, int arg4) {
        arg1 = DateTimeUtils.getChronology(arg1);
        this.iMillis = arg0;
        this.iDefaultZone = arg1.getZone();
        this.iChrono = arg1.withUTC();
        this.iLocale = arg2 == null ? Locale.getDefault() : arg2;
        this.iDefaultYear = arg4;
        this.iDefaultPivotYear = arg3;
        this.iZone = this.iDefaultZone;
        this.iPivotYear = this.iDefaultPivotYear;
        this.iSavedFields = new SavedField[8];
    }

    public long computeMillis(boolean arg0, CharSequence arg1) {
        int n;
        SavedField[] savedFieldArray = this.iSavedFields;
        int n2 = this.iSavedFieldsCount;
        if (this.iSavedFieldsShared) {
            savedFieldArray = (SavedField[])this.iSavedFields.clone();
            this.iSavedFields = savedFieldArray;
            this.iSavedFieldsShared = false;
        }
        DateTimeParserBucket.sort(savedFieldArray, n2);
        if (n2 > 0) {
            DurationField durationField = DurationFieldType.months().getField(this.iChrono);
            DurationField durationField2 = DurationFieldType.days().getField(this.iChrono);
            DurationField durationField3 = savedFieldArray[0].iField.getDurationField();
            if (DateTimeParserBucket.compareReverse(durationField3, durationField) >= 0 && DateTimeParserBucket.compareReverse(durationField3, durationField2) <= 0) {
                this.saveField(DateTimeFieldType.year(), this.iDefaultYear);
                return this.computeMillis(arg0, arg1);
            }
        }
        long l2 = this.iMillis;
        try {
            for (n = 0; n < n2; ++n) {
                l2 = savedFieldArray[n].set(l2, arg0);
            }
            if (arg0) {
                for (n = 0; n < n2; ++n) {
                    l2 = savedFieldArray[n].set(l2, n == n2 - 1);
                }
            }
        }
        catch (IllegalFieldValueException illegalFieldValueException) {
            if (arg1 != null) {
                illegalFieldValueException.prependMessage("Cannot parse \"" + arg1 + '\"');
            }
            throw illegalFieldValueException;
        }
        if (this.iOffset != null) {
            l2 -= (long)this.iOffset.intValue();
        } else if (this.iZone != null && (n = this.iZone.getOffsetFromLocal(l2)) != this.iZone.getOffset(l2 -= (long)n)) {
            String string = "Illegal instant due to time zone offset transition (" + this.iZone + ')';
            if (arg1 != null) {
                string = "Cannot parse \"" + arg1 + "\": " + string;
            }
            throw new IllegalInstantException(string);
        }
        return l2;
    }

    long doParseMillis(InternalParser a2, CharSequence a3) {
        DateTimeParserBucket a4;
        int n = a2.parseInto(a4, a3, 0);
        if (n >= 0) {
            if (n >= a3.length()) {
                return a4.computeMillis(true, a3);
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(((Object)a3).toString(), n));
    }

    public void saveField(DateTimeField arg0, int arg1) {
        this.obtainSaveField().init(arg0, arg1);
    }

    public Integer getPivotYear() {
        return this.iPivotYear;
    }

    public long computeMillis() {
        return this.computeMillis(false, (CharSequence)null);
    }

    public Chronology getChronology() {
        return this.iChrono;
    }

    public long computeMillis(boolean arg0, String arg1) {
        return this.computeMillis(arg0, (CharSequence)arg1);
    }

    public Integer getOffsetInteger() {
        return this.iOffset;
    }

    public void saveField(DateTimeFieldType arg0, String arg1, Locale arg2) {
        this.obtainSaveField().init(arg0.getField(this.iChrono), arg1, arg2);
    }

    static /* synthetic */ SavedField[] access$202(DateTimeParserBucket a2, SavedField[] a3) {
        a2.iSavedFields = a3;
        return a3;
    }

    private static void sort(SavedField[] a2, int a3) {
        if (a3 > 10) {
            Arrays.sort(a2, 0, a3);
        } else {
            for (int i2 = 0; i2 < a3; ++i2) {
                for (int i3 = i2; i3 > 0 && a2[i3 - 1].compareTo(a2[i3]) > 0; --i3) {
                    SavedField savedField = a2[i3];
                    a2[i3] = a2[i3 - 1];
                    a2[i3 - 1] = savedField;
                }
            }
        }
    }

    @Deprecated
    public void setPivotYear(Integer arg0) {
        this.iPivotYear = arg0;
    }

    public long computeMillis(boolean arg0) {
        return this.computeMillis(arg0, (CharSequence)null);
    }

    public void setZone(DateTimeZone arg0) {
        this.iSavedState = null;
        this.iZone = arg0;
    }

    public long parseMillis(DateTimeParser arg0, CharSequence arg1) {
        this.reset();
        return this.doParseMillis(DateTimeParserInternalParser.of(arg0), arg1);
    }

    @Deprecated
    public DateTimeParserBucket(long arg0, Chronology arg1, Locale arg2, Integer arg3) {
        this(arg0, arg1, arg2, arg3, 2000);
    }

    public Object saveState() {
        if (this.iSavedState == null) {
            this.iSavedState = new SavedState();
        }
        return this.iSavedState;
    }

    public void setOffset(Integer arg0) {
        this.iSavedState = null;
        this.iOffset = arg0;
    }

    public DateTimeZone getZone() {
        return this.iZone;
    }

    @Deprecated
    public void setOffset(int arg0) {
        this.iSavedState = null;
        this.iOffset = arg0;
    }

    private SavedField obtainSaveField() {
        Object object;
        DateTimeParserBucket a2;
        int n = a2.iSavedFieldsCount;
        SavedField[] savedFieldArray = a2.iSavedFields;
        if (n == savedFieldArray.length || a2.iSavedFieldsShared) {
            object = new SavedField[n == savedFieldArray.length ? n * 2 : savedFieldArray.length];
            System.arraycopy(savedFieldArray, 0, object, 0, n);
            savedFieldArray = object;
            a2.iSavedFields = object;
            a2.iSavedFieldsShared = false;
        }
        a2.iSavedState = null;
        object = savedFieldArray[n];
        if (object == null) {
            savedFieldArray[n] = new SavedField();
            object = savedFieldArray[n];
        }
        a2.iSavedFieldsCount = n + 1;
        return object;
    }

    @Deprecated
    public int getOffset() {
        return this.iOffset != null ? this.iOffset : 0;
    }

    @Deprecated
    public DateTimeParserBucket(long arg0, Chronology arg1, Locale arg2) {
        this(arg0, arg1, arg2, null, 2000);
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SavedField
    implements Comparable<SavedField> {
        String iText;
        Locale iLocale;
        DateTimeField iField;
        int iValue;

        void init(DateTimeField a2, int a3) {
            a.iField = a2;
            a.iValue = a3;
            a.iText = null;
            a.iLocale = null;
        }

        long set(long a2, boolean a3) {
            SavedField a4;
            a2 = a4.iText == null ? a4.iField.setExtended(a2, a4.iValue) : a4.iField.set(a2, a4.iText, a4.iLocale);
            if (a3) {
                a2 = a4.iField.roundFloor(a2);
            }
            return a2;
        }

        void init(DateTimeField a2, String a3, Locale a4) {
            a.iField = a2;
            a.iValue = 0;
            a.iText = a3;
            a.iLocale = a4;
        }

        SavedField() {
            SavedField a2;
        }

        @Override
        public int compareTo(SavedField arg0) {
            DateTimeField dateTimeField = arg0.iField;
            int n = DateTimeParserBucket.compareReverse(this.iField.getRangeDurationField(), dateTimeField.getRangeDurationField());
            if (n != 0) {
                return n;
            }
            return DateTimeParserBucket.compareReverse(this.iField.getDurationField(), dateTimeField.getDurationField());
        }
    }

    class SavedState {
        final int iSavedFieldsCount;
        final Integer iOffset;
        final DateTimeZone iZone;
        final SavedField[] iSavedFields;

        boolean restoreState(DateTimeParserBucket a2) {
            SavedState a3;
            if (a2 != a3.DateTimeParserBucket.this) {
                return false;
            }
            a2.iZone = a3.iZone;
            a2.iOffset = a3.iOffset;
            DateTimeParserBucket.access$202(a2, a3.iSavedFields);
            if (a3.iSavedFieldsCount < a2.iSavedFieldsCount) {
                a2.iSavedFieldsShared = true;
            }
            a2.iSavedFieldsCount = a3.iSavedFieldsCount;
            return true;
        }

        SavedState() {
            SavedState a3;
            a3.iZone = a3.DateTimeParserBucket.this.iZone;
            a3.iOffset = a3.DateTimeParserBucket.this.iOffset;
            a3.iSavedFields = a3.DateTimeParserBucket.this.iSavedFields;
            a3.iSavedFieldsCount = a3.DateTimeParserBucket.this.iSavedFieldsCount;
        }
    }
}

