/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadWritableInstant;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimeParserInternalParser;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.DateTimePrinterInternalPrinter;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.InternalParser;
import org.joda.time.format.InternalParserDateTimeParser;
import org.joda.time.format.InternalPrinter;
import org.joda.time.format.InternalPrinterDateTimePrinter;

public class DateTimeFormatter {
    private final DateTimeZone iZone;
    private final Integer iPivotYear;
    private final int iDefaultYear;
    private final Locale iLocale;
    private final InternalPrinter iPrinter;
    private final InternalParser iParser;
    private final boolean iOffsetParsed;
    private final Chronology iChrono;

    public boolean isPrinter() {
        return this.iPrinter != null;
    }

    public DateTimeZone getZone() {
        return this.iZone;
    }

    public String print(ReadablePartial arg0) {
        StringBuilder stringBuilder = new StringBuilder(this.requirePrinter().estimatePrintedLength());
        try {
            this.printTo((Appendable)stringBuilder, arg0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public DateTimeFormatter withLocale(Locale arg0) {
        if (arg0 == this.getLocale() || arg0 != null && arg0.equals(this.getLocale())) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, arg0, this.iOffsetParsed, this.iChrono, this.iZone, this.iPivotYear, this.iDefaultYear);
    }

    public void printTo(StringBuffer arg0, ReadablePartial arg1) {
        try {
            this.printTo((Appendable)arg0, arg1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public void printTo(Appendable arg0, long arg1) throws IOException {
        this.printTo(arg0, arg1, null);
    }

    public void printTo(StringBuffer arg0, ReadableInstant arg1) {
        try {
            this.printTo((Appendable)arg0, arg1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long parseMillis(String arg0) {
        InternalParser internalParser = this.requireParser();
        Chronology chronology = this.selectChronology(this.iChrono);
        DateTimeParserBucket dateTimeParserBucket = new DateTimeParserBucket(0L, chronology, this.iLocale, this.iPivotYear, this.iDefaultYear);
        return dateTimeParserBucket.doParseMillis(internalParser, arg0);
    }

    @Deprecated
    public Chronology getChronolgy() {
        return this.iChrono;
    }

    public Chronology getChronology() {
        return this.iChrono;
    }

    public void printTo(Appendable arg0, ReadablePartial arg1) throws IOException {
        InternalPrinter internalPrinter = this.requirePrinter();
        if (arg1 == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        internalPrinter.printTo(arg0, arg1, this.iLocale);
    }

    public DateTimeParser getParser() {
        return InternalParserDateTimeParser.of(this.iParser);
    }

    public DateTimeFormatter withZone(DateTimeZone arg0) {
        if (this.iZone == arg0) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, false, this.iChrono, arg0, this.iPivotYear, this.iDefaultYear);
    }

    public LocalDate parseLocalDate(String arg0) {
        return this.parseLocalDateTime(arg0).toLocalDate();
    }

    private InternalParser requireParser() {
        DateTimeFormatter a2;
        InternalParser internalParser = a2.iParser;
        if (internalParser == null) {
            throw new UnsupportedOperationException("Parsing not supported");
        }
        return internalParser;
    }

    public MutableDateTime parseMutableDateTime(String arg0) {
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        InternalParser internalParser = this.requireParser();
        int n = internalParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(null), this.iLocale, this.iPivotYear, this.iDefaultYear), arg0, 0);
        if (n >= 0) {
            if (n >= arg0.length()) {
                long l2 = dateTimeParserBucket.computeMillis(true, arg0);
                if (this.iOffsetParsed && dateTimeParserBucket.getOffsetInteger() != null) {
                    int n2 = dateTimeParserBucket.getOffsetInteger();
                    DateTimeZone dateTimeZone = DateTimeZone.forOffsetMillis(n2);
                    chronology = chronology.withZone(dateTimeZone);
                } else if (dateTimeParserBucket.getZone() != null) {
                    chronology = chronology.withZone(dateTimeParserBucket.getZone());
                }
                MutableDateTime mutableDateTime = new MutableDateTime(l2, chronology);
                if (this.iZone != null) {
                    mutableDateTime.setZone(this.iZone);
                }
                return mutableDateTime;
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(arg0, n));
    }

    public DateTimeFormatter withPivotYear(Integer arg0) {
        if (this.iPivotYear == arg0 || this.iPivotYear != null && this.iPivotYear.equals(arg0)) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, this.iChrono, this.iZone, arg0, this.iDefaultYear);
    }

    public DateTimeFormatter withZoneUTC() {
        return this.withZone(DateTimeZone.UTC);
    }

    DateTimeFormatter(InternalPrinter a2, InternalParser a3) {
        DateTimeFormatter a4;
        a4.iPrinter = a2;
        a4.iParser = a3;
        a4.iLocale = null;
        a4.iOffsetParsed = false;
        a4.iChrono = null;
        a4.iZone = null;
        a4.iPivotYear = null;
        a4.iDefaultYear = 2000;
    }

    public void printTo(Appendable arg0, ReadableInstant arg1) throws IOException {
        long l2 = DateTimeUtils.getInstantMillis(arg1);
        Chronology chronology = DateTimeUtils.getInstantChronology(arg1);
        this.printTo(arg0, l2, chronology);
    }

    public void printTo(Writer arg0, ReadablePartial arg1) throws IOException {
        this.printTo((Appendable)arg0, arg1);
    }

    public void printTo(Writer arg0, ReadableInstant arg1) throws IOException {
        this.printTo((Appendable)arg0, arg1);
    }

    public void printTo(StringBuffer arg0, long arg1) {
        try {
            this.printTo((Appendable)arg0, arg1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DateTimeFormatter withChronology(Chronology arg0) {
        if (this.iChrono == arg0) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, arg0, this.iZone, this.iPivotYear, this.iDefaultYear);
    }

    public DateTimeFormatter withPivotYear(int arg0) {
        return this.withPivotYear((Integer)arg0);
    }

    public void printTo(Writer arg0, long arg1) throws IOException {
        this.printTo((Appendable)arg0, arg1);
    }

    private DateTimeFormatter(InternalPrinter a2, InternalParser a3, Locale a4, boolean a5, Chronology a6, DateTimeZone a7, Integer a8, int a9) {
        DateTimeFormatter a10;
        a10.iPrinter = a2;
        a10.iParser = a3;
        a10.iLocale = a4;
        a10.iOffsetParsed = a5;
        a10.iChrono = a6;
        a10.iZone = a7;
        a10.iPivotYear = a8;
        a10.iDefaultYear = a9;
    }

    public DateTimeFormatter withOffsetParsed() {
        if (this.iOffsetParsed) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, true, this.iChrono, null, this.iPivotYear, this.iDefaultYear);
    }

    public String print(ReadableInstant arg0) {
        StringBuilder stringBuilder = new StringBuilder(this.requirePrinter().estimatePrintedLength());
        try {
            this.printTo((Appendable)stringBuilder, arg0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public boolean isOffsetParsed() {
        return this.iOffsetParsed;
    }

    public LocalTime parseLocalTime(String arg0) {
        return this.parseLocalDateTime(arg0).toLocalTime();
    }

    public int getDefaultYear() {
        return this.iDefaultYear;
    }

    public int parseInto(ReadWritableInstant arg0, String arg1, int arg2) {
        InternalParser internalParser = this.requireParser();
        if (arg0 == null) {
            throw new IllegalArgumentException("Instant must not be null");
        }
        long l2 = arg0.getMillis();
        Chronology chronology = arg0.getChronology();
        int n = DateTimeUtils.getChronology(chronology).year().get(l2);
        long l3 = l2 + (long)chronology.getZone().getOffset(l2);
        chronology = this.selectChronology(chronology);
        DateTimeParserBucket dateTimeParserBucket = new DateTimeParserBucket(l3, chronology, this.iLocale, this.iPivotYear, n);
        int n2 = internalParser.parseInto(dateTimeParserBucket, arg1, arg2);
        arg0.setMillis(dateTimeParserBucket.computeMillis(false, arg1));
        if (this.iOffsetParsed && dateTimeParserBucket.getOffsetInteger() != null) {
            int n3 = dateTimeParserBucket.getOffsetInteger();
            DateTimeZone dateTimeZone = DateTimeZone.forOffsetMillis(n3);
            chronology = chronology.withZone(dateTimeZone);
        } else if (dateTimeParserBucket.getZone() != null) {
            chronology = chronology.withZone(dateTimeParserBucket.getZone());
        }
        arg0.setChronology(chronology);
        if (this.iZone != null) {
            arg0.setZone(this.iZone);
        }
        return n2;
    }

    public DateTimeFormatter(DateTimePrinter arg0, DateTimeParser arg1) {
        this(DateTimePrinterInternalPrinter.of(arg0), DateTimeParserInternalParser.of(arg1));
    }

    public void printTo(StringBuilder arg0, ReadableInstant arg1) {
        try {
            this.printTo((Appendable)arg0, arg1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public LocalDateTime parseLocalDateTime(String arg0) {
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        InternalParser internalParser = this.requireParser();
        int n = internalParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(null).withUTC(), this.iLocale, this.iPivotYear, this.iDefaultYear), arg0, 0);
        if (n >= 0) {
            if (n >= arg0.length()) {
                long l2 = dateTimeParserBucket.computeMillis(true, arg0);
                if (dateTimeParserBucket.getOffsetInteger() != null) {
                    int n2 = dateTimeParserBucket.getOffsetInteger();
                    DateTimeZone dateTimeZone = DateTimeZone.forOffsetMillis(n2);
                    chronology = chronology.withZone(dateTimeZone);
                } else if (dateTimeParserBucket.getZone() != null) {
                    chronology = chronology.withZone(dateTimeParserBucket.getZone());
                }
                return new LocalDateTime(l2, chronology);
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(arg0, n));
    }

    private InternalPrinter requirePrinter() {
        DateTimeFormatter a2;
        InternalPrinter internalPrinter = a2.iPrinter;
        if (internalPrinter == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
        return internalPrinter;
    }

    private Chronology selectChronology(Chronology a2) {
        DateTimeFormatter a3;
        a2 = DateTimeUtils.getChronology(a2);
        if (a3.iChrono != null) {
            a2 = a3.iChrono;
        }
        if (a3.iZone != null) {
            a2 = a2.withZone(a3.iZone);
        }
        return a2;
    }

    public Integer getPivotYear() {
        return this.iPivotYear;
    }

    public boolean isParser() {
        return this.iParser != null;
    }

    InternalParser getParser0() {
        DateTimeFormatter a2;
        return a2.iParser;
    }

    private void printTo(Appendable a2, long a3, Chronology a4) throws IOException {
        DateTimeFormatter a5;
        InternalPrinter internalPrinter = a5.requirePrinter();
        DateTimeZone dateTimeZone = (a4 = a5.selectChronology(a4)).getZone();
        int n = dateTimeZone.getOffset(a3);
        long l2 = a3 + (long)n;
        if ((a3 ^ l2) < 0L && (a3 ^ (long)n) >= 0L) {
            dateTimeZone = DateTimeZone.UTC;
            n = 0;
            l2 = a3;
        }
        internalPrinter.printTo(a2, l2, a4.withUTC(), n, dateTimeZone, a5.iLocale);
    }

    public DateTime parseDateTime(String arg0) {
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        InternalParser internalParser = this.requireParser();
        int n = internalParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(null), this.iLocale, this.iPivotYear, this.iDefaultYear), arg0, 0);
        if (n >= 0) {
            if (n >= arg0.length()) {
                long l2 = dateTimeParserBucket.computeMillis(true, arg0);
                if (this.iOffsetParsed && dateTimeParserBucket.getOffsetInteger() != null) {
                    int n2 = dateTimeParserBucket.getOffsetInteger();
                    DateTimeZone dateTimeZone = DateTimeZone.forOffsetMillis(n2);
                    chronology = chronology.withZone(dateTimeZone);
                } else if (dateTimeParserBucket.getZone() != null) {
                    chronology = chronology.withZone(dateTimeParserBucket.getZone());
                }
                DateTime dateTime = new DateTime(l2, chronology);
                if (this.iZone != null) {
                    dateTime = dateTime.withZone(this.iZone);
                }
                return dateTime;
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(arg0, n));
    }

    public void printTo(StringBuilder arg0, ReadablePartial arg1) {
        try {
            this.printTo((Appendable)arg0, arg1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    InternalPrinter getPrinter0() {
        DateTimeFormatter a2;
        return a2.iPrinter;
    }

    public DateTimeFormatter withDefaultYear(int arg0) {
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, this.iChrono, this.iZone, this.iPivotYear, arg0);
    }

    public DateTimePrinter getPrinter() {
        return InternalPrinterDateTimePrinter.of(this.iPrinter);
    }

    public void printTo(StringBuilder arg0, long arg1) {
        try {
            this.printTo((Appendable)arg0, arg1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String print(long arg0) {
        StringBuilder stringBuilder = new StringBuilder(this.requirePrinter().estimatePrintedLength());
        try {
            this.printTo((Appendable)stringBuilder, arg0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }
}

