/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.FieldUtils;

public class OffsetDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 3145790132623583142L;
    private final int iMin;
    private final int iOffset;
    private final int iMax;

    public int getMaximumValue() {
        return this.iMax;
    }

    public long set(long arg0, int arg1) {
        FieldUtils.verifyValueBounds(this, arg1, this.iMin, this.iMax);
        return super.set(arg0, arg1 - this.iOffset);
    }

    public int getLeapAmount(long arg0) {
        return this.getWrappedField().getLeapAmount(arg0);
    }

    public int get(long arg0) {
        return super.get(arg0) + this.iOffset;
    }

    public long roundCeiling(long arg0) {
        return this.getWrappedField().roundCeiling(arg0);
    }

    public long add(long arg0, long arg1) {
        arg0 = super.add(arg0, arg1);
        FieldUtils.verifyValueBounds(this, this.get(arg0), this.iMin, this.iMax);
        return arg0;
    }

    public long roundHalfCeiling(long arg0) {
        return this.getWrappedField().roundHalfCeiling(arg0);
    }

    public int getOffset() {
        return this.iOffset;
    }

    public boolean isLeap(long arg0) {
        return this.getWrappedField().isLeap(arg0);
    }

    public DurationField getLeapDurationField() {
        return this.getWrappedField().getLeapDurationField();
    }

    public long roundHalfFloor(long arg0) {
        return this.getWrappedField().roundHalfFloor(arg0);
    }

    public int getMinimumValue() {
        return this.iMin;
    }

    public long roundFloor(long arg0) {
        return this.getWrappedField().roundFloor(arg0);
    }

    public long remainder(long arg0) {
        return this.getWrappedField().remainder(arg0);
    }

    public OffsetDateTimeField(DateTimeField arg0, int arg1) {
        this(arg0, arg0 == null ? null : arg0.getType(), arg1, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public long addWrapField(long arg0, int arg1) {
        return this.set(arg0, FieldUtils.getWrappedValue(this.get(arg0), arg1, this.iMin, this.iMax));
    }

    public OffsetDateTimeField(DateTimeField arg0, DateTimeFieldType arg1, int arg2, int arg3, int arg4) {
        super(arg0, arg1);
        if (arg2 == 0) {
            throw new IllegalArgumentException("The offset cannot be zero");
        }
        this.iOffset = arg2;
        this.iMin = arg3 < arg0.getMinimumValue() + arg2 ? arg0.getMinimumValue() + arg2 : arg3;
        this.iMax = arg4 > arg0.getMaximumValue() + arg2 ? arg0.getMaximumValue() + arg2 : arg4;
    }

    public long add(long arg0, int arg1) {
        arg0 = super.add(arg0, arg1);
        FieldUtils.verifyValueBounds(this, this.get(arg0), this.iMin, this.iMax);
        return arg0;
    }

    public long roundHalfEven(long arg0) {
        return this.getWrappedField().roundHalfEven(arg0);
    }

    public OffsetDateTimeField(DateTimeField arg0, DateTimeFieldType arg1, int arg2) {
        this(arg0, arg1, arg2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }
}

