/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.IllegalFieldValueException;

public class FieldUtils {
    public static int safeNegate(int arg0) {
        if (arg0 == Integer.MIN_VALUE) {
            throw new ArithmeticException("Integer.MIN_VALUE cannot be negated");
        }
        return -arg0;
    }

    public static int safeToInt(long arg0) {
        if (Integer.MIN_VALUE <= arg0 && arg0 <= Integer.MAX_VALUE) {
            return (int)arg0;
        }
        throw new ArithmeticException("Value cannot fit in an int: " + arg0);
    }

    public static void verifyValueBounds(DateTimeFieldType arg0, int arg1, int arg2, int arg3) {
        if (arg1 < arg2 || arg1 > arg3) {
            throw new IllegalFieldValueException(arg0, (Number)arg1, (Number)arg2, (Number)arg3);
        }
    }

    public static long safeMultiply(long arg0, int arg1) {
        switch (arg1) {
            case -1: {
                if (arg0 == Long.MIN_VALUE) {
                    throw new ArithmeticException("Multiplication overflows a long: " + arg0 + " * " + arg1);
                }
                return -arg0;
            }
            case 0: {
                return 0L;
            }
            case 1: {
                return arg0;
            }
        }
        long l2 = arg0 * (long)arg1;
        if (l2 / (long)arg1 != arg0) {
            throw new ArithmeticException("Multiplication overflows a long: " + arg0 + " * " + arg1);
        }
        return l2;
    }

    public static int getWrappedValue(int arg0, int arg1, int arg2, int arg3) {
        return FieldUtils.getWrappedValue(arg0 + arg1, arg2, arg3);
    }

    public static int safeMultiplyToInt(long arg0, long arg1) {
        long l2 = FieldUtils.safeMultiply(arg0, arg1);
        return FieldUtils.safeToInt(l2);
    }

    public static long safeMultiply(long arg0, long arg1) {
        if (arg1 == 1L) {
            return arg0;
        }
        if (arg0 == 1L) {
            return arg1;
        }
        if (arg0 == 0L || arg1 == 0L) {
            return 0L;
        }
        long l2 = arg0 * arg1;
        if (l2 / arg1 != arg0 || arg0 == Long.MIN_VALUE && arg1 == -1L || arg1 == Long.MIN_VALUE && arg0 == -1L) {
            throw new ArithmeticException("Multiplication overflows a long: " + arg0 + " * " + arg1);
        }
        return l2;
    }

    public static long safeSubtract(long arg0, long arg1) {
        long l2 = arg0 - arg1;
        if ((arg0 ^ l2) < 0L && (arg0 ^ arg1) < 0L) {
            throw new ArithmeticException("The calculation caused an overflow: " + arg0 + " - " + arg1);
        }
        return l2;
    }

    public static int safeAdd(int arg0, int arg1) {
        int n = arg0 + arg1;
        if ((arg0 ^ n) < 0 && (arg0 ^ arg1) >= 0) {
            throw new ArithmeticException("The calculation caused an overflow: " + arg0 + " + " + arg1);
        }
        return n;
    }

    private FieldUtils() {
        FieldUtils a2;
    }

    public static long safeDivide(long arg0, long arg1) {
        if (arg0 == Long.MIN_VALUE && arg1 == -1L) {
            throw new ArithmeticException("Multiplication overflows a long: " + arg0 + " / " + arg1);
        }
        return arg0 / arg1;
    }

    public static int safeMultiply(int arg0, int arg1) {
        long l2 = (long)arg0 * (long)arg1;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("Multiplication overflows an int: " + arg0 + " * " + arg1);
        }
        return (int)l2;
    }

    public static long safeAdd(long arg0, long arg1) {
        long l2 = arg0 + arg1;
        if ((arg0 ^ l2) < 0L && (arg0 ^ arg1) >= 0L) {
            throw new ArithmeticException("The calculation caused an overflow: " + arg0 + " + " + arg1);
        }
        return l2;
    }

    public static void verifyValueBounds(String arg0, int arg1, int arg2, int arg3) {
        if (arg1 < arg2 || arg1 > arg3) {
            throw new IllegalFieldValueException(arg0, (Number)arg1, (Number)arg2, (Number)arg3);
        }
    }

    public static int getWrappedValue(int arg0, int arg1, int arg2) {
        if (arg1 >= arg2) {
            throw new IllegalArgumentException("MIN > MAX");
        }
        int n = arg2 - arg1 + 1;
        if ((arg0 -= arg1) >= 0) {
            return arg0 % n + arg1;
        }
        int n2 = -arg0 % n;
        if (n2 == 0) {
            return 0 + arg1;
        }
        return n - n2 + arg1;
    }

    public static boolean equals(Object arg0, Object arg1) {
        if (arg0 == arg1) {
            return true;
        }
        if (arg0 == null || arg1 == null) {
            return false;
        }
        return arg0.equals(arg1);
    }

    public static void verifyValueBounds(DateTimeField arg0, int arg1, int arg2, int arg3) {
        if (arg1 < arg2 || arg1 > arg3) {
            throw new IllegalFieldValueException(arg0.getType(), (Number)arg1, (Number)arg2, (Number)arg3);
        }
    }
}

