/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadablePartial;
import org.joda.time.field.FieldUtils;

public abstract class BaseDateTimeField
extends DateTimeField {
    private final DateTimeFieldType iType;

    public final long set(long arg0, String arg1) {
        return this.set(arg0, arg1, null);
    }

    public abstract DurationField getDurationField();

    public long set(long arg0, String arg1, Locale arg2) {
        int n = this.convertText(arg1, arg2);
        return this.set(arg0, n);
    }

    public abstract long roundFloor(long var1);

    public String getAsText(ReadablePartial arg0, int arg1, Locale arg2) {
        return this.getAsText(arg1, arg2);
    }

    public abstract int getMinimumValue();

    public final String getAsShortText(ReadablePartial arg0, Locale arg1) {
        return this.getAsShortText(arg0, arg0.get(this.getType()), arg1);
    }

    public boolean isLeap(long arg0) {
        return false;
    }

    public abstract int getMaximumValue();

    public int[] addWrapPartial(ReadablePartial arg0, int arg1, int[] arg2, int arg3) {
        int n;
        long l2;
        if (arg3 == 0) {
            return arg2;
        }
        DateTimeField dateTimeField = null;
        while (arg3 > 0) {
            l2 = arg2[arg1] + arg3;
            n = this.getMaximumValue(arg0, arg2);
            if (l2 <= (long)n) {
                arg2[arg1] = (int)l2;
                break;
            }
            if (dateTimeField == null) {
                if (arg1 == 0) {
                    arg3 -= n + 1 - arg2[arg1];
                    arg2[arg1] = this.getMinimumValue(arg0, arg2);
                    continue;
                }
                dateTimeField = arg0.getField(arg1 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            arg3 -= n + 1 - arg2[arg1];
            arg2 = dateTimeField.addWrapPartial(arg0, arg1 - 1, arg2, 1);
            arg2[arg1] = this.getMinimumValue(arg0, arg2);
        }
        while (arg3 < 0) {
            l2 = arg2[arg1] + arg3;
            n = this.getMinimumValue(arg0, arg2);
            if (l2 >= (long)n) {
                arg2[arg1] = (int)l2;
                break;
            }
            if (dateTimeField == null) {
                if (arg1 == 0) {
                    arg3 -= n - 1 - arg2[arg1];
                    arg2[arg1] = this.getMaximumValue(arg0, arg2);
                    continue;
                }
                dateTimeField = arg0.getField(arg1 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            arg3 -= n - 1 - arg2[arg1];
            arg2 = dateTimeField.addWrapPartial(arg0, arg1 - 1, arg2, -1);
            arg2[arg1] = this.getMaximumValue(arg0, arg2);
        }
        return this.set(arg0, arg1, arg2, arg2[arg1]);
    }

    public int[] set(ReadablePartial arg0, int arg1, int[] arg2, String arg3, Locale arg4) {
        int n = this.convertText(arg3, arg4);
        return this.set(arg0, arg1, arg2, n);
    }

    public String toString() {
        return "DateTimeField[" + this.getName() + ']';
    }

    public String getAsText(long arg0, Locale arg1) {
        return this.getAsText(this.get(arg0), arg1);
    }

    public final String getAsText(long arg0) {
        return this.getAsText(arg0, null);
    }

    public int[] set(ReadablePartial arg0, int arg1, int[] arg2, int arg3) {
        FieldUtils.verifyValueBounds(this, arg3, this.getMinimumValue(arg0, arg2), this.getMaximumValue(arg0, arg2));
        arg2[arg1] = arg3;
        for (int i2 = arg1 + 1; i2 < arg0.size(); ++i2) {
            DateTimeField dateTimeField = arg0.getField(i2);
            if (arg2[i2] > dateTimeField.getMaximumValue(arg0, arg2)) {
                arg2[i2] = dateTimeField.getMaximumValue(arg0, arg2);
            }
            if (arg2[i2] >= dateTimeField.getMinimumValue(arg0, arg2)) continue;
            arg2[i2] = dateTimeField.getMinimumValue(arg0, arg2);
        }
        return arg2;
    }

    public int getMaximumValue(ReadablePartial arg0) {
        return this.getMaximumValue();
    }

    public final boolean isSupported() {
        return true;
    }

    public int getLeapAmount(long arg0) {
        return 0;
    }

    public String getAsText(int arg0, Locale arg1) {
        return Integer.toString(arg0);
    }

    public int getDifference(long arg0, long arg1) {
        return this.getDurationField().getDifference(arg0, arg1);
    }

    public int getMaximumValue(long arg0) {
        return this.getMaximumValue();
    }

    public int getMaximumValue(ReadablePartial arg0, int[] arg1) {
        return this.getMaximumValue(arg0);
    }

    public abstract long set(long var1, int var3);

    public abstract DurationField getRangeDurationField();

    public final String getName() {
        return this.iType.getName();
    }

    public int[] add(ReadablePartial arg0, int arg1, int[] arg2, int arg3) {
        int n;
        long l2;
        if (arg3 == 0) {
            return arg2;
        }
        DateTimeField dateTimeField = null;
        while (arg3 > 0) {
            l2 = arg2[arg1] + arg3;
            n = this.getMaximumValue(arg0, arg2);
            if (l2 <= (long)n) {
                arg2[arg1] = (int)l2;
                break;
            }
            if (dateTimeField == null) {
                if (arg1 == 0) {
                    throw new IllegalArgumentException("Maximum value exceeded for add");
                }
                dateTimeField = arg0.getField(arg1 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            arg3 -= n + 1 - arg2[arg1];
            arg2 = dateTimeField.add(arg0, arg1 - 1, arg2, 1);
            arg2[arg1] = this.getMinimumValue(arg0, arg2);
        }
        while (arg3 < 0) {
            l2 = arg2[arg1] + arg3;
            n = this.getMinimumValue(arg0, arg2);
            if (l2 >= (long)n) {
                arg2[arg1] = (int)l2;
                break;
            }
            if (dateTimeField == null) {
                if (arg1 == 0) {
                    throw new IllegalArgumentException("Maximum value exceeded for add");
                }
                dateTimeField = arg0.getField(arg1 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            arg3 -= n - 1 - arg2[arg1];
            arg2 = dateTimeField.add(arg0, arg1 - 1, arg2, -1);
            arg2[arg1] = this.getMaximumValue(arg0, arg2);
        }
        return this.set(arg0, arg1, arg2, arg2[arg1]);
    }

    protected BaseDateTimeField(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = arg0;
    }

    public String getAsShortText(ReadablePartial arg0, int arg1, Locale arg2) {
        return this.getAsShortText(arg1, arg2);
    }

    public String getAsShortText(int arg0, Locale arg1) {
        return this.getAsText(arg0, arg1);
    }

    public int getMinimumValue(ReadablePartial arg0, int[] arg1) {
        return this.getMinimumValue(arg0);
    }

    public final String getAsText(ReadablePartial arg0, Locale arg1) {
        return this.getAsText(arg0, arg0.get(this.getType()), arg1);
    }

    public long remainder(long arg0) {
        return arg0 - this.roundFloor(arg0);
    }

    public final String getAsShortText(long arg0) {
        return this.getAsShortText(arg0, null);
    }

    public String getAsShortText(long arg0, Locale arg1) {
        return this.getAsShortText(this.get(arg0), arg1);
    }

    public long getDifferenceAsLong(long arg0, long arg1) {
        return this.getDurationField().getDifferenceAsLong(arg0, arg1);
    }

    public int getMaximumTextLength(Locale arg0) {
        int n = this.getMaximumValue();
        if (n >= 0) {
            if (n < 10) {
                return 1;
            }
            if (n < 100) {
                return 2;
            }
            if (n < 1000) {
                return 3;
            }
        }
        return Integer.toString(n).length();
    }

    public final DateTimeFieldType getType() {
        return this.iType;
    }

    protected int convertText(String arg0, Locale arg1) {
        try {
            return Integer.parseInt(arg0);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalFieldValueException(this.getType(), arg0);
        }
    }

    public long add(long arg0, long arg1) {
        return this.getDurationField().add(arg0, arg1);
    }

    public int getMaximumShortTextLength(Locale arg0) {
        return this.getMaximumTextLength(arg0);
    }

    public int getMinimumValue(ReadablePartial arg0) {
        return this.getMinimumValue();
    }

    public int getMinimumValue(long arg0) {
        return this.getMinimumValue();
    }

    public long roundHalfEven(long arg0) {
        long l2;
        long l3;
        long l4 = this.roundFloor(arg0);
        long l5 = arg0 - l4;
        if (l5 < (l3 = (l2 = this.roundCeiling(arg0)) - arg0)) {
            return l4;
        }
        if (l3 < l5) {
            return l2;
        }
        if ((this.get(l2) & 1) == 0) {
            return l2;
        }
        return l4;
    }

    public long roundHalfCeiling(long arg0) {
        long l2;
        long l3 = this.roundFloor(arg0);
        long l4 = this.roundCeiling(arg0);
        long l5 = l4 - arg0;
        if (l5 <= (l2 = arg0 - l3)) {
            return l4;
        }
        return l3;
    }

    public int[] addWrapField(ReadablePartial arg0, int arg1, int[] arg2, int arg3) {
        int n = arg2[arg1];
        int n2 = FieldUtils.getWrappedValue(n, arg3, this.getMinimumValue(arg0), this.getMaximumValue(arg0));
        return this.set(arg0, arg1, arg2, n2);
    }

    public long addWrapField(long arg0, int arg1) {
        int n = this.get(arg0);
        int n2 = FieldUtils.getWrappedValue(n, arg1, this.getMinimumValue(arg0), this.getMaximumValue(arg0));
        return this.set(arg0, n2);
    }

    public long roundCeiling(long arg0) {
        long l2 = this.roundFloor(arg0);
        if (l2 != arg0) {
            arg0 = this.add(l2, 1);
        }
        return arg0;
    }

    public abstract int get(long var1);

    public DurationField getLeapDurationField() {
        return null;
    }

    public long add(long arg0, int arg1) {
        return this.getDurationField().add(arg0, arg1);
    }

    public long roundHalfFloor(long arg0) {
        long l2;
        long l3;
        long l4 = this.roundFloor(arg0);
        long l5 = arg0 - l4;
        if (l5 <= (l3 = (l2 = this.roundCeiling(arg0)) - arg0)) {
            return l4;
        }
        return l2;
    }
}

