/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadWritableInterval;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePartial;
import org.joda.time.convert.AbstractConverter;
import org.joda.time.convert.DurationConverter;
import org.joda.time.convert.InstantConverter;
import org.joda.time.convert.IntervalConverter;
import org.joda.time.convert.PartialConverter;
import org.joda.time.convert.PeriodConverter;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter,
DurationConverter,
PeriodConverter,
IntervalConverter {
    static final StringConverter INSTANCE = new StringConverter();

    @Override
    public int[] getPartialValues(ReadablePartial arg0, Object arg1, Chronology arg2, DateTimeFormatter arg3) {
        if (arg3.getZone() != null) {
            arg2 = arg2.withZone(arg3.getZone());
        }
        long l2 = arg3.withChronology(arg2).parseMillis((String)arg1);
        return arg2.get(arg0, l2);
    }

    @Override
    public long getDurationMillis(Object arg0) {
        int n;
        String string = (String)arg0;
        String string2 = string;
        int n2 = string2.length();
        if (n2 < 4 || string2.charAt(0) != 'P' && string2.charAt(0) != 'p' || string2.charAt(1) != 'T' && string2.charAt(1) != 't' || string2.charAt(n2 - 1) != 'S' && string2.charAt(n2 - 1) != 's') {
            throw new IllegalArgumentException("Invalid format: \"" + string + '\"');
        }
        string2 = string2.substring(2, n2 - 1);
        int n3 = -1;
        boolean bl = false;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) >= '0' && string2.charAt(i2) <= '9') continue;
            if (i2 == 0 && string2.charAt(0) == '-') {
                bl = true;
                continue;
            }
            if (i2 > (bl ? 1 : 0) && string2.charAt(i2) == '.' && n3 == -1) {
                n3 = i2;
                continue;
            }
            throw new IllegalArgumentException("Invalid format: \"" + string + '\"');
        }
        long l2 = 0L;
        long l3 = 0L;
        int n4 = n = bl ? 1 : 0;
        if (n3 > 0) {
            l3 = Long.parseLong(string2.substring(n, n3));
            if ((string2 = string2.substring(n3 + 1)).length() != 3) {
                string2 = (string2 + "000").substring(0, 3);
            }
            l2 = Integer.parseInt(string2);
        } else {
            l3 = bl ? Long.parseLong(string2.substring(n, string2.length())) : Long.parseLong(string2);
        }
        if (bl) {
            return FieldUtils.safeAdd(FieldUtils.safeMultiply(-l3, 1000), -l2);
        }
        return FieldUtils.safeAdd(FieldUtils.safeMultiply(l3, 1000), l2);
    }

    @Override
    public void setInto(ReadWritableInterval arg0, Object arg1, Chronology arg2) {
        DateTime dateTime;
        String string = (String)arg1;
        int n = string.indexOf(47);
        if (n < 0) {
            throw new IllegalArgumentException("Format requires a '/' separator: " + string);
        }
        String string2 = string.substring(0, n);
        if (string2.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + string);
        }
        String string3 = string.substring(n + 1);
        if (string3.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + string);
        }
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeParser();
        dateTimeFormatter = dateTimeFormatter.withChronology(arg2);
        PeriodFormatter periodFormatter = ISOPeriodFormat.standard();
        long l2 = 0L;
        long l3 = 0L;
        Period period = null;
        Chronology chronology = null;
        char c2 = string2.charAt(0);
        if (c2 == 'P' || c2 == 'p') {
            period = periodFormatter.withParseType(this.getPeriodType(string2)).parsePeriod(string2);
        } else {
            dateTime = dateTimeFormatter.parseDateTime(string2);
            l2 = dateTime.getMillis();
            chronology = dateTime.getChronology();
        }
        c2 = string3.charAt(0);
        if (c2 == 'P' || c2 == 'p') {
            if (period != null) {
                throw new IllegalArgumentException("Interval composed of two durations: " + string);
            }
            period = periodFormatter.withParseType(this.getPeriodType(string3)).parsePeriod(string3);
            arg2 = arg2 != null ? arg2 : chronology;
            l3 = arg2.add(period, l2, 1);
        } else {
            dateTime = dateTimeFormatter.parseDateTime(string3);
            l3 = dateTime.getMillis();
            chronology = chronology != null ? chronology : dateTime.getChronology();
            Chronology chronology2 = arg2 = arg2 != null ? arg2 : chronology;
            if (period != null) {
                l2 = arg2.add(period, l3, -1);
            }
        }
        arg0.setInterval(l2, l3);
        arg0.setChronology(arg2);
    }

    @Override
    public void setInto(ReadWritablePeriod arg0, Object arg1, Chronology arg2) {
        String string = (String)arg1;
        PeriodFormatter periodFormatter = ISOPeriodFormat.standard();
        arg0.clear();
        int n = periodFormatter.parseInto(arg0, string, 0);
        if (n < string.length()) {
            if (n < 0) {
                periodFormatter.withParseType(arg0.getPeriodType()).parseMutablePeriod(string);
            }
            throw new IllegalArgumentException("Invalid format: \"" + string + '\"');
        }
    }

    @Override
    public Class<?> getSupportedType() {
        return String.class;
    }

    @Override
    public long getInstantMillis(Object arg0, Chronology arg1) {
        String string = (String)arg0;
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeParser();
        return dateTimeFormatter.withChronology(arg1).parseMillis(string);
    }

    protected StringConverter() {
    }
}

