/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicGJChronology;
import org.joda.time.chrono.ZonedChronology;

public final class GregorianChronology
extends BasicGJChronology {
    private static final int DAYS_0000_TO_1970 = 719527;
    private static final long serialVersionUID = -861407383323710522L;
    private static final long MILLIS_PER_MONTH = 2629746000L;
    private static final int MAX_YEAR = 292278993;
    private static final GregorianChronology INSTANCE_UTC;
    private static final ConcurrentHashMap<DateTimeZone, GregorianChronology[]> cCache;
    private static final long MILLIS_PER_YEAR = 31556952000L;
    private static final int MIN_YEAR = -292275054;

    long getAverageMillisPerYearDividedByTwo() {
        return 15778476000L;
    }

    public static GregorianChronology getInstance(DateTimeZone arg0) {
        return GregorianChronology.getInstance(arg0, 4);
    }

    long getAverageMillisPerYear() {
        return 31556952000L;
    }

    public static GregorianChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GregorianChronology getInstance(DateTimeZone arg0, int arg1) {
        GregorianChronology gregorianChronology;
        GregorianChronology[] gregorianChronologyArray;
        GregorianChronology[] gregorianChronologyArray2;
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if ((gregorianChronologyArray2 = cCache.get(arg0)) == null && (gregorianChronologyArray = cCache.putIfAbsent(arg0, gregorianChronologyArray2 = new GregorianChronology[7])) != null) {
            gregorianChronologyArray2 = gregorianChronologyArray;
        }
        try {
            gregorianChronology = gregorianChronologyArray2[arg1 - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid min days in first week: " + arg1);
        }
        if (gregorianChronology != null) return gregorianChronology;
        gregorianChronologyArray = gregorianChronologyArray2;
        synchronized (gregorianChronologyArray2) {
            gregorianChronology = gregorianChronologyArray2[arg1 - 1];
            if (gregorianChronology != null) return gregorianChronology;
            if (arg0 == DateTimeZone.UTC) {
                gregorianChronology = new GregorianChronology(null, null, arg1);
            } else {
                gregorianChronology = GregorianChronology.getInstance(DateTimeZone.UTC, arg1);
                gregorianChronology = new GregorianChronology(ZonedChronology.getInstance(gregorianChronology, arg0), null, arg1);
            }
            gregorianChronologyArray2[arg1 - 1] = gregorianChronology;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return gregorianChronology;
        }
    }

    int getMinYear() {
        return -292275054;
    }

    long calculateFirstDayOfYearMillis(int a2) {
        int n = a2 / 100;
        if (a2 < 0) {
            n = (a2 + 3 >> 2) - n + (n + 3 >> 2) - 1;
        } else {
            GregorianChronology a3;
            n = (a2 >> 2) - n + (n >> 2);
            if (a3.isLeapYear(a2)) {
                --n;
            }
        }
        return ((long)a2 * 365L + (long)(n - 719527)) * 86400000L;
    }

    private GregorianChronology(Chronology a2, Object a3, int a4) {
        super(a2, a3, a4);
        GregorianChronology a5;
    }

    boolean isLeapYear(int a2) {
        return (a2 & 3) == 0 && (a2 % 100 != 0 || a2 % 400 == 0);
    }

    long getApproxMillisAtEpochDividedByTwo() {
        return 31083597720000L;
    }

    public static GregorianChronology getInstance() {
        return GregorianChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public Chronology withZone(DateTimeZone arg0) {
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if (arg0 == this.getZone()) {
            return this;
        }
        return GregorianChronology.getInstance(arg0);
    }

    long getAverageMillisPerMonth() {
        return 2629746000L;
    }

    private Object readResolve() {
        GregorianChronology a2;
        Chronology chronology = a2.getBase();
        int n = a2.getMinimumDaysInFirstWeek();
        n = n == 0 ? 4 : n;
        return chronology == null ? GregorianChronology.getInstance(DateTimeZone.UTC, n) : GregorianChronology.getInstance(chronology.getZone(), n);
    }

    static {
        cCache = new ConcurrentHashMap();
        INSTANCE_UTC = GregorianChronology.getInstance(DateTimeZone.UTC);
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    protected void assemble(AssembledChronology.Fields arg0) {
        if (this.getBase() == null) {
            super.assemble(arg0);
        }
    }

    int getMaxYear() {
        return 292278993;
    }
}

