/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.field.PreciseDurationDateTimeField;

final class GJDayOfWeekDateTimeField
extends PreciseDurationDateTimeField {
    private final BasicChronology iChronology;
    private static final long serialVersionUID = -3857947176719041436L;

    public int getMinimumValue() {
        return 1;
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.weeks();
    }

    protected int convertText(String arg0, Locale arg1) {
        return GJLocaleSymbols.forLocale(arg1).dayOfWeekTextToValue(arg0);
    }

    public int getMaximumShortTextLength(Locale arg0) {
        return GJLocaleSymbols.forLocale(arg0).getDayOfWeekMaxShortTextLength();
    }

    public String getAsText(int arg0, Locale arg1) {
        return GJLocaleSymbols.forLocale(arg1).dayOfWeekValueToText(arg0);
    }

    public int getMaximumTextLength(Locale arg0) {
        return GJLocaleSymbols.forLocale(arg0).getDayOfWeekMaxTextLength();
    }

    public int getMaximumValue() {
        return 7;
    }

    GJDayOfWeekDateTimeField(BasicChronology a2, DurationField a3) {
        super(DateTimeFieldType.dayOfWeek(), a3);
        GJDayOfWeekDateTimeField a4;
        a4.iChronology = a2;
    }

    public String getAsShortText(int arg0, Locale arg1) {
        return GJLocaleSymbols.forLocale(arg1).dayOfWeekValueToShortText(arg0);
    }

    public int get(long arg0) {
        return this.iChronology.getDayOfWeek(arg0);
    }

    private Object readResolve() {
        GJDayOfWeekDateTimeField a2;
        return a2.iChronology.dayOfWeek();
    }
}

