/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.Chronology;
import org.joda.time.chrono.BasicChronology;

abstract class BasicGJChronology
extends BasicChronology {
    private static final long FEB_29 = 5097600000L;
    private static final int[] MIN_DAYS_PER_MONTH_ARRAY = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long[] MIN_TOTAL_MILLIS_BY_MONTH_ARRAY;
    private static final long[] MAX_TOTAL_MILLIS_BY_MONTH_ARRAY;
    private static final long serialVersionUID = 538276888268L;
    private static final int[] MAX_DAYS_PER_MONTH_ARRAY;

    long getYearDifference(long a2, long a3) {
        BasicGJChronology a4;
        int n = a4.getYear(a2);
        int n2 = a4.getYear(a3);
        long l2 = a2 - a4.getYearMillis(n);
        long l3 = a3 - a4.getYearMillis(n2);
        if (l3 >= 5097600000L) {
            if (a4.isLeapYear(n2)) {
                if (!a4.isLeapYear(n)) {
                    l3 -= 86400000L;
                }
            } else if (l2 >= 5097600000L && a4.isLeapYear(n)) {
                l2 -= 86400000L;
            }
        }
        int n3 = n - n2;
        if (l2 < l3) {
            --n3;
        }
        return n3;
    }

    BasicGJChronology(Chronology a2, Object a3, int a4) {
        super(a2, a3, a4);
        BasicGJChronology a5;
    }

    int getDaysInMonthMaxForSet(long a2, int a3) {
        BasicGJChronology a4;
        return a3 > 28 || a3 < 1 ? a4.getDaysInMonthMax(a2) : 28;
    }

    int getMonthOfYear(long a2, int a3) {
        BasicGJChronology a4;
        int n = (int)(a2 - a4.getYearMillis(a3) >> 10);
        return a4.isLeapYear(a3) ? (n < 15356250 ? (n < 7678125 ? (n < 2615625 ? 1 : (n < 5062500 ? 2 : 3)) : (n < 10209375 ? 4 : (n < 12825000 ? 5 : 6))) : (n < 23118750 ? (n < 17971875 ? 7 : (n < 20587500 ? 8 : 9)) : (n < 25734375 ? 10 : (n < 28265625 ? 11 : 12)))) : (n < 15271875 ? (n < 7593750 ? (n < 2615625 ? 1 : (n < 4978125 ? 2 : 3)) : (n < 10125000 ? 4 : (n < 12740625 ? 5 : 6))) : (n < 23034375 ? (n < 17887500 ? 7 : (n < 20503125 ? 8 : 9)) : (n < 25650000 ? 10 : (n < 28181250 ? 11 : 12))));
    }

    long getTotalMillisByYearMonth(int a2, int a3) {
        BasicGJChronology a4;
        if (a4.isLeapYear(a2)) {
            return MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[a3 - 1];
        }
        return MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[a3 - 1];
    }

    int getDaysInYearMonth(int a2, int a3) {
        BasicGJChronology a4;
        if (a4.isLeapYear(a2)) {
            return MAX_DAYS_PER_MONTH_ARRAY[a3 - 1];
        }
        return MIN_DAYS_PER_MONTH_ARRAY[a3 - 1];
    }

    long setYear(long a2, int a3) {
        BasicGJChronology a4;
        int n = a4.getYear(a2);
        int n2 = a4.getDayOfYear(a2, n);
        int n3 = a4.getMillisOfDay(a2);
        if (n2 > 59) {
            if (a4.isLeapYear(n)) {
                if (!a4.isLeapYear(a3)) {
                    --n2;
                }
            } else if (a4.isLeapYear(a3)) {
                ++n2;
            }
        }
        a2 = a4.getYearMonthDayMillis(a3, 1, n2);
        return a2 += (long)n3;
    }

    boolean isLeapDay(long a2) {
        BasicGJChronology a3;
        return a3.dayOfMonth().get(a2) == 29 && a3.monthOfYear().isLeap(a2);
    }

    int getDaysInMonthMax(int a2) {
        return MAX_DAYS_PER_MONTH_ARRAY[a2 - 1];
    }

    static {
        MAX_DAYS_PER_MONTH_ARRAY = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        MIN_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
        MAX_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < 11; ++i2) {
            long l4 = (long)MIN_DAYS_PER_MONTH_ARRAY[i2] * 86400000L;
            BasicGJChronology.MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[i2 + 1] = l2 += l4;
            l4 = (long)MAX_DAYS_PER_MONTH_ARRAY[i2] * 86400000L;
            BasicGJChronology.MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[i2 + 1] = l3 += l4;
        }
    }
}

