/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfMonthDateTimeField
extends PreciseDurationDateTimeField {
    private final BasicChronology iChronology;
    private static final long serialVersionUID = -4677223814028011723L;

    public int get(long arg0) {
        return this.iChronology.getDayOfMonth(arg0);
    }

    public int getMaximumValue(ReadablePartial arg0, int[] arg1) {
        int n = arg0.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (arg0.getFieldType(i2) != DateTimeFieldType.monthOfYear()) continue;
            int n2 = arg1[i2];
            for (int i3 = 0; i3 < n; ++i3) {
                if (arg0.getFieldType(i3) != DateTimeFieldType.year()) continue;
                int n3 = arg1[i3];
                return this.iChronology.getDaysInYearMonth(n3, n2);
            }
            return this.iChronology.getDaysInMonthMax(n2);
        }
        return this.getMaximumValue();
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.months();
    }

    private Object readResolve() {
        BasicDayOfMonthDateTimeField a2;
        return a2.iChronology.dayOfMonth();
    }

    BasicDayOfMonthDateTimeField(BasicChronology a2, DurationField a3) {
        super(DateTimeFieldType.dayOfMonth(), a3);
        BasicDayOfMonthDateTimeField a4;
        a4.iChronology = a2;
    }

    public int getMaximumValue(ReadablePartial arg0) {
        if (arg0.isSupported(DateTimeFieldType.monthOfYear())) {
            int n = arg0.get(DateTimeFieldType.monthOfYear());
            if (arg0.isSupported(DateTimeFieldType.year())) {
                int n2 = arg0.get(DateTimeFieldType.year());
                return this.iChronology.getDaysInYearMonth(n2, n);
            }
            return this.iChronology.getDaysInMonthMax(n);
        }
        return this.getMaximumValue();
    }

    protected int getMaximumValueForSet(long arg0, int arg1) {
        return this.iChronology.getDaysInMonthMaxForSet(arg0, arg1);
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue(long arg0) {
        return this.iChronology.getDaysInMonthMax(arg0);
    }

    public boolean isLeap(long arg0) {
        return this.iChronology.isLeapDay(arg0);
    }

    public int getMaximumValue() {
        return this.iChronology.getDaysInMonthMax();
    }
}

