/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicDayOfMonthDateTimeField;
import org.joda.time.chrono.BasicDayOfYearDateTimeField;
import org.joda.time.chrono.BasicWeekOfWeekyearDateTimeField;
import org.joda.time.chrono.BasicWeekyearDateTimeField;
import org.joda.time.chrono.BasicYearDateTimeField;
import org.joda.time.chrono.GJDayOfWeekDateTimeField;
import org.joda.time.chrono.GJEraDateTimeField;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.chrono.GJMonthOfYearDateTimeField;
import org.joda.time.chrono.GJYearOfEraDateTimeField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.field.PreciseDurationField;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.field.ZeroIsMaxDateTimeField;

abstract class BasicChronology
extends AssembledChronology {
    private static final int CACHE_SIZE = 1024;
    private static final DurationField cHoursField;
    private static final int CACHE_MASK = 1023;
    private static final DateTimeField cHalfdayOfDayField;
    private static final DateTimeField cHourOfDayField;
    private final transient YearInfo[] iYearInfoCache = new YearInfo[1024];
    private static final DurationField cSecondsField;
    private static final DurationField cWeeksField;
    private static final DateTimeField cMillisOfSecondField;
    private final int iMinDaysInFirstWeek;
    private static final DateTimeField cMillisOfDayField;
    private static final DurationField cDaysField;
    private static final DateTimeField cMinuteOfHourField;
    private static final DateTimeField cHourOfHalfdayField;
    private static final DurationField cHalfdaysField;
    private static final DateTimeField cMinuteOfDayField;
    private static final DurationField cMinutesField;
    private static final long serialVersionUID = 8283225332206808863L;
    private static final DateTimeField cClockhourOfHalfdayField;
    private static final DateTimeField cSecondOfMinuteField;
    private static final DateTimeField cSecondOfDayField;
    private static final DurationField cMillisField;
    private static final DateTimeField cClockhourOfDayField;

    private YearInfo getYearInfo(int a2) {
        BasicChronology a3;
        YearInfo yearInfo = a3.iYearInfoCache[a2 & 0x3FF];
        if (yearInfo == null || yearInfo.iYear != a2) {
            a3.iYearInfoCache[a2 & 0x3FF] = yearInfo = new YearInfo(a2, a3.calculateFirstDayOfYearMillis(a2));
        }
        return yearInfo;
    }

    abstract long getTotalMillisByYearMonth(int var1, int var2);

    int getDayOfMonth(long a2) {
        BasicChronology a3;
        int n = a3.getYear(a2);
        int n2 = a3.getMonthOfYear(a2, n);
        return a3.getDayOfMonth(a2, n, n2);
    }

    protected void assemble(AssembledChronology.Fields arg0) {
        arg0.millis = cMillisField;
        arg0.seconds = cSecondsField;
        arg0.minutes = cMinutesField;
        arg0.hours = cHoursField;
        arg0.halfdays = cHalfdaysField;
        arg0.days = cDaysField;
        arg0.weeks = cWeeksField;
        arg0.millisOfSecond = cMillisOfSecondField;
        arg0.millisOfDay = cMillisOfDayField;
        arg0.secondOfMinute = cSecondOfMinuteField;
        arg0.secondOfDay = cSecondOfDayField;
        arg0.minuteOfHour = cMinuteOfHourField;
        arg0.minuteOfDay = cMinuteOfDayField;
        arg0.hourOfDay = cHourOfDayField;
        arg0.hourOfHalfday = cHourOfHalfdayField;
        arg0.clockhourOfDay = cClockhourOfDayField;
        arg0.clockhourOfHalfday = cClockhourOfHalfdayField;
        arg0.halfdayOfDay = cHalfdayOfDayField;
        arg0.year = new BasicYearDateTimeField(this);
        arg0.yearOfEra = new GJYearOfEraDateTimeField(arg0.year, this);
        DecoratedDateTimeField decoratedDateTimeField = new OffsetDateTimeField(arg0.yearOfEra, 99);
        arg0.centuryOfEra = new DividedDateTimeField(decoratedDateTimeField, DateTimeFieldType.centuryOfEra(), 100);
        arg0.centuries = arg0.centuryOfEra.getDurationField();
        decoratedDateTimeField = new RemainderDateTimeField((DividedDateTimeField)arg0.centuryOfEra);
        arg0.yearOfCentury = new OffsetDateTimeField(decoratedDateTimeField, DateTimeFieldType.yearOfCentury(), 1);
        arg0.era = new GJEraDateTimeField(this);
        arg0.dayOfWeek = new GJDayOfWeekDateTimeField(this, arg0.days);
        arg0.dayOfMonth = new BasicDayOfMonthDateTimeField(this, arg0.days);
        arg0.dayOfYear = new BasicDayOfYearDateTimeField(this, arg0.days);
        arg0.monthOfYear = new GJMonthOfYearDateTimeField(this);
        arg0.weekyear = new BasicWeekyearDateTimeField(this);
        arg0.weekOfWeekyear = new BasicWeekOfWeekyearDateTimeField(this, arg0.weeks);
        decoratedDateTimeField = new RemainderDateTimeField(arg0.weekyear, arg0.centuries, DateTimeFieldType.weekyearOfCentury(), 100);
        arg0.weekyearOfCentury = new OffsetDateTimeField(decoratedDateTimeField, DateTimeFieldType.weekyearOfCentury(), 1);
        arg0.years = arg0.year.getDurationField();
        arg0.months = arg0.monthOfYear.getDurationField();
        arg0.weekyears = arg0.weekyear.getDurationField();
    }

    int getMaxMonth(int a2) {
        BasicChronology a3;
        return a3.getMaxMonth();
    }

    abstract int getMinYear();

    abstract int getDaysInYearMonth(int var1, int var2);

    abstract long getYearDifference(long var1, long var3);

    abstract int getMaxYear();

    public DateTimeZone getZone() {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getZone();
        }
        return DateTimeZone.UTC;
    }

    int getDaysInYear(int a2) {
        BasicChronology a3;
        return a3.isLeapYear(a2) ? 366 : 365;
    }

    boolean isLeapDay(long a2) {
        return false;
    }

    abstract long getApproxMillisAtEpochDividedByTwo();

    BasicChronology(Chronology a2, Object a3, int a4) {
        super(a2, a3);
        BasicChronology a5;
        if (a4 < 1 || a4 > 7) {
            throw new IllegalArgumentException("Invalid min days in first week: " + a4);
        }
        a5.iMinDaysInFirstWeek = a4;
    }

    int getWeekOfWeekyear(long a2, int a3) {
        BasicChronology a4;
        long l2 = a4.getFirstWeekOfYearMillis(a3);
        if (a2 < l2) {
            return a4.getWeeksInYear(a3 - 1);
        }
        long l3 = a4.getFirstWeekOfYearMillis(a3 + 1);
        if (a2 >= l3) {
            return 1;
        }
        return (int)((a2 - l2) / 604800000L) + 1;
    }

    int getDaysInMonthMaxForSet(long a2, int a3) {
        BasicChronology a4;
        return a4.getDaysInMonthMax(a2);
    }

    private long getDateTimeMillis0(int a2, int a3, int a4, int a5) {
        long l2;
        BasicChronology a6;
        long l3 = a6.getDateMidnightMillis(a2, a3, a4);
        if (l3 == Long.MIN_VALUE) {
            l3 = a6.getDateMidnightMillis(a2, a3, a4 + 1);
            a5 -= 86400000;
        }
        if ((l2 = l3 + (long)a5) < 0L && l3 > 0L) {
            return Long.MAX_VALUE;
        }
        if (l2 > 0L && l3 < 0L) {
            return Long.MIN_VALUE;
        }
        return l2;
    }

    long getYearMonthDayMillis(int a2, int a3, int a4) {
        BasicChronology a5;
        long l2 = a5.getYearMillis(a2);
        return (l2 += a5.getTotalMillisByYearMonth(a2, a3)) + (long)(a4 - 1) * 86400000L;
    }

    int getDayOfMonth(long a2, int a3, int a4) {
        BasicChronology a5;
        long l2 = a5.getYearMillis(a3);
        return (int)((a2 - (l2 += a5.getTotalMillisByYearMonth(a3, a4))) / 86400000L) + 1;
    }

    int getDaysInMonthMax(long a2) {
        BasicChronology a3;
        int n = a3.getYear(a2);
        int n2 = a3.getMonthOfYear(a2, n);
        return a3.getDaysInYearMonth(n, n2);
    }

    long getDateMidnightMillis(int a2, int a3, int a4) {
        BasicChronology a5;
        FieldUtils.verifyValueBounds(DateTimeFieldType.year(), a2, a5.getMinYear() - 1, a5.getMaxYear() + 1);
        FieldUtils.verifyValueBounds(DateTimeFieldType.monthOfYear(), a3, 1, a5.getMaxMonth(a2));
        FieldUtils.verifyValueBounds(DateTimeFieldType.dayOfMonth(), a4, 1, a5.getDaysInYearMonth(a2, a3));
        long l2 = a5.getYearMonthDayMillis(a2, a3, a4);
        if (l2 < 0L && a2 == a5.getMaxYear() + 1) {
            return Long.MAX_VALUE;
        }
        if (l2 > 0L && a2 == a5.getMinYear() - 1) {
            return Long.MIN_VALUE;
        }
        return l2;
    }

    int getMaxMonth() {
        return 12;
    }

    int getDayOfMonth(long a2, int a3) {
        BasicChronology a4;
        int n = a4.getMonthOfYear(a2, a3);
        return a4.getDayOfMonth(a2, a3, n);
    }

    int getMillisOfDay(long a2) {
        if (a2 >= 0L) {
            return (int)(a2 % 86400000L);
        }
        return 86399999 + (int)((a2 + 1L) % 86400000L);
    }

    int getDayOfWeek(long a2) {
        long l2;
        if (a2 >= 0L) {
            l2 = a2 / 86400000L;
        } else {
            l2 = (a2 - 86399999L) / 86400000L;
            if (l2 < -3L) {
                return 7 + (int)((l2 + 4L) % 7L);
            }
        }
        return 1 + (int)((l2 + 3L) % 7L);
    }

    public long getDateTimeMillis(int arg0, int arg1, int arg2, int arg3) throws IllegalArgumentException {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getDateTimeMillis(arg0, arg1, arg2, arg3);
        }
        FieldUtils.verifyValueBounds(DateTimeFieldType.millisOfDay(), arg3, 0, 86399999);
        return this.getDateTimeMillis0(arg0, arg1, arg2, arg3);
    }

    int getWeekOfWeekyear(long a2) {
        BasicChronology a3;
        return a3.getWeekOfWeekyear(a2, a3.getYear(a2));
    }

    long getFirstWeekOfYearMillis(int a2) {
        BasicChronology a3;
        long l2 = a3.getYearMillis(a2);
        int n = a3.getDayOfWeek(l2);
        if (n > 8 - a3.iMinDaysInFirstWeek) {
            return l2 + (long)(8 - n) * 86400000L;
        }
        return l2 - (long)(n - 1) * 86400000L;
    }

    long getYearMillis(int a2) {
        BasicChronology a3;
        return a3.getYearInfo((int)a2).iFirstDayMillis;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() * 11 + this.getZone().hashCode() + this.getMinimumDaysInFirstWeek();
    }

    abstract long setYear(long var1, int var3);

    abstract long calculateFirstDayOfYearMillis(int var1);

    abstract long getAverageMillisPerYearDividedByTwo();

    int getDayOfYear(long a2) {
        BasicChronology a3;
        return a3.getDayOfYear(a2, a3.getYear(a2));
    }

    int getMonthOfYear(long a2) {
        BasicChronology a3;
        return a3.getMonthOfYear(a2, a3.getYear(a2));
    }

    public long getDateTimeMillis(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) throws IllegalArgumentException {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getDateTimeMillis(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        }
        FieldUtils.verifyValueBounds(DateTimeFieldType.hourOfDay(), arg3, 0, 23);
        FieldUtils.verifyValueBounds(DateTimeFieldType.minuteOfHour(), arg4, 0, 59);
        FieldUtils.verifyValueBounds(DateTimeFieldType.secondOfMinute(), arg5, 0, 59);
        FieldUtils.verifyValueBounds(DateTimeFieldType.millisOfSecond(), arg6, 0, 999);
        long l2 = arg3 * 3600000 + arg4 * 60000 + arg5 * 1000 + arg6;
        return this.getDateTimeMillis0(arg0, arg1, arg2, (int)l2);
    }

    int getWeekyear(long a2) {
        BasicChronology a3;
        int n = a3.getYear(a2);
        int n2 = a3.getWeekOfWeekyear(a2, n);
        if (n2 == 1) {
            return a3.getYear(a2 + 604800000L);
        }
        if (n2 > 51) {
            return a3.getYear(a2 - 1209600000L);
        }
        return n;
    }

    int getYear(long a2) {
        long l2;
        int n;
        long l3;
        long l4;
        BasicChronology a3;
        long l5 = a3.getAverageMillisPerYearDividedByTwo();
        long l6 = (a2 >> 1) + a3.getApproxMillisAtEpochDividedByTwo();
        if (l6 < 0L) {
            l6 = l6 - l5 + 1L;
        }
        if ((l4 = a2 - (l3 = a3.getYearMillis(n = (int)(l6 / l5)))) < 0L) {
            --n;
        } else if (l4 >= 31536000000L && (l3 += (l2 = a3.isLeapYear(n) ? 31622400000L : 31536000000L)) <= a2) {
            ++n;
        }
        return n;
    }

    abstract int getDaysInMonthMax(int var1);

    int getDayOfYear(long a2, int a3) {
        BasicChronology a4;
        long l2 = a4.getYearMillis(a3);
        return (int)((a2 - l2) / 86400000L) + 1;
    }

    int getWeeksInYear(int a2) {
        BasicChronology a3;
        long l2 = a3.getFirstWeekOfYearMillis(a2);
        long l3 = a3.getFirstWeekOfYearMillis(a2 + 1);
        return (int)((l3 - l2) / 604800000L);
    }

    public int getMinimumDaysInFirstWeek() {
        return this.iMinDaysInFirstWeek;
    }

    abstract long getAverageMillisPerMonth();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(60);
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        stringBuilder.append(string);
        stringBuilder.append('[');
        DateTimeZone dateTimeZone = this.getZone();
        if (dateTimeZone != null) {
            stringBuilder.append(dateTimeZone.getID());
        }
        if (this.getMinimumDaysInFirstWeek() != 4) {
            stringBuilder.append(",mdfw=");
            stringBuilder.append(this.getMinimumDaysInFirstWeek());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    abstract long getAverageMillisPerYear();

    abstract boolean isLeapYear(int var1);

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 != null && this.getClass() == arg0.getClass()) {
            BasicChronology basicChronology = (BasicChronology)arg0;
            return this.getMinimumDaysInFirstWeek() == basicChronology.getMinimumDaysInFirstWeek() && this.getZone().equals(basicChronology.getZone());
        }
        return false;
    }

    abstract int getMonthOfYear(long var1, int var3);

    static {
        cMillisField = MillisDurationField.INSTANCE;
        cSecondsField = new PreciseDurationField(DurationFieldType.seconds(), 1000L);
        cMinutesField = new PreciseDurationField(DurationFieldType.minutes(), 60000L);
        cHoursField = new PreciseDurationField(DurationFieldType.hours(), 3600000L);
        cHalfdaysField = new PreciseDurationField(DurationFieldType.halfdays(), 43200000L);
        cDaysField = new PreciseDurationField(DurationFieldType.days(), 86400000L);
        cWeeksField = new PreciseDurationField(DurationFieldType.weeks(), 604800000L);
        cMillisOfSecondField = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), cMillisField, cSecondsField);
        cMillisOfDayField = new PreciseDateTimeField(DateTimeFieldType.millisOfDay(), cMillisField, cDaysField);
        cSecondOfMinuteField = new PreciseDateTimeField(DateTimeFieldType.secondOfMinute(), cSecondsField, cMinutesField);
        cSecondOfDayField = new PreciseDateTimeField(DateTimeFieldType.secondOfDay(), cSecondsField, cDaysField);
        cMinuteOfHourField = new PreciseDateTimeField(DateTimeFieldType.minuteOfHour(), cMinutesField, cHoursField);
        cMinuteOfDayField = new PreciseDateTimeField(DateTimeFieldType.minuteOfDay(), cMinutesField, cDaysField);
        cHourOfDayField = new PreciseDateTimeField(DateTimeFieldType.hourOfDay(), cHoursField, cDaysField);
        cHourOfHalfdayField = new PreciseDateTimeField(DateTimeFieldType.hourOfHalfday(), cHoursField, cHalfdaysField);
        cClockhourOfDayField = new ZeroIsMaxDateTimeField(cHourOfDayField, DateTimeFieldType.clockhourOfDay());
        cClockhourOfHalfdayField = new ZeroIsMaxDateTimeField(cHourOfHalfdayField, DateTimeFieldType.clockhourOfHalfday());
        cHalfdayOfDayField = new HalfdayField();
    }

    int getDaysInYearMax() {
        return 366;
    }

    int getDaysInMonthMax() {
        return 31;
    }

    long getYearMonthMillis(int a2, int a3) {
        BasicChronology a4;
        long l2 = a4.getYearMillis(a2);
        return l2 += a4.getTotalMillisByYearMonth(a2, a3);
    }

    private static class YearInfo {
        public final int iYear;
        public final long iFirstDayMillis;

        YearInfo(int a2, long a3) {
            YearInfo a4;
            a4.iYear = a2;
            a4.iFirstDayMillis = a3;
        }
    }

    private static class HalfdayField
    extends PreciseDateTimeField {
        private static final long serialVersionUID = 581601443656929254L;

        public int getMaximumTextLength(Locale arg0) {
            return GJLocaleSymbols.forLocale(arg0).getHalfdayMaxTextLength();
        }

        public String getAsText(int arg0, Locale arg1) {
            return GJLocaleSymbols.forLocale(arg1).halfdayValueToText(arg0);
        }

        HalfdayField() {
            super(DateTimeFieldType.halfdayOfDay(), cHalfdaysField, cDaysField);
            HalfdayField a2;
        }

        public long set(long arg0, String arg1, Locale arg2) {
            return this.set(arg0, GJLocaleSymbols.forLocale(arg2).halfdayTextToValue(arg1));
        }
    }
}

