/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.MutablePeriod;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.AbstractPeriod;
import org.joda.time.base.BaseLocal;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PeriodConverter;
import org.joda.time.field.FieldUtils;

public abstract class BasePeriod
extends AbstractPeriod
implements ReadablePeriod,
Serializable {
    private final int[] iValues;
    private final PeriodType iType;
    private static final long serialVersionUID = -2110953284060001145L;
    private static final ReadablePeriod DUMMY_PERIOD = new AbstractPeriod(){

        public int getValue(int arg0) {
            return 0;
        }
        {
            1 a2;
        }

        public PeriodType getPeriodType() {
            return PeriodType.time();
        }
    };

    protected void addField(DurationFieldType arg0, int arg1) {
        this.addFieldInto(this.iValues, arg0, arg1);
    }

    private int[] setPeriodInternal(int a2, int a3, int a4, int a5, int a6, int a7, int a8, int a9) {
        BasePeriod a10;
        int[] nArray = new int[a10.size()];
        a10.checkAndUpdate(DurationFieldType.years(), nArray, a2);
        a10.checkAndUpdate(DurationFieldType.months(), nArray, a3);
        a10.checkAndUpdate(DurationFieldType.weeks(), nArray, a4);
        a10.checkAndUpdate(DurationFieldType.days(), nArray, a5);
        a10.checkAndUpdate(DurationFieldType.hours(), nArray, a6);
        a10.checkAndUpdate(DurationFieldType.minutes(), nArray, a7);
        a10.checkAndUpdate(DurationFieldType.seconds(), nArray, a8);
        a10.checkAndUpdate(DurationFieldType.millis(), nArray, a9);
        return nArray;
    }

    protected void setValue(int arg0, int arg1) {
        this.iValues[arg0] = arg1;
    }

    protected void mergePeriod(ReadablePeriod arg0) {
        if (arg0 != null) {
            this.setValues(this.mergePeriodInto(this.getValues(), arg0));
        }
    }

    protected BasePeriod(long arg0, PeriodType arg1, Chronology arg2) {
        arg1 = this.checkPeriodType(arg1);
        arg2 = DateTimeUtils.getChronology(arg2);
        this.iType = arg1;
        this.iValues = arg2.get(this, arg0);
    }

    protected void addFieldInto(int[] arg0, DurationFieldType arg1, int arg2) {
        int n = this.indexOf(arg1);
        if (n == -1) {
            if (arg2 != 0 || arg1 == null) {
                throw new IllegalArgumentException("Period does not support field '" + arg1 + "'");
            }
        } else {
            arg0[n] = FieldUtils.safeAdd(arg0[n], arg2);
        }
    }

    protected void addPeriod(ReadablePeriod arg0) {
        if (arg0 != null) {
            this.setValues(this.addPeriodInto(this.getValues(), arg0));
        }
    }

    protected void setPeriod(ReadablePeriod arg0) {
        if (arg0 == null) {
            this.setValues(new int[this.size()]);
        } else {
            this.setPeriodInternal(arg0);
        }
    }

    private void checkAndUpdate(DurationFieldType a2, int[] a3, int a4) {
        BasePeriod a5;
        int n = a5.indexOf(a2);
        if (n == -1) {
            if (a4 != 0) {
                throw new IllegalArgumentException("Period does not support field '" + a2.getName() + "'");
            }
        } else {
            a3[n] = a4;
        }
    }

    public Duration toDurationTo(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        Chronology chronology = DateTimeUtils.getInstantChronology(arg0);
        long l3 = chronology.add(this, l2, -1);
        return new Duration(l3, l2);
    }

    protected BasePeriod(ReadableInstant arg0, ReadableInstant arg1, PeriodType arg2) {
        arg2 = this.checkPeriodType(arg2);
        if (arg0 == null && arg1 == null) {
            this.iType = arg2;
            this.iValues = new int[this.size()];
        } else {
            long l2 = DateTimeUtils.getInstantMillis(arg0);
            long l3 = DateTimeUtils.getInstantMillis(arg1);
            Chronology chronology = DateTimeUtils.getIntervalChronology(arg0, arg1);
            this.iType = arg2;
            this.iValues = chronology.get(this, l2, l3);
        }
    }

    protected int[] mergePeriodInto(int[] arg0, ReadablePeriod arg1) {
        int n = arg1.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DurationFieldType durationFieldType = arg1.getFieldType(i2);
            int n2 = arg1.getValue(i2);
            this.checkAndUpdate(durationFieldType, arg0, n2);
        }
        return arg0;
    }

    protected int[] addPeriodInto(int[] arg0, ReadablePeriod arg1) {
        int n = arg1.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DurationFieldType durationFieldType = arg1.getFieldType(i2);
            int n2 = arg1.getValue(i2);
            if (n2 == 0) continue;
            int n3 = this.indexOf(durationFieldType);
            if (n3 == -1) {
                throw new IllegalArgumentException("Period does not support field '" + durationFieldType.getName() + "'");
            }
            arg0[n3] = FieldUtils.safeAdd(this.getValue(n3), n2);
        }
        return arg0;
    }

    public int getValue(int arg0) {
        return this.iValues[arg0];
    }

    protected BasePeriod(ReadableInstant arg0, ReadableDuration arg1, PeriodType arg2) {
        arg2 = this.checkPeriodType(arg2);
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        long l3 = DateTimeUtils.getDurationMillis(arg1);
        long l4 = FieldUtils.safeAdd(l2, l3);
        Chronology chronology = DateTimeUtils.getInstantChronology(arg0);
        this.iType = arg2;
        this.iValues = chronology.get(this, l2, l4);
    }

    protected void setFieldInto(int[] arg0, DurationFieldType arg1, int arg2) {
        int n = this.indexOf(arg1);
        if (n == -1) {
            if (arg2 != 0 || arg1 == null) {
                throw new IllegalArgumentException("Period does not support field '" + arg1 + "'");
            }
        } else {
            arg0[n] = arg2;
        }
    }

    protected void setField(DurationFieldType arg0, int arg1) {
        this.setFieldInto(this.iValues, arg0, arg1);
    }

    protected void setPeriod(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        int[] nArray = this.setPeriodInternal(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        this.setValues(nArray);
    }

    public PeriodType getPeriodType() {
        return this.iType;
    }

    private void setPeriodInternal(ReadablePeriod a2) {
        BasePeriod a3;
        int[] nArray = new int[a3.size()];
        int n = a2.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DurationFieldType durationFieldType = a2.getFieldType(i2);
            int n2 = a2.getValue(i2);
            a3.checkAndUpdate(durationFieldType, nArray, n2);
        }
        a3.setValues(nArray);
    }

    protected BasePeriod(long arg0) {
        this.iType = PeriodType.standard();
        int[] nArray = ISOChronology.getInstanceUTC().get(DUMMY_PERIOD, arg0);
        this.iValues = new int[8];
        System.arraycopy(nArray, 0, this.iValues, 4, 4);
    }

    public Duration toDurationFrom(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        Chronology chronology = DateTimeUtils.getInstantChronology(arg0);
        long l3 = chronology.add(this, l2, 1);
        return new Duration(l2, l3);
    }

    protected BasePeriod(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, PeriodType arg8) {
        this.iType = arg8 = this.checkPeriodType(arg8);
        this.iValues = this.setPeriodInternal(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    protected BasePeriod(Object arg0, PeriodType arg1, Chronology arg2) {
        PeriodConverter periodConverter = ConverterManager.getInstance().getPeriodConverter(arg0);
        arg1 = arg1 == null ? periodConverter.getPeriodType(arg0) : arg1;
        this.iType = arg1 = this.checkPeriodType(arg1);
        if (this instanceof ReadWritablePeriod) {
            this.iValues = new int[this.size()];
            arg2 = DateTimeUtils.getChronology(arg2);
            periodConverter.setInto((ReadWritablePeriod)((Object)this), arg0, arg2);
        } else {
            this.iValues = new MutablePeriod(arg0, arg1, arg2).getValues();
        }
    }

    protected void setValues(int[] arg0) {
        System.arraycopy(arg0, 0, this.iValues, 0, this.iValues.length);
    }

    protected PeriodType checkPeriodType(PeriodType arg0) {
        return DateTimeUtils.getPeriodType(arg0);
    }

    protected BasePeriod(int[] arg0, PeriodType arg1) {
        this.iType = arg1;
        this.iValues = arg0;
    }

    protected BasePeriod(long arg0, long arg1, PeriodType arg2, Chronology arg3) {
        arg2 = this.checkPeriodType(arg2);
        arg3 = DateTimeUtils.getChronology(arg3);
        this.iType = arg2;
        this.iValues = arg3.get(this, arg0, arg1);
    }

    protected BasePeriod(ReadablePartial arg0, ReadablePartial arg1, PeriodType arg2) {
        if (arg0 == null || arg1 == null) {
            throw new IllegalArgumentException("ReadablePartial objects must not be null");
        }
        if (arg0 instanceof BaseLocal && arg1 instanceof BaseLocal && arg0.getClass() == arg1.getClass()) {
            arg2 = this.checkPeriodType(arg2);
            long l2 = ((BaseLocal)arg0).getLocalMillis();
            long l3 = ((BaseLocal)arg1).getLocalMillis();
            Chronology chronology = arg0.getChronology();
            chronology = DateTimeUtils.getChronology(chronology);
            this.iType = arg2;
            this.iValues = chronology.get(this, l2, l3);
        } else {
            if (arg0.size() != arg1.size()) {
                throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
            }
            int n = arg0.size();
            for (int i2 = 0; i2 < n; ++i2) {
                if (arg0.getFieldType(i2) == arg1.getFieldType(i2)) continue;
                throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
            }
            if (!DateTimeUtils.isContiguous(arg0)) {
                throw new IllegalArgumentException("ReadablePartial objects must be contiguous");
            }
            this.iType = this.checkPeriodType(arg2);
            Chronology chronology = DateTimeUtils.getChronology(arg0.getChronology()).withUTC();
            this.iValues = chronology.get(this, chronology.set(arg0, 0L), chronology.set(arg1, 0L));
        }
    }

    protected BasePeriod(ReadableDuration arg0, ReadableInstant arg1, PeriodType arg2) {
        arg2 = this.checkPeriodType(arg2);
        long l2 = DateTimeUtils.getDurationMillis(arg0);
        long l3 = DateTimeUtils.getInstantMillis(arg1);
        long l4 = FieldUtils.safeSubtract(l3, l2);
        Chronology chronology = DateTimeUtils.getInstantChronology(arg1);
        this.iType = arg2;
        this.iValues = chronology.get(this, l4, l3);
    }
}

