/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPartial
implements ReadablePartial,
Comparable<ReadablePartial> {
    protected abstract DateTimeField getField(int var1, Chronology var2);

    public String toString(DateTimeFormatter arg0) {
        if (arg0 == null) {
            return this.toString();
        }
        return arg0.print(this);
    }

    @Override
    public int get(DateTimeFieldType arg0) {
        return this.getValue(this.indexOfSupported(arg0));
    }

    public boolean isEqual(ReadablePartial arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(arg0) == 0;
    }

    public DateTimeField[] getFields() {
        DateTimeField[] dateTimeFieldArray = new DateTimeField[this.size()];
        for (int i2 = 0; i2 < dateTimeFieldArray.length; ++i2) {
            dateTimeFieldArray[i2] = this.getField(i2);
        }
        return dateTimeFieldArray;
    }

    @Override
    public int compareTo(ReadablePartial arg0) {
        int n;
        if (this == arg0) {
            return 0;
        }
        if (this.size() != arg0.size()) {
            throw new ClassCastException("ReadablePartial objects must have matching field types");
        }
        int n2 = this.size();
        for (n = 0; n < n2; ++n) {
            if (this.getFieldType(n) == arg0.getFieldType(n)) continue;
            throw new ClassCastException("ReadablePartial objects must have matching field types");
        }
        n2 = this.size();
        for (n = 0; n < n2; ++n) {
            if (this.getValue(n) > arg0.getValue(n)) {
                return 1;
            }
            if (this.getValue(n) >= arg0.getValue(n)) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public DateTimeFieldType getFieldType(int arg0) {
        return this.getField(arg0, this.getChronology()).getType();
    }

    public boolean isAfter(ReadablePartial arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(arg0) > 0;
    }

    public DateTimeFieldType[] getFieldTypes() {
        DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[this.size()];
        for (int i2 = 0; i2 < dateTimeFieldTypeArray.length; ++i2) {
            dateTimeFieldTypeArray[i2] = this.getFieldType(i2);
        }
        return dateTimeFieldTypeArray;
    }

    protected int indexOfSupported(DateTimeFieldType arg0) {
        int n = this.indexOf(arg0);
        if (n == -1) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        return n;
    }

    @Override
    public DateTimeField getField(int arg0) {
        return this.getField(arg0, this.getChronology());
    }

    protected int indexOf(DurationFieldType arg0) {
        int n = this.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.getFieldType(i2).getDurationType() != arg0) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof ReadablePartial)) {
            return false;
        }
        ReadablePartial readablePartial = (ReadablePartial)arg0;
        if (this.size() != readablePartial.size()) {
            return false;
        }
        int n = this.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.getValue(i2) == readablePartial.getValue(i2) && this.getFieldType(i2) == readablePartial.getFieldType(i2)) continue;
            return false;
        }
        return FieldUtils.equals(this.getChronology(), readablePartial.getChronology());
    }

    public int indexOf(DateTimeFieldType arg0) {
        int n = this.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.getFieldType(i2) != arg0) continue;
            return i2;
        }
        return -1;
    }

    protected int indexOfSupported(DurationFieldType arg0) {
        int n = this.indexOf(arg0);
        if (n == -1) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        return n;
    }

    @Override
    public boolean isSupported(DateTimeFieldType arg0) {
        return this.indexOf(arg0) != -1;
    }

    @Override
    public DateTime toDateTime(ReadableInstant arg0) {
        Chronology chronology = DateTimeUtils.getInstantChronology(arg0);
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        long l3 = chronology.set(this, l2);
        return new DateTime(l3, chronology);
    }

    @Override
    public int hashCode() {
        int n = 157;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            n = 23 * n + this.getValue(i2);
            n = 23 * n + this.getFieldType(i2).hashCode();
        }
        return n += this.getChronology().hashCode();
    }

    protected AbstractPartial() {
    }

    public boolean isBefore(ReadablePartial arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(arg0) < 0;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.getValue(i2);
        }
        return nArray;
    }
}

