/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.LocalDate;
import org.joda.time.Minutes;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Weeks
extends BaseSingleFieldPeriod {
    public static final Weeks TWO;
    private static final long serialVersionUID = 87525275727380866L;
    public static final Weeks ZERO;
    public static final Weeks THREE;
    private static final PeriodFormatter PARSER;
    public static final Weeks MAX_VALUE;
    public static final Weeks ONE;
    public static final Weeks MIN_VALUE;

    @FromString
    public static Weeks parseWeeks(String arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        Period period = PARSER.parsePeriod(arg0);
        return Weeks.weeks(period.getWeeks());
    }

    public int getWeeks() {
        return this.getValue();
    }

    public Hours toStandardHours() {
        return Hours.hours(FieldUtils.safeMultiply(this.getValue(), 168));
    }

    public boolean isGreaterThan(Weeks arg0) {
        if (arg0 == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > arg0.getValue();
    }

    public Weeks negated() {
        return Weeks.weeks(FieldUtils.safeNegate(this.getValue()));
    }

    public Weeks minus(int arg0) {
        return this.plus(FieldUtils.safeNegate(arg0));
    }

    private Object readResolve() {
        Weeks a2;
        return Weeks.weeks(a2.getValue());
    }

    public Duration toStandardDuration() {
        long l2 = this.getValue();
        return new Duration(l2 * 604800000L);
    }

    public DurationFieldType getFieldType() {
        return DurationFieldType.weeks();
    }

    public PeriodType getPeriodType() {
        return PeriodType.weeks();
    }

    public Weeks plus(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        return Weeks.weeks(FieldUtils.safeAdd(this.getValue(), arg0));
    }

    public Weeks plus(Weeks arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.plus(arg0.getValue());
    }

    private Weeks(int a2) {
        super(a2);
        Weeks a3;
    }

    public boolean isLessThan(Weeks arg0) {
        if (arg0 == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < arg0.getValue();
    }

    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "W";
    }

    public static Weeks weeksBetween(ReadableInstant arg0, ReadableInstant arg1) {
        int n = BaseSingleFieldPeriod.between(arg0, arg1, DurationFieldType.weeks());
        return Weeks.weeks(n);
    }

    public static Weeks weeksBetween(ReadablePartial arg0, ReadablePartial arg1) {
        if (arg0 instanceof LocalDate && arg1 instanceof LocalDate) {
            Chronology chronology = DateTimeUtils.getChronology(arg0.getChronology());
            int n = chronology.weeks().getDifference(((LocalDate)arg1).getLocalMillis(), ((LocalDate)arg0).getLocalMillis());
            return Weeks.weeks(n);
        }
        int n = BaseSingleFieldPeriod.between(arg0, arg1, ZERO);
        return Weeks.weeks(n);
    }

    public static Weeks weeks(int arg0) {
        switch (arg0) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Weeks(arg0);
    }

    public Minutes toStandardMinutes() {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), 10080));
    }

    public static Weeks standardWeeksIn(ReadablePeriod arg0) {
        int n = BaseSingleFieldPeriod.standardPeriodIn(arg0, 604800000L);
        return Weeks.weeks(n);
    }

    static {
        ZERO = new Weeks(0);
        ONE = new Weeks(1);
        TWO = new Weeks(2);
        THREE = new Weeks(3);
        MAX_VALUE = new Weeks(Integer.MAX_VALUE);
        MIN_VALUE = new Weeks(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.weeks());
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 604800));
    }

    public static Weeks weeksIn(ReadableInterval arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        int n = BaseSingleFieldPeriod.between(arg0.getStart(), arg0.getEnd(), DurationFieldType.weeks());
        return Weeks.weeks(n);
    }

    public Weeks dividedBy(int arg0) {
        if (arg0 == 1) {
            return this;
        }
        return Weeks.weeks(this.getValue() / arg0);
    }

    public Weeks minus(Weeks arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.minus(arg0.getValue());
    }

    public Weeks multipliedBy(int arg0) {
        return Weeks.weeks(FieldUtils.safeMultiply(this.getValue(), arg0));
    }

    public Days toStandardDays() {
        return Days.days(FieldUtils.safeMultiply(this.getValue(), 7));
    }
}

