/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BasePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISODateTimeFormat;

@Deprecated
public final class TimeOfDay
extends BasePartial
implements ReadablePartial,
Serializable {
    public static final int MILLIS_OF_SECOND = 3;
    public static final int SECOND_OF_MINUTE = 2;
    private static final DateTimeFieldType[] FIELD_TYPES = new DateTimeFieldType[]{DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute(), DateTimeFieldType.millisOfSecond()};
    private static final long serialVersionUID = 3633353405803318660L;
    public static final int MINUTE_OF_HOUR = 1;
    public static final int HOUR_OF_DAY = 0;
    public static final TimeOfDay MIDNIGHT = new TimeOfDay(0, 0, 0, 0);

    TimeOfDay(TimeOfDay a2, Chronology a3) {
        super((BasePartial)a2, a3);
        TimeOfDay a4;
    }

    public TimeOfDay minusMillis(int arg0) {
        return this.withFieldAdded(DurationFieldType.millis(), FieldUtils.safeNegate(arg0));
    }

    public TimeOfDay withMillisOfSecond(int arg0) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().millisOfSecond().set(this, 3, nArray, arg0);
        return new TimeOfDay(this, nArray);
    }

    public TimeOfDay(Object arg0, Chronology arg1) {
        super(arg0, DateTimeUtils.getChronology(arg1), ISODateTimeFormat.timeParser());
    }

    public int getMillisOfSecond() {
        return this.getValue(3);
    }

    public TimeOfDay(long arg0, Chronology arg1) {
        super(arg0, arg1);
    }

    public DateTimeFieldType getFieldType(int arg0) {
        return FIELD_TYPES[arg0];
    }

    public TimeOfDay(Object arg0) {
        super(arg0, null, ISODateTimeFormat.timeParser());
    }

    public TimeOfDay plusSeconds(int arg0) {
        return this.withFieldAdded(DurationFieldType.seconds(), arg0);
    }

    public TimeOfDay(int arg0, int arg1) {
        this(arg0, arg1, 0, 0, null);
    }

    public TimeOfDay minusMinutes(int arg0) {
        return this.withFieldAdded(DurationFieldType.minutes(), FieldUtils.safeNegate(arg0));
    }

    public Property secondOfMinute() {
        return new Property(this, 2);
    }

    public DateTime toDateTimeToday() {
        return this.toDateTimeToday(null);
    }

    public TimeOfDay withChronologyRetainFields(Chronology arg0) {
        arg0 = DateTimeUtils.getChronology(arg0);
        if ((arg0 = arg0.withUTC()) == this.getChronology()) {
            return this;
        }
        TimeOfDay timeOfDay = new TimeOfDay(this, arg0);
        arg0.validate(timeOfDay, this.getValues());
        return timeOfDay;
    }

    public int size() {
        return 4;
    }

    public TimeOfDay plusMillis(int arg0) {
        return this.withFieldAdded(DurationFieldType.millis(), arg0);
    }

    public TimeOfDay(long arg0) {
        super(arg0);
    }

    public TimeOfDay withHourOfDay(int arg0) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().hourOfDay().set(this, 0, nArray, arg0);
        return new TimeOfDay(this, nArray);
    }

    public TimeOfDay(int arg0, int arg1, Chronology arg2) {
        this(arg0, arg1, 0, 0, arg2);
    }

    public TimeOfDay withPeriodAdded(ReadablePeriod arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < arg0.size(); ++i2) {
            DurationFieldType durationFieldType = arg0.getFieldType(i2);
            int n = this.indexOf(durationFieldType);
            if (n < 0) continue;
            nArray = this.getField(n).addWrapPartial(this, n, nArray, FieldUtils.safeMultiply(arg0.getValue(i2), arg1));
        }
        return new TimeOfDay(this, nArray);
    }

    public TimeOfDay(Chronology arg0) {
        super(arg0);
    }

    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public TimeOfDay(int arg0, int arg1, int arg2, Chronology arg3) {
        this(arg0, arg1, arg2, 0, arg3);
    }

    public TimeOfDay minusHours(int arg0) {
        return this.withFieldAdded(DurationFieldType.hours(), FieldUtils.safeNegate(arg0));
    }

    public Property property(DateTimeFieldType arg0) {
        return new Property(this, this.indexOfSupported(arg0));
    }

    public int getHourOfDay() {
        return this.getValue(0);
    }

    public Property hourOfDay() {
        return new Property(this, 0);
    }

    public TimeOfDay plusHours(int arg0) {
        return this.withFieldAdded(DurationFieldType.hours(), arg0);
    }

    public int getSecondOfMinute() {
        return this.getValue(2);
    }

    public TimeOfDay withSecondOfMinute(int arg0) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().secondOfMinute().set(this, 2, nArray, arg0);
        return new TimeOfDay(this, nArray);
    }

    public LocalTime toLocalTime() {
        return new LocalTime(this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute(), this.getMillisOfSecond(), this.getChronology());
    }

    public TimeOfDay() {
    }

    public TimeOfDay(DateTimeZone arg0) {
        super(ISOChronology.getInstance(arg0));
    }

    public TimeOfDay withField(DateTimeFieldType arg0, int arg1) {
        int n = this.indexOfSupported(arg0);
        if (arg1 == this.getValue(n)) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).set(this, n, nArray, arg1);
        return new TimeOfDay(this, nArray);
    }

    public TimeOfDay(int arg0, int arg1, int arg2, int arg3) {
        this(arg0, arg1, arg2, arg3, null);
    }

    protected DateTimeField getField(int arg0, Chronology arg1) {
        switch (arg0) {
            case 0: {
                return arg1.hourOfDay();
            }
            case 1: {
                return arg1.minuteOfHour();
            }
            case 2: {
                return arg1.secondOfMinute();
            }
            case 3: {
                return arg1.millisOfSecond();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + arg0);
    }

    public static TimeOfDay fromCalendarFields(Calendar arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new TimeOfDay(arg0.get(11), arg0.get(12), arg0.get(13), arg0.get(14));
    }

    public static TimeOfDay fromDateFields(Date arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new TimeOfDay(arg0.getHours(), arg0.getMinutes(), arg0.getSeconds(), ((int)(arg0.getTime() % 1000L) + 1000) % 1000);
    }

    public TimeOfDay withMinuteOfHour(int arg0) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().minuteOfHour().set(this, 1, nArray, arg0);
        return new TimeOfDay(this, nArray);
    }

    public static TimeOfDay fromMillisOfDay(long arg0, Chronology arg1) {
        arg1 = DateTimeUtils.getChronology(arg1);
        arg1 = arg1.withUTC();
        return new TimeOfDay(arg0, arg1);
    }

    public TimeOfDay minus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, -1);
    }

    public TimeOfDay minusSeconds(int arg0) {
        return this.withFieldAdded(DurationFieldType.seconds(), FieldUtils.safeNegate(arg0));
    }

    public int getMinuteOfHour() {
        return this.getValue(1);
    }

    public TimeOfDay(int arg0, int arg1, int arg2, int arg3, Chronology arg4) {
        super(new int[]{arg0, arg1, arg2, arg3}, arg4);
    }

    public Property millisOfSecond() {
        return new Property(this, 3);
    }

    public TimeOfDay plus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, 1);
    }

    public TimeOfDay(int arg0, int arg1, int arg2) {
        this(arg0, arg1, arg2, 0, null);
    }

    public static TimeOfDay fromMillisOfDay(long arg0) {
        return TimeOfDay.fromMillisOfDay(arg0, null);
    }

    TimeOfDay(TimeOfDay a2, int[] a3) {
        super((BasePartial)a2, a3);
        TimeOfDay a4;
    }

    public TimeOfDay withFieldAdded(DurationFieldType arg0, int arg1) {
        int n = this.indexOfSupported(arg0);
        if (arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).addWrapPartial(this, n, nArray, arg1);
        return new TimeOfDay(this, nArray);
    }

    public DateTime toDateTimeToday(DateTimeZone arg0) {
        Chronology chronology = this.getChronology().withZone(arg0);
        long l2 = DateTimeUtils.currentTimeMillis();
        long l3 = chronology.set(this, l2);
        return new DateTime(l3, chronology);
    }

    public String toString() {
        return ISODateTimeFormat.tTime().print(this);
    }

    public Property minuteOfHour() {
        return new Property(this, 1);
    }

    public TimeOfDay plusMinutes(int arg0) {
        return this.withFieldAdded(DurationFieldType.minutes(), arg0);
    }

    @Deprecated
    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private final int iFieldIndex;
        private final TimeOfDay iTimeOfDay;
        private static final long serialVersionUID = 5598459141741063833L;

        public TimeOfDay addWrapFieldToCopy(int arg0) {
            int[] nArray = this.iTimeOfDay.getValues();
            nArray = this.getField().addWrapField(this.iTimeOfDay, this.iFieldIndex, nArray, arg0);
            return new TimeOfDay(this.iTimeOfDay, nArray);
        }

        protected ReadablePartial getReadablePartial() {
            return this.iTimeOfDay;
        }

        public TimeOfDay withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }

        public TimeOfDay addToCopy(int arg0) {
            int[] nArray = this.iTimeOfDay.getValues();
            nArray = this.getField().addWrapPartial(this.iTimeOfDay, this.iFieldIndex, nArray, arg0);
            return new TimeOfDay(this.iTimeOfDay, nArray);
        }

        public int get() {
            return this.iTimeOfDay.getValue(this.iFieldIndex);
        }

        public TimeOfDay getTimeOfDay() {
            return this.iTimeOfDay;
        }

        Property(TimeOfDay a2, int a3) {
            Property a4;
            a4.iTimeOfDay = a2;
            a4.iFieldIndex = a3;
        }

        public TimeOfDay setCopy(String arg0, Locale arg1) {
            int[] nArray = this.iTimeOfDay.getValues();
            nArray = this.getField().set(this.iTimeOfDay, this.iFieldIndex, nArray, arg0, arg1);
            return new TimeOfDay(this.iTimeOfDay, nArray);
        }

        public TimeOfDay setCopy(int arg0) {
            int[] nArray = this.iTimeOfDay.getValues();
            nArray = this.getField().set(this.iTimeOfDay, this.iFieldIndex, nArray, arg0);
            return new TimeOfDay(this.iTimeOfDay, nArray);
        }

        public TimeOfDay setCopy(String arg0) {
            return this.setCopy(arg0, null);
        }

        public DateTimeField getField() {
            return this.iTimeOfDay.getField(this.iFieldIndex);
        }

        public TimeOfDay addNoWrapToCopy(int arg0) {
            int[] nArray = this.iTimeOfDay.getValues();
            nArray = this.getField().add(this.iTimeOfDay, this.iFieldIndex, nArray, arg0);
            return new TimeOfDay(this.iTimeOfDay, nArray);
        }

        public TimeOfDay withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }
    }
}

