/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Seconds
extends BaseSingleFieldPeriod {
    public static final Seconds ONE;
    public static final Seconds MIN_VALUE;
    public static final Seconds MAX_VALUE;
    public static final Seconds THREE;
    private static final long serialVersionUID = 87525275727380862L;
    public static final Seconds ZERO;
    private static final PeriodFormatter PARSER;
    public static final Seconds TWO;

    static {
        ZERO = new Seconds(0);
        ONE = new Seconds(1);
        TWO = new Seconds(2);
        THREE = new Seconds(3);
        MAX_VALUE = new Seconds(Integer.MAX_VALUE);
        MIN_VALUE = new Seconds(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.seconds());
    }

    public Seconds plus(Seconds arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.plus(arg0.getValue());
    }

    public boolean isLessThan(Seconds arg0) {
        if (arg0 == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < arg0.getValue();
    }

    private Seconds(int a2) {
        super(a2);
        Seconds a3;
    }

    public static Seconds secondsBetween(ReadablePartial arg0, ReadablePartial arg1) {
        if (arg0 instanceof LocalTime && arg1 instanceof LocalTime) {
            Chronology chronology = DateTimeUtils.getChronology(arg0.getChronology());
            int n = chronology.seconds().getDifference(((LocalTime)arg1).getLocalMillis(), ((LocalTime)arg0).getLocalMillis());
            return Seconds.seconds(n);
        }
        int n = BaseSingleFieldPeriod.between(arg0, arg1, ZERO);
        return Seconds.seconds(n);
    }

    public Minutes toStandardMinutes() {
        return Minutes.minutes(this.getValue() / 60);
    }

    public static Seconds standardSecondsIn(ReadablePeriod arg0) {
        int n = BaseSingleFieldPeriod.standardPeriodIn(arg0, 1000L);
        return Seconds.seconds(n);
    }

    public Weeks toStandardWeeks() {
        return Weeks.weeks(this.getValue() / 604800);
    }

    public Hours toStandardHours() {
        return Hours.hours(this.getValue() / 3600);
    }

    @FromString
    public static Seconds parseSeconds(String arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        Period period = PARSER.parsePeriod(arg0);
        return Seconds.seconds(period.getSeconds());
    }

    public Duration toStandardDuration() {
        long l2 = this.getValue();
        return new Duration(l2 * 1000L);
    }

    public static Seconds secondsBetween(ReadableInstant arg0, ReadableInstant arg1) {
        int n = BaseSingleFieldPeriod.between(arg0, arg1, DurationFieldType.seconds());
        return Seconds.seconds(n);
    }

    public Days toStandardDays() {
        return Days.days(this.getValue() / 86400);
    }

    public Seconds multipliedBy(int arg0) {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), arg0));
    }

    public Seconds dividedBy(int arg0) {
        if (arg0 == 1) {
            return this;
        }
        return Seconds.seconds(this.getValue() / arg0);
    }

    public Seconds minus(Seconds arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.minus(arg0.getValue());
    }

    public PeriodType getPeriodType() {
        return PeriodType.seconds();
    }

    @ToString
    public String toString() {
        return "PT" + String.valueOf(this.getValue()) + "S";
    }

    public boolean isGreaterThan(Seconds arg0) {
        if (arg0 == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > arg0.getValue();
    }

    public DurationFieldType getFieldType() {
        return DurationFieldType.seconds();
    }

    public Seconds plus(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        return Seconds.seconds(FieldUtils.safeAdd(this.getValue(), arg0));
    }

    public Seconds minus(int arg0) {
        return this.plus(FieldUtils.safeNegate(arg0));
    }

    public Seconds negated() {
        return Seconds.seconds(FieldUtils.safeNegate(this.getValue()));
    }

    public static Seconds secondsIn(ReadableInterval arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        int n = BaseSingleFieldPeriod.between(arg0.getStart(), arg0.getEnd(), DurationFieldType.seconds());
        return Seconds.seconds(n);
    }

    public static Seconds seconds(int arg0) {
        switch (arg0) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Seconds(arg0);
    }

    public int getSeconds() {
        return this.getValue();
    }

    private Object readResolve() {
        Seconds a2;
        return Seconds.seconds(a2.getValue());
    }
}

