/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadWritableDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseDateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class MutableDateTime
extends BaseDateTime
implements ReadWritableDateTime,
Cloneable,
Serializable {
    public static final int ROUND_FLOOR = 1;
    public static final int ROUND_HALF_FLOOR = 3;
    public static final int ROUND_CEILING = 2;
    private DateTimeField iRoundingField;
    private static final long serialVersionUID = 2852608688135209575L;
    public static final int ROUND_HALF_EVEN = 5;
    public static final int ROUND_NONE = 0;
    private int iRoundingMode;
    public static final int ROUND_HALF_CEILING = 4;

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public static MutableDateTime now() {
        return new MutableDateTime();
    }

    public Property property(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        DateTimeField dateTimeField = arg0.getField(this.getChronology());
        if (!dateTimeField.isSupported()) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        return new Property(this, dateTimeField);
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public void setMinuteOfDay(int arg0) {
        this.setMillis(this.getChronology().minuteOfDay().set(this.getMillis(), arg0));
    }

    public void setTime(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        Chronology chronology = DateTimeUtils.getInstantChronology(arg0);
        DateTimeZone dateTimeZone = chronology.getZone();
        if (dateTimeZone != null) {
            l2 = dateTimeZone.getMillisKeepLocal(DateTimeZone.UTC, l2);
        }
        this.setTime(l2);
    }

    public MutableDateTime(Object arg0) {
        super(arg0, (Chronology)null);
    }

    public MutableDateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, Chronology arg7) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public static MutableDateTime parse(String arg0, DateTimeFormatter arg1) {
        return arg1.parseDateTime(arg0).toMutableDateTime();
    }

    public Property minuteOfDay() {
        return new Property(this, this.getChronology().minuteOfDay());
    }

    public Property hourOfDay() {
        return new Property(this, this.getChronology().hourOfDay());
    }

    public Property secondOfDay() {
        return new Property(this, this.getChronology().secondOfDay());
    }

    public void addHours(int arg0) {
        if (arg0 != 0) {
            this.setMillis(this.getChronology().hours().add(this.getMillis(), arg0));
        }
    }

    public MutableDateTime copy() {
        return (MutableDateTime)this.clone();
    }

    public void add(DurationFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (arg1 != 0) {
            this.setMillis(arg0.getField(this.getChronology()).add(this.getMillis(), arg1));
        }
    }

    public void setWeekyear(int arg0) {
        this.setMillis(this.getChronology().weekyear().set(this.getMillis(), arg0));
    }

    public void setDayOfMonth(int arg0) {
        this.setMillis(this.getChronology().dayOfMonth().set(this.getMillis(), arg0));
    }

    public void addMonths(int arg0) {
        if (arg0 != 0) {
            this.setMillis(this.getChronology().months().add(this.getMillis(), arg0));
        }
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    public void setDate(ReadableInstant arg0) {
        ReadableDateTime readableDateTime;
        Chronology chronology;
        DateTimeZone dateTimeZone;
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        if (arg0 instanceof ReadableDateTime && (dateTimeZone = (chronology = DateTimeUtils.getChronology((readableDateTime = (ReadableDateTime)arg0).getChronology())).getZone()) != null) {
            l2 = dateTimeZone.getMillisKeepLocal(this.getZone(), l2);
        }
        this.setDate(l2);
    }

    public void add(ReadablePeriod arg0) {
        this.add(arg0, 1);
    }

    public void add(ReadablePeriod arg0, int arg1) {
        if (arg0 != null) {
            this.setMillis(this.getChronology().add(arg0, this.getMillis(), arg1));
        }
    }

    public void setChronology(Chronology arg0) {
        super.setChronology(arg0);
    }

    public void setMinuteOfHour(int arg0) {
        this.setMillis(this.getChronology().minuteOfHour().set(this.getMillis(), arg0));
    }

    public void setDateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        long l2 = this.getChronology().getDateTimeMillis(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        this.setMillis(l2);
    }

    public void setMillis(long arg0) {
        switch (this.iRoundingMode) {
            case 0: {
                break;
            }
            case 1: {
                arg0 = this.iRoundingField.roundFloor(arg0);
                break;
            }
            case 2: {
                arg0 = this.iRoundingField.roundCeiling(arg0);
                break;
            }
            case 3: {
                arg0 = this.iRoundingField.roundHalfFloor(arg0);
                break;
            }
            case 4: {
                arg0 = this.iRoundingField.roundHalfCeiling(arg0);
                break;
            }
            case 5: {
                arg0 = this.iRoundingField.roundHalfEven(arg0);
            }
        }
        super.setMillis(arg0);
    }

    public void add(ReadableDuration arg0) {
        this.add(arg0, 1);
    }

    public void setRounding(DateTimeField arg0, int arg1) {
        if (arg0 != null && (arg1 < 0 || arg1 > 5)) {
            throw new IllegalArgumentException("Illegal rounding mode: " + arg1);
        }
        this.iRoundingField = arg1 == 0 ? null : arg0;
        this.iRoundingMode = arg0 == null ? 0 : arg1;
        this.setMillis(this.getMillis());
    }

    public void setTime(long arg0) {
        int n = ISOChronology.getInstanceUTC().millisOfDay().get(arg0);
        this.setMillis(this.getChronology().millisOfDay().set(this.getMillis(), n));
    }

    public void setHourOfDay(int arg0) {
        this.setMillis(this.getChronology().hourOfDay().set(this.getMillis(), arg0));
    }

    public MutableDateTime(DateTimeZone arg0) {
        super(arg0);
    }

    public void setSecondOfMinute(int arg0) {
        this.setMillis(this.getChronology().secondOfMinute().set(this.getMillis(), arg0));
    }

    public static MutableDateTime now(DateTimeZone arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new MutableDateTime(arg0);
    }

    public void set(DateTimeFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        this.setMillis(arg0.getField(this.getChronology()).set(this.getMillis(), arg1));
    }

    public void setDayOfWeek(int arg0) {
        this.setMillis(this.getChronology().dayOfWeek().set(this.getMillis(), arg0));
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public void setRounding(DateTimeField arg0) {
        this.setRounding(arg0, 1);
    }

    public void addYears(int arg0) {
        if (arg0 != 0) {
            this.setMillis(this.getChronology().years().add(this.getMillis(), arg0));
        }
    }

    public MutableDateTime() {
    }

    public Property millisOfDay() {
        return new Property(this, this.getChronology().millisOfDay());
    }

    public void addSeconds(int arg0) {
        if (arg0 != 0) {
            this.setMillis(this.getChronology().seconds().add(this.getMillis(), arg0));
        }
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public void setDate(int arg0, int arg1, int arg2) {
        Chronology chronology = this.getChronology();
        long l2 = chronology.getDateTimeMillis(arg0, arg1, arg2, 0);
        this.setDate(l2);
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public void setSecondOfDay(int arg0) {
        this.setMillis(this.getChronology().secondOfDay().set(this.getMillis(), arg0));
    }

    public static MutableDateTime now(Chronology arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new MutableDateTime(arg0);
    }

    public Property secondOfMinute() {
        return new Property(this, this.getChronology().secondOfMinute());
    }

    public int getRoundingMode() {
        return this.iRoundingMode;
    }

    public void addMinutes(int arg0) {
        if (arg0 != 0) {
            this.setMillis(this.getChronology().minutes().add(this.getMillis(), arg0));
        }
    }

    public void setZoneRetainFields(DateTimeZone arg0) {
        DateTimeZone dateTimeZone;
        if ((arg0 = DateTimeUtils.getZone(arg0)) == (dateTimeZone = DateTimeUtils.getZone(this.getZone()))) {
            return;
        }
        long l2 = dateTimeZone.getMillisKeepLocal(arg0, this.getMillis());
        this.setChronology(this.getChronology().withZone(arg0));
        this.setMillis(l2);
    }

    public Property minuteOfHour() {
        return new Property(this, this.getChronology().minuteOfHour());
    }

    public void setMillis(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        this.setMillis(l2);
    }

    public void setYear(int arg0) {
        this.setMillis(this.getChronology().year().set(this.getMillis(), arg0));
    }

    public void addMillis(int arg0) {
        if (arg0 != 0) {
            this.setMillis(this.getChronology().millis().add(this.getMillis(), arg0));
        }
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public void addWeeks(int arg0) {
        if (arg0 != 0) {
            this.setMillis(this.getChronology().weeks().add(this.getMillis(), arg0));
        }
    }

    public void setDate(long arg0) {
        this.setMillis(this.getChronology().millisOfDay().set(arg0, this.getMillisOfDay()));
    }

    public MutableDateTime(Object arg0, Chronology arg1) {
        super(arg0, DateTimeUtils.getChronology(arg1));
    }

    public MutableDateTime(Object arg0, DateTimeZone arg1) {
        super(arg0, arg1);
    }

    public void setMonthOfYear(int arg0) {
        this.setMillis(this.getChronology().monthOfYear().set(this.getMillis(), arg0));
    }

    public void addDays(int arg0) {
        if (arg0 != 0) {
            this.setMillis(this.getChronology().days().add(this.getMillis(), arg0));
        }
    }

    public MutableDateTime(long arg0) {
        super(arg0);
    }

    public void setWeekOfWeekyear(int arg0) {
        this.setMillis(this.getChronology().weekOfWeekyear().set(this.getMillis(), arg0));
    }

    public void setTime(int arg0, int arg1, int arg2, int arg3) {
        long l2 = this.getChronology().getDateTimeMillis(this.getMillis(), arg0, arg1, arg2, arg3);
        this.setMillis(l2);
    }

    public MutableDateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public MutableDateTime(long arg0, DateTimeZone arg1) {
        super(arg0, arg1);
    }

    public MutableDateTime(Chronology arg0) {
        super(arg0);
    }

    public void add(long arg0) {
        this.setMillis(FieldUtils.safeAdd(this.getMillis(), arg0));
    }

    public void setMillisOfSecond(int arg0) {
        this.setMillis(this.getChronology().millisOfSecond().set(this.getMillis(), arg0));
    }

    public void add(ReadableDuration arg0, int arg1) {
        if (arg0 != null) {
            this.add(FieldUtils.safeMultiply(arg0.getMillis(), arg1));
        }
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public void setDayOfYear(int arg0) {
        this.setMillis(this.getChronology().dayOfYear().set(this.getMillis(), arg0));
    }

    public void setMillisOfDay(int arg0) {
        this.setMillis(this.getChronology().millisOfDay().set(this.getMillis(), arg0));
    }

    public DateTimeField getRoundingField() {
        return this.iRoundingField;
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    public void addWeekyears(int arg0) {
        if (arg0 != 0) {
            this.setMillis(this.getChronology().weekyears().add(this.getMillis(), arg0));
        }
    }

    public MutableDateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, DateTimeZone arg7) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone error");
        }
    }

    @FromString
    public static MutableDateTime parse(String arg0) {
        return MutableDateTime.parse(arg0, ISODateTimeFormat.dateTimeParser().withOffsetParsed());
    }

    public void setZone(DateTimeZone arg0) {
        arg0 = DateTimeUtils.getZone(arg0);
        Chronology chronology = this.getChronology();
        if (chronology.getZone() != arg0) {
            this.setChronology(chronology.withZone(arg0));
        }
    }

    public MutableDateTime(long arg0, Chronology arg1) {
        super(arg0, arg1);
    }

    public Property millisOfSecond() {
        return new Property(this, this.getChronology().millisOfSecond());
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private MutableDateTime iInstant;
        private DateTimeField iField;
        private static final long serialVersionUID = -4481126543819298617L;

        public MutableDateTime roundFloor() {
            this.iInstant.setMillis(this.getField().roundFloor(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime set(String arg0) {
            this.set(arg0, null);
            return this.iInstant;
        }

        public MutableDateTime set(int arg0) {
            this.iInstant.setMillis(this.getField().set(this.iInstant.getMillis(), arg0));
            return this.iInstant;
        }

        protected long getMillis() {
            return this.iInstant.getMillis();
        }

        public DateTimeField getField() {
            return this.iField;
        }

        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
            Property a3;
            a3.iInstant = (MutableDateTime)a2.readObject();
            DateTimeFieldType dateTimeFieldType = (DateTimeFieldType)a2.readObject();
            a3.iField = dateTimeFieldType.getField(a3.iInstant.getChronology());
        }

        public MutableDateTime addWrapField(int arg0) {
            this.iInstant.setMillis(this.getField().addWrapField(this.iInstant.getMillis(), arg0));
            return this.iInstant;
        }

        public MutableDateTime add(long arg0) {
            this.iInstant.setMillis(this.getField().add(this.iInstant.getMillis(), arg0));
            return this.iInstant;
        }

        public MutableDateTime set(String arg0, Locale arg1) {
            this.iInstant.setMillis(this.getField().set(this.iInstant.getMillis(), arg0, arg1));
            return this.iInstant;
        }

        public MutableDateTime add(int arg0) {
            this.iInstant.setMillis(this.getField().add(this.iInstant.getMillis(), arg0));
            return this.iInstant;
        }

        Property(MutableDateTime a2, DateTimeField a3) {
            Property a4;
            a4.iInstant = a2;
            a4.iField = a3;
        }

        private void writeObject(ObjectOutputStream a2) throws IOException {
            Property a3;
            a2.writeObject(a3.iInstant);
            a2.writeObject(a3.iField.getType());
        }

        public MutableDateTime roundHalfFloor() {
            this.iInstant.setMillis(this.getField().roundHalfFloor(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime roundHalfEven() {
            this.iInstant.setMillis(this.getField().roundHalfEven(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime roundHalfCeiling() {
            this.iInstant.setMillis(this.getField().roundHalfCeiling(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime roundCeiling() {
            this.iInstant.setMillis(this.getField().roundCeiling(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime getMutableDateTime() {
            return this.iInstant;
        }
    }
}

