/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.convert.FromString;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.base.BaseDuration;
import org.joda.time.field.FieldUtils;

public final class Duration
extends BaseDuration
implements ReadableDuration,
Serializable {
    public static final Duration ZERO = new Duration(0L);
    private static final long serialVersionUID = 2471658376918L;

    public static Duration standardDays(long arg0) {
        if (arg0 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(arg0, 86400000));
    }

    public Duration withMillis(long arg0) {
        if (arg0 == this.getMillis()) {
            return this;
        }
        return new Duration(arg0);
    }

    public Duration withDurationAdded(ReadableDuration arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        return this.withDurationAdded(arg0.getMillis(), arg1);
    }

    public Days toStandardDays() {
        long l2 = this.getStandardDays();
        return Days.days(FieldUtils.safeToInt(l2));
    }

    public Duration plus(ReadableDuration arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.withDurationAdded(arg0.getMillis(), 1);
    }

    public Duration minus(long arg0) {
        return this.withDurationAdded(arg0, -1);
    }

    public static Duration millis(long arg0) {
        if (arg0 == 0L) {
            return ZERO;
        }
        return new Duration(arg0);
    }

    public Duration multipliedBy(long arg0) {
        if (arg0 == 1L) {
            return this;
        }
        return new Duration(FieldUtils.safeMultiply(this.getMillis(), arg0));
    }

    public Hours toStandardHours() {
        long l2 = this.getStandardHours();
        return Hours.hours(FieldUtils.safeToInt(l2));
    }

    public static Duration standardMinutes(long arg0) {
        if (arg0 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(arg0, 60000));
    }

    public static Duration standardHours(long arg0) {
        if (arg0 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(arg0, 3600000));
    }

    public Duration plus(long arg0) {
        return this.withDurationAdded(arg0, 1);
    }

    @FromString
    public static Duration parse(String arg0) {
        return new Duration(arg0);
    }

    public Duration(ReadableInstant arg0, ReadableInstant arg1) {
        super(arg0, arg1);
    }

    public Duration withDurationAdded(long arg0, int arg1) {
        if (arg0 == 0L || arg1 == 0) {
            return this;
        }
        long l2 = FieldUtils.safeMultiply(arg0, arg1);
        long l3 = FieldUtils.safeAdd(this.getMillis(), l2);
        return new Duration(l3);
    }

    public long getStandardDays() {
        return this.getMillis() / 86400000L;
    }

    public Seconds toStandardSeconds() {
        long l2 = this.getStandardSeconds();
        return Seconds.seconds(FieldUtils.safeToInt(l2));
    }

    public Duration(long arg0) {
        super(arg0);
    }

    public Minutes toStandardMinutes() {
        long l2 = this.getStandardMinutes();
        return Minutes.minutes(FieldUtils.safeToInt(l2));
    }

    public static Duration standardSeconds(long arg0) {
        if (arg0 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(arg0, 1000));
    }

    public Duration negated() {
        if (this.getMillis() == Long.MIN_VALUE) {
            throw new ArithmeticException("Negation of this duration would overflow");
        }
        return new Duration(-this.getMillis());
    }

    public long getStandardMinutes() {
        return this.getMillis() / 60000L;
    }

    public long getStandardSeconds() {
        return this.getMillis() / 1000L;
    }

    public long getStandardHours() {
        return this.getMillis() / 3600000L;
    }

    public Duration minus(ReadableDuration arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.withDurationAdded(arg0.getMillis(), -1);
    }

    public Duration(long arg0, long arg1) {
        super(arg0, arg1);
    }

    public Duration toDuration() {
        return this;
    }

    public Duration(Object arg0) {
        super(arg0);
    }

    public Duration dividedBy(long arg0) {
        if (arg0 == 1L) {
            return this;
        }
        return new Duration(FieldUtils.safeDivide(this.getMillis(), arg0));
    }
}

