/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.LocalDate;
import org.joda.time.Minutes;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Days
extends BaseSingleFieldPeriod {
    public static final Days MIN_VALUE;
    public static final Days THREE;
    public static final Days FOUR;
    public static final Days ZERO;
    public static final Days MAX_VALUE;
    public static final Days SEVEN;
    public static final Days FIVE;
    private static final long serialVersionUID = 87525275727380865L;
    private static final PeriodFormatter PARSER;
    public static final Days TWO;
    public static final Days SIX;
    public static final Days ONE;

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 86400));
    }

    public DurationFieldType getFieldType() {
        return DurationFieldType.days();
    }

    static {
        ZERO = new Days(0);
        ONE = new Days(1);
        TWO = new Days(2);
        THREE = new Days(3);
        FOUR = new Days(4);
        FIVE = new Days(5);
        SIX = new Days(6);
        SEVEN = new Days(7);
        MAX_VALUE = new Days(Integer.MAX_VALUE);
        MIN_VALUE = new Days(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.days());
    }

    public Minutes toStandardMinutes() {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), 1440));
    }

    public Duration toStandardDuration() {
        long l2 = this.getValue();
        return new Duration(l2 * 86400000L);
    }

    private Days(int a2) {
        super(a2);
        Days a3;
    }

    public static Days daysIn(ReadableInterval arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        int n = BaseSingleFieldPeriod.between(arg0.getStart(), arg0.getEnd(), DurationFieldType.days());
        return Days.days(n);
    }

    public Days minus(int arg0) {
        return this.plus(FieldUtils.safeNegate(arg0));
    }

    public Days dividedBy(int arg0) {
        if (arg0 == 1) {
            return this;
        }
        return Days.days(this.getValue() / arg0);
    }

    public boolean isLessThan(Days arg0) {
        if (arg0 == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < arg0.getValue();
    }

    public Days plus(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        return Days.days(FieldUtils.safeAdd(this.getValue(), arg0));
    }

    public Days negated() {
        return Days.days(FieldUtils.safeNegate(this.getValue()));
    }

    private Object readResolve() {
        Days a2;
        return Days.days(a2.getValue());
    }

    public PeriodType getPeriodType() {
        return PeriodType.days();
    }

    public boolean isGreaterThan(Days arg0) {
        if (arg0 == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > arg0.getValue();
    }

    public static Days standardDaysIn(ReadablePeriod arg0) {
        int n = BaseSingleFieldPeriod.standardPeriodIn(arg0, 86400000L);
        return Days.days(n);
    }

    public Hours toStandardHours() {
        return Hours.hours(FieldUtils.safeMultiply(this.getValue(), 24));
    }

    public static Days daysBetween(ReadableInstant arg0, ReadableInstant arg1) {
        int n = BaseSingleFieldPeriod.between(arg0, arg1, DurationFieldType.days());
        return Days.days(n);
    }

    public Days multipliedBy(int arg0) {
        return Days.days(FieldUtils.safeMultiply(this.getValue(), arg0));
    }

    public Days minus(Days arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.minus(arg0.getValue());
    }

    public int getDays() {
        return this.getValue();
    }

    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "D";
    }

    public static Days daysBetween(ReadablePartial arg0, ReadablePartial arg1) {
        if (arg0 instanceof LocalDate && arg1 instanceof LocalDate) {
            Chronology chronology = DateTimeUtils.getChronology(arg0.getChronology());
            int n = chronology.days().getDifference(((LocalDate)arg1).getLocalMillis(), ((LocalDate)arg0).getLocalMillis());
            return Days.days(n);
        }
        int n = BaseSingleFieldPeriod.between(arg0, arg1, ZERO);
        return Days.days(n);
    }

    @FromString
    public static Days parseDays(String arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        Period period = PARSER.parsePeriod(arg0);
        return Days.days(period.getDays());
    }

    public Days plus(Days arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.plus(arg0.getValue());
    }

    public static Days days(int arg0) {
        switch (arg0) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case 6: {
                return SIX;
            }
            case 7: {
                return SEVEN;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Days(arg0);
    }

    public Weeks toStandardWeeks() {
        return Weeks.weeks(this.getValue() / 7);
    }
}

