/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.univariate.arima;

import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.timeseries.linear.univariate.stationaryprocess.arma.ARMAXModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ARIMAXModel {
    private final double[] short;
    private final double enum;
    private final int false;
    private final double[] void;
    private final double if;
    private final double[] new;

    static {
        Package.validate("NMDEV_STAT");
    }

    public Polynomial phiPolynomial() {
        double[] a2 = new double[this.p() + 1];
        a2[0] = 1.0;
        for (int a3 = 1; a3 < a2.length; ++a3) {
            a2[a3] = -this.AR(a3);
        }
        DoubleUtils.reverse(a2);
        return new Polynomial(a2);
    }

    public int q() {
        return this.void.length - 1;
    }

    public double[] theta() {
        return Arrays.copyOf(this.void, this.void.length);
    }

    public ARIMAXModel(double mu, double[] AR, int d2, double[] MA, double[] psi) {
        this(mu, AR, d2, MA, psi, 1.0);
    }

    public double[] psi() {
        return this.short != null ? Arrays.copyOf(this.short, this.short.length) : null;
    }

    public double AR(int i2) {
        return i2 <= this.p() ? this.new[i2] : 0.0;
    }

    public ARIMAXModel(ARIMAXModel that) {
        this.enum = that.enum;
        this.new = Arrays.copyOf(that.new, that.new.length);
        this.void = Arrays.copyOf(that.void, that.void.length);
        this.short = that.short != null ? Arrays.copyOf(that.short, that.short.length) : null;
        this.false = that.false;
        this.if = that.if;
    }

    public Polynomial thetaPolynomial() {
        double[] a2 = new double[this.q() + 1];
        a2[0] = 1.0;
        for (int a3 = 1; a3 < a2.length; ++a3) {
            a2[a3] = this.MA(a3);
        }
        DoubleUtils.reverse(a2);
        return new Polynomial(a2);
    }

    public double sigma() {
        return this.if;
    }

    public double mu() {
        return this.enum;
    }

    public double MA(int i2) {
        return i2 <= this.q() ? this.void[i2] : 0.0;
    }

    public ARMAXModel getARMAX() {
        return new ARMAXModel(this.enum, Arrays.copyOfRange(this.new, 1, this.new.length), Arrays.copyOfRange(this.void, 1, this.void.length), this.short, this.if);
    }

    public ARIMAXModel(double mu, double[] AR, int d2, double[] MA, double[] psi, double sigma) {
        int a2;
        ArgumentAssertion.assertTrue(AR != null || MA != null, "at least one of AR and MA terms cannot be null", new Object[0]);
        ArgumentAssertion.assertNonNegative(d2, "d");
        ArgumentAssertion.assertNonNegative(sigma, "sigma");
        this.enum = mu;
        this.new = new double[AR != null ? AR.length + 1 : 1];
        this.new[0] = 1.0;
        for (a2 = 1; a2 < this.new.length; ++a2) {
            this.new[a2] = AR[a2 - 1];
        }
        this.void = new double[MA != null ? MA.length + 1 : 1];
        this.void[0] = 1.0;
        for (a2 = 1; a2 < this.void.length; ++a2) {
            this.void[a2] = MA[a2 - 1];
        }
        this.short = psi != null ? Arrays.copyOf(psi, psi.length) : null;
        this.false = d2;
        this.if = sigma;
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append("x_t = ");
        a3.append(this.enum);
        a3.append(" + (");
        if (this.new != null) {
            for (a2 = 1; a2 < this.new.length; ++a2) {
                a3.append(this.new[a2]);
                a3.append(String.format("*x_{t-%d}", a2));
                if (a2 == this.new.length - 1) continue;
                a3.append("+");
            }
        }
        a3.append(")");
        a3.append(" + (");
        if (this.void != null) {
            for (a2 = 1; a2 < this.void.length; ++a2) {
                a3.append(this.void[a2]);
                a3.append(String.format("*e_{t-%d}", a2));
                if (a2 == this.void.length - 1) continue;
                a3.append("+");
            }
        }
        a3.append(")");
        if (this.short != null) {
            a3.append(" + (");
            for (a2 = 0; a2 < this.short.length; ++a2) {
                a3.append(this.short[a2]);
                a3.append(String.format("*D_{t-%d}", a2));
                if (a2 == this.short.length - 1) continue;
                a3.append("+");
            }
            a3.append(")");
        }
        a3.append(" + e_t");
        a3.append(String.format("; var(e_t) = %f, d = %d", this.if, this.false));
        return a3.toString();
    }

    public ARIMAXModel(double[] AR, int d2, double[] MA, double[] psi, double sigma) {
        this(0.0, AR, d2, MA, psi, sigma);
    }

    public int d() {
        return this.false;
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    public double[] phi() {
        return Arrays.copyOf(this.new, this.new.length);
    }

    public ARIMAXModel(double[] AR, int d2, double[] MA, double[] psi) {
        this(0.0, AR, d2, MA, psi, 1.0);
    }

    public int p() {
        return this.new.length - 1;
    }
}

