/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.datastructure.multivariate.realtime.inttime;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.timeseries.datastructure.multivariate.realtime.inttime.MultivariateIntTimeTimeSeries;
import dev.nm.stat.timeseries.datastructure.univariate.realtime.inttime.IntTimeTimeSeries;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateSimpleTimeSeries
implements MultivariateIntTimeTimeSeries {
    private final List<Vector> new = new ArrayList<Vector>();

    public MultivariateSimpleTimeSeries(Matrix values) {
        for (int a2 = 1; a2 <= values.nRows(); ++a2) {
            this.new.add(values.getRow(a2));
        }
    }

    @Override
    public Iterator<MultivariateIntTimeTimeSeries.Entry> iterator() {
        return new Iterator<MultivariateIntTimeTimeSeries.Entry>(){
            private int if;
            private final Iterator<Vector> new;

            @Override
            public MultivariateIntTimeTimeSeries.Entry next() {
                Vector a2 = this.new.next();
                return new MultivariateIntTimeTimeSeries.Entry(this.if++, a2);
            }
            {
                1 a3;
                a3.new = a3.MultivariateSimpleTimeSeries.this.new.iterator();
                a3.if = 1;
            }

            @Override
            public boolean hasNext() {
                return this.new.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("time series is immutable");
            }
        };
    }

    @Override
    public int dimension() {
        return this.new.get(0).size();
    }

    public MultivariateSimpleTimeSeries(Vector ... values) {
        this(MatrixFactory.rbind(values));
    }

    @Override
    public int size() {
        return this.new.size();
    }

    @Override
    public Matrix toMatrix() {
        Vector[] a2 = new Vector[this.new.size()];
        int a3 = 0;
        for (Vector a4 : this.new) {
            a2[a3++] = a4;
        }
        return MatrixFactory.rbind(a2);
    }

    public MultivariateSimpleTimeSeries lag(int nLags, int length) {
        ArgumentAssertion.assertNonNegative(nLags, "nLags");
        int a2 = this.size() - nLags - length + 1;
        ArgumentAssertion.assertTrue(a2 >= 1, "lagged series length is too long", new Object[0]);
        Vector[] a3 = new Vector[length];
        for (int a4 = a2; a4 <= this.size() - nLags; ++a4) {
            a3[a4 - a2] = this.new.get(a4 - 1);
        }
        return new MultivariateSimpleTimeSeries(MatrixFactory.rbind(a3));
    }

    public MultivariateSimpleTimeSeries lag(int nLags) {
        return this.lag(nLags, this.size() - nLags);
    }

    public MultivariateSimpleTimeSeries diff(int d2) {
        return new MultivariateSimpleTimeSeries(DoubleUtils.diff(MatrixUtils.to2DArray(this.toMatrix()), 1, d2));
    }

    public MultivariateSimpleTimeSeries drop(int nItems) {
        return this.lag(0, this.size() - nItems);
    }

    public String toString() {
        return this.new.toString();
    }

    public MultivariateSimpleTimeSeries(IntTimeTimeSeries ts) {
        this(new DenseMatrix(ts.toArray(), ts.size(), 1));
    }

    public MultivariateSimpleTimeSeries(double[] ... values) {
        this(new DenseMatrix(values));
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 97 * a2 + (this.new != null ? this.new.hashCode() : 0);
        return a2;
    }

    @Override
    public Vector get(int t) {
        return new ImmutableVector(this.new.get(t - 1));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultivariateSimpleTimeSeries a2 = (MultivariateSimpleTimeSeries)obj;
        return this.new == a2.new || this.new != null && this.new.equals(a2.new);
    }
}

