/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.distribution.kolmogorov;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.big.BigIntegerUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class KolmogorovOneSidedDistribution
implements ProbabilityDistribution {
    private final int if;
    private final int new;

    public static double asymptoticCDF(double m2, double x) {
        return 1.0 - Math.exp(-2.0 * m2 * m2 * x * x);
    }

    public KolmogorovOneSidedDistribution(int n, int bigN) {
        this.if = n;
        this.new = bigN;
    }

    @Override
    public double cdf(double x) {
        if (this.if >= this.new) {
            return KolmogorovOneSidedDistribution.asymptoticCDF(Math.sqrt(this.if), x);
        }
        return this.final(x);
    }

    @Override
    @Deprecated
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private double final(double a2) {
        double a3 = 0.0;
        if (a2 <= 0.0) {
            a3 = 0.0;
        } else if (a2 >= 1.0) {
            a3 = 1.0;
        } else {
            KolmogorovOneSidedDistribution a4;
            int a5 = (int)Math.floor((double)a4.if * (1.0 - a2));
            for (int a6 = 0; a6 <= a5; ++a6) {
                a3 += Math.exp(Math.log(BigIntegerUtils.combination(a4.if, a6).doubleValue()) + (double)(a4.if - a6) * Math.log(1.0 - a2 - (double)a6 / (double)a4.if) + (double)(a6 - 1) * Math.log(a2 + (double)a6 / (double)a4.if));
            }
            a3 = 1.0 - a2 * a3;
        }
        return a3;
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public KolmogorovOneSidedDistribution(int n) {
        this(n, 50);
    }

    @Override
    @Deprecated
    public double density(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double mean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double quantile(double q) {
        ArgumentAssertion.assertTrue(this.if >= 50, "supported only for n < 50", new Object[0]);
        double a2 = 1.0 - q;
        double a3 = Math.log(1.0 / a2) / 2.0 / (double)this.if;
        a3 = Math.sqrt(a3);
        return a3;
    }

    static {
        Package.validate("NMDEV_STAT");
    }

    @Override
    @Deprecated
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double variance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

