/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.markovchain;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.random.rng.multivariate.MultinomialRVG;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleMC
implements RandomNumberGenerator {
    private final ImmutableMatrix false;
    private MultinomialRVG[] void;
    private int if = -1;
    private final ImmutableVector new;

    public SimpleMC(Vector PI, Matrix A2) {
        int a2 = A2.nRows();
        ArgumentAssertion.assertTrue(PI.size() == a2, "the length of PI should be the same as the number of states", new Object[0]);
        ArgumentAssertion.assertTrue(A2.nCols() == a2, "A should be a square matrix", new Object[0]);
        this.new = new ImmutableVector(PI);
        this.false = new ImmutableMatrix(A2);
        this.void = new MultinomialRVG[1 + A2.nRows()];
        this.void[0] = new MultinomialRVG(1, PI.toArray());
        for (int a3 = 1; a3 < this.void.length; ++a3) {
            this.void[a3] = new MultinomialRVG(1, A2.getRow(a3).toArray());
        }
    }

    static {
        Package.validate("NMDEV_STAT");
    }

    public static Vector getStationaryProbabilities(Matrix A2) {
        int a2 = A2.nRows();
        Matrix a3 = A2.t().minus((Matrix)A2.ONE());
        ((DenseMatrix)a3).setRow(a2, new DenseVector(a2, 1.0));
        DenseVector a4 = new DenseVector(a2, 0.0);
        a4.set(a2, 1.0);
        Vector a5 = new Inverse(a3).multiply(a4);
        return a5;
    }

    @Override
    public double nextDouble() {
        return this.nextState();
    }

    public int nStates() {
        return this.false.nRows();
    }

    public ImmutableVector PI() {
        return this.new;
    }

    public int nextState() {
        int a2;
        MultinomialRVG a3 = this.void[0];
        if (this.if != -1) {
            a3 = this.void[this.if];
        }
        this.if = a2 = SimpleMC.bin(a3);
        return a2;
    }

    public ImmutableMatrix A() {
        return this.false;
    }

    public static int bin(MultinomialRVG rvg) {
        double[] a2 = rvg.nextVector();
        int a3 = 1;
        while (a2[a3 - 1] == 0.0) {
            ++a3;
        }
        return a3;
    }

    @Override
    public void seed(long ... seeds) {
        for (int a2 = 0; a2 < this.void.length; ++a2) {
            this.void[a2].seed(seeds);
        }
    }
}

