/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.hmm.mixture.distribution;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.hmm.mixture.distribution.MixtureDistribution;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;
import dev.nm.stat.random.rng.univariate.normal.NormalRNG;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NormalMixtureDistribution
implements MixtureDistribution {
    private final boolean void;
    private final Lambda[] if;
    private final boolean new;

    public NormalMixtureDistribution(Lambda[] lambda, boolean isMuEstimated, boolean isSigmaEstimated) {
        this.if = Arrays.copyOf(lambda, lambda.length);
        this.new = isMuEstimated;
        this.void = isSigmaEstimated;
    }

    @Override
    public RandomNumberGenerator[] newRandomNumberGenerators() {
        RandomNumberGenerator[] a2 = new RandomNumberGenerator[this.if.length];
        for (int a3 = 0; a3 < this.if.length; ++a3) {
            double a4 = this.if[a3].mu;
            double a5 = this.if[a3].sigma;
            a2[a3] = new NormalRNG(a4, a5);
        }
        return a2;
    }

    public NormalMixtureDistribution(Lambda[] lambda) {
        this(lambda, true, true);
    }

    public Lambda[] getParams() {
        Lambda[] a2 = Arrays.copyOf(this.if, this.if.length);
        return a2;
    }

    public Lambda[] getMStepParams(double[] observations, Vector[] u) {
        int a2 = u.length;
        int a3 = u[0].size();
        Lambda[] a4 = new Lambda[this.if.length];
        for (int a5 = 0; a5 < a3; ++a5) {
            double a6;
            double a7;
            double a8 = this.if[a5].mu;
            if (this.new) {
                a7 = 0.0;
                a6 = 0.0;
                for (int a9 = 0; a9 < a2; ++a9) {
                    double a10 = u[a9].get(a5 + 1);
                    a7 += a10 * observations[a9];
                    a6 += a10;
                }
                a8 = a7 / a6;
            }
            a7 = this.if[a5].sigma;
            if (this.void) {
                a6 = 0.0;
                double a11 = 0.0;
                for (int a12 = 0; a12 < a2; ++a12) {
                    double a13 = u[a12].get(a5 + 1);
                    double a14 = observations[a12] - a8;
                    a6 += a13 * a14 * a14;
                    a11 += a13;
                }
                a7 = Math.sqrt(a6 / a11);
            }
            a4[a5] = new Lambda(a8, a7);
        }
        return a4;
    }

    @Override
    public MixtureDistribution newMixtureDistribution(Object[] param) {
        Lambda[] a2 = Arrays.copyOf((Lambda[])param, param.length);
        return new NormalMixtureDistribution(a2, this.new, this.void);
    }

    @Override
    public ProbabilityDistribution[] newDistributions() {
        ProbabilityDistribution[] a2 = new ProbabilityDistribution[this.if.length];
        for (int a3 = 0; a3 < this.if.length; ++a3) {
            double a4 = this.if[a3].mu;
            double a5 = this.if[a3].sigma;
            a2[a3] = new NormalDistribution(a4, a5);
        }
        return a2;
    }

    public static class Lambda {
        public final double sigma;
        public final double mu;

        public Lambda(double mu, double sigma) {
            this.mu = mu;
            this.sigma = sigma;
        }
    }
}

