/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.hmm.mixture.distribution;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.matrix.RntoMatrix;
import dev.nm.analysis.function.rn2r1.AbstractBivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.analysis.function.special.gamma.Digamma;
import dev.nm.analysis.function.special.gamma.GammaLanczosQuick;
import dev.nm.analysis.function.special.gamma.Trigamma;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.GammaDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.hmm.mixture.distribution.BetaMixtureDistribution;
import dev.nm.stat.hmm.mixture.distribution.MixtureDistribution;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;
import dev.nm.stat.random.rng.univariate.gamma.MarsagliaTsang2000;
import java.util.Arrays;
import java.util.HashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GammaMixtureDistribution
implements MixtureDistribution {
    private final double float;
    private final Trigamma short;
    private final Digamma enum = new Digamma();
    private final int false;
    private final Lambda[] void;
    private final boolean if;
    private final boolean new;

    @Override
    public ProbabilityDistribution[] newDistributions() {
        ProbabilityDistribution[] a2 = new ProbabilityDistribution[this.void.length];
        for (int a3 = 0; a3 < this.void.length; ++a3) {
            double a4 = this.void[a3].k;
            double a5 = this.void[a3].theta;
            a2[a3] = new GammaDistribution(a4, a5);
        }
        return a2;
    }

    public Lambda[] getMStepParams(double[] observations, Vector[] u) {
        double a2;
        int a3 = u.length;
        int a4 = u[0].size();
        double[] a5 = DoubleUtils.foreach(observations, new AbstractUnivariateRealFunction(){
            {
                1 a3;
            }

            @Override
            public double evaluate(double x) {
                return Math.log(x);
            }
        });
        double[] a6 = new double[a4];
        double[] a7 = new double[a4];
        for (int a8 = 0; a8 < a4; ++a8) {
            double a9 = 0.0;
            double a10 = 0.0;
            double a11 = 0.0;
            for (int a12 = 0; a12 < a3; ++a12) {
                a2 = u[a12].get(a8 + 1);
                a9 += a2 * observations[a12];
                a10 += a2 * a5[a12];
                a11 += a2;
            }
            a6[a8] = a9 / a11;
            a7[a8] = a10 / a11;
        }
        Lambda[] a13 = new Lambda[this.void.length];
        for (int a14 = 0; a14 < a4; ++a14) {
            double a15 = this.void[a14].k;
            double a16 = this.void[a14].theta;
            final double a17 = a6[a14];
            a2 = a7[a14];
            try {
                if (!this.if && this.new) {
                    double a18 = a6[a14] / a15;
                    if (a18 <= 0.0) break;
                    double a19 = a18 - a16;
                    a16 = a18;
                    if (Math.abs(a19) < this.float) {
                        break;
                    }
                } else {
                    AbstractBivariateRealFunction a20 = new AbstractBivariateRealFunction(){

                        @Override
                        public double evaluate(double k2, double theta) {
                            double a22 = new GammaLanczosQuick().evaluate(k2);
                            double a3 = k2 * Math.log(1.0 / theta) - Math.log(a22) + (k2 - 1.0) * a2 - 1.0 / theta * a17;
                            a3 = -a3;
                            return a3;
                        }
                        {
                            2 a3;
                        }
                    };
                    HashMap<Integer, Double> a21 = new HashMap<Integer, Double>();
                    if (!this.new) {
                        a21.put(2, a16);
                    }
                    BetaMixtureDistribution.Minimizer a22 = new BetaMixtureDistribution.Minimizer(this.float, this.false);
                    DenseVector a23 = new DenseVector(a15, a16);
                    Vector a24 = a22.solve(a20, a23, a21);
                    double a25 = a20.evaluate(a15, a16);
                    double a26 = (Double)a20.evaluate(a24);
                    if (a26 < a25) {
                        a15 = a24.get(1);
                        a16 = a24.get(2);
                    }
                }
            }
            catch (Exception a20) {
                // empty catch block
            }
            a13[a14] = new Lambda(a15, a16);
        }
        return a13;
    }

    @Override
    public RandomNumberGenerator[] newRandomNumberGenerators() {
        RandomNumberGenerator[] a2 = new RandomNumberGenerator[this.void.length];
        for (int a3 = 0; a3 < this.void.length; ++a3) {
            double a4 = this.void[a3].k;
            double a5 = this.void[a3].theta;
            a2[a3] = new MarsagliaTsang2000(a4, a5);
        }
        return a2;
    }

    @Override
    public MixtureDistribution newMixtureDistribution(Object[] param) {
        Lambda[] a2 = Arrays.copyOf((Lambda[])param, param.length);
        return new GammaMixtureDistribution(a2, this.if, this.new, this.float, this.false);
    }

    private RealVectorFunction final(final double a2, final double a3) {
        GammaMixtureDistribution a4;
        return new RealVectorFunction(){

            @Override
            public int dimensionOfDomain() {
                return 2;
            }
            {
                3 a32;
            }

            @Override
            public Vector evaluate(Vector x) {
                double a22 = x.get(1);
                double a32 = x.get(2);
                DenseVector a4 = new DenseVector(2);
                double a5 = GammaMixtureDistribution.this.enum.evaluate(a32);
                a4.set(1, a32 * a22 - a2);
                a4.set(2, Math.log(1.0 / a22) - a5 + a3);
                return a4;
            }

            @Override
            public int dimensionOfRange() {
                return 2;
            }
        };
    }

    public GammaMixtureDistribution(Lambda[] lambda, int maxIterations) {
        this(lambda, true, true, 1.0E-5, maxIterations);
    }

    public Lambda[] getParams() {
        Lambda[] a2 = Arrays.copyOf(this.void, this.void.length);
        return a2;
    }

    public GammaMixtureDistribution(Lambda[] lambda, boolean isShapeEstimated, boolean isScaleEstimated, double epsilon, int maxIterations) {
        this.short = new Trigamma();
        this.void = Arrays.copyOf(lambda, lambda.length);
        this.if = isShapeEstimated;
        this.new = isScaleEstimated;
        this.float = epsilon;
        this.false = maxIterations;
    }

    private RntoMatrix final() {
        GammaMixtureDistribution a2;
        return new RntoMatrix(){

            @Override
            public Matrix evaluate(Vector x) {
                double a2 = x.get(1);
                double a3 = x.get(2);
                DenseMatrix a4 = new DenseMatrix(2, 2);
                double a5 = GammaMixtureDistribution.this.short.evaluate(a3);
                a4.set(1, 1, -a3 * a2 * a2);
                a4.set(1, 2, a2);
                a4.set(2, 1, a2);
                a4.set(2, 2, -a5);
                return a4;
            }
            {
                4 a3;
            }

            @Override
            public int dimensionOfRange() {
                return 1;
            }

            @Override
            public int dimensionOfDomain() {
                return 2;
            }
        };
    }

    public static class Lambda {
        public final double theta;
        public final double k;

        public Lambda(double k2, double theta) {
            this.k = k2;
            this.theta = theta;
        }
    }
}

