/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.factor.pca;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.SVD;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.factor.pca.PCAImpl;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PCAbySVD
extends PCAImpl {
    private final ImmutableVector void;
    private final ImmutableVector if;
    private SVD new = null;

    public PCAbySVD(Matrix data) {
        this(data, true, true);
    }

    @Override
    public Matrix loadings() {
        return this.svd().V();
    }

    public PCAbySVD(Matrix data, boolean centered, boolean scaled) {
        super(data);
        Vector a2 = centered ? super.mean() : new DenseVector(DoubleUtils.rep(0.0, this.nFactors()));
        this.if = new ImmutableVector(a2);
        Vector a3 = scaled ? super.scale() : new DenseVector(DoubleUtils.rep(1.0, this.nFactors()));
        this.void = new ImmutableVector(a3);
    }

    @Override
    public Vector scale() {
        return this.void;
    }

    public SVD svd() {
        if (this.new == null) {
            Matrix a2 = this.X();
            this.new = new SVD(a2, true, PrecisionUtils.autoEpsilon(a2), SVD.Method.GOLUB_KAHAN);
        }
        return this.new;
    }

    public PCAbySVD(Matrix data, Vector mean, Vector scale) {
        super(data);
        this.if = new ImmutableVector(mean);
        this.void = new ImmutableVector(scale);
    }

    @Override
    public Vector mean() {
        return this.if;
    }

    @Override
    public DenseVector sdPrincipalComponents() {
        double[] a2 = this.svd().getSingularValues();
        int a3 = a2.length;
        double a4 = Math.sqrt(Math.max(1, this.nObs() - 1));
        double[] a5 = new double[a3];
        for (int a6 = 0; a6 < a3; ++a6) {
            a5[a6] = a2[a6] / a4;
        }
        return new DenseVector(a5);
    }
}

