/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.univariate.fitting.acer.empirical;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.descriptive.moment.Variance;
import dev.nm.stat.descriptive.moment.weighted.WeightedVariance;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.distribution.univariate.TDistribution;
import dev.nm.stat.evt.evd.univariate.fitting.acer.empirical.ACERUtils;
import dev.nm.stat.evt.evd.univariate.fitting.acer.empirical.EmpiricalACERStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EpsilonStatisticsCalculator {
    private final boolean void;
    private final double if;
    private static final UnivariateRealFunction new = new AbstractUnivariateRealFunction(){
        {
            1 a2;
        }

        @Override
        public double evaluate(double x) {
            return Math.sqrt(x);
        }
    };

    public EpsilonStatisticsCalculator(boolean isWeightedByPeakCount, double confidenceLevel) {
        ArgumentAssertion.assertRangeOpen(confidenceLevel, 0.0, 1.0, "confidence level");
        this.void = isWeightedByPeakCount;
        this.if = confidenceLevel;
    }

    private EmpiricalACERStatistics final(int a2, int a3, Matrix a4) {
        EpsilonStatisticsCalculator a5;
        Vector a6 = a4.getColumn(1);
        NormalDistribution a7 = new NormalDistribution();
        double a8 = a7.quantile((1.0 + a5.if) / 2.0);
        double a9 = Math.sqrt(a2 - a3 + 1);
        Vector a10 = VectorFactory.foreach(a6, new).scaled(a8 / a9);
        return new EmpiricalACERStatistics(a6.toArray(), a10.toArray());
    }

    private EmpiricalACERStatistics final(Matrix a2) {
        EpsilonStatisticsCalculator a3;
        int a4 = a2.nCols();
        Vector a5 = a2.multiply(new DenseVector(a4, 1.0 / (double)a4));
        Vector a6 = VectorFactory.foreachRow(a2, new AbstractRealScalarFunction(a4){

            @Override
            public Double evaluate(Vector x) {
                return new Variance(x.toArray()).standardDeviation();
            }
            {
                3 a4;
                super(a3);
            }
        });
        Vector a7 = a3.final(a6, a4);
        return new EmpiricalACERStatistics(a5.toArray(), a7.toArray());
    }

    private Vector final(Vector a2, int a3) {
        EpsilonStatisticsCalculator a4;
        TDistribution a5 = new TDistribution(a3 - 1);
        double a6 = a5.quantile((1.0 + a4.if) / 2.0);
        double a7 = Math.sqrt(a3);
        return a2.scaled(a6 / a7);
    }

    public EmpiricalACERStatistics compute(double[][] observations, double[][] acers, int kStepMemory) {
        DenseMatrix a2 = new DenseMatrix(acers).t();
        if (a2.nCols() > 1) {
            if (this.void) {
                double[] a3 = ACERUtils.computeWeightsByPeriodLength(observations);
                return this.final(a2, a3);
            }
            return this.final(a2);
        }
        return this.final(observations[0].length, kStepMemory, a2);
    }

    private EmpiricalACERStatistics final(Matrix a2, final double[] a3) {
        EpsilonStatisticsCalculator a4;
        Vector a5 = a2.multiply(new DenseVector(a3));
        int a6 = a2.nCols();
        Vector a7 = VectorFactory.foreachRow(a2, new AbstractRealScalarFunction(a6){
            {
                2 a4;
                super(a32);
            }

            @Override
            public Double evaluate(Vector x) {
                return new WeightedVariance(x.toArray(), a3).stdev();
            }
        });
        Vector a8 = a4.final(a7, a6);
        return new EmpiricalACERStatistics(a5.toArray(), a8.toArray());
    }
}

