/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.univariate;

import dev.nm.analysis.function.special.beta.BetaRegularized;
import dev.nm.analysis.function.special.beta.BetaRegularizedInverse;
import dev.nm.analysis.function.special.beta.LogBeta;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.evt.evd.univariate.UnivariateEVD;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OrderStatisticsDistribution
implements UnivariateEVD {
    private final ProbabilityDistribution void;
    private final int if;
    private final int new;

    @Override
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double mean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double quantile(double x) {
        BetaRegularizedInverse a2 = new BetaRegularizedInverse(this.if, this.new - this.if + 1);
        return this.void.quantile(a2.evaluate(x));
    }

    @Override
    public double logDensity(double x) {
        double a2 = Math.log(this.void.density(x));
        if (Double.isInfinite(a2)) {
            return Double.NEGATIVE_INFINITY;
        }
        double a3 = this.void.cdf(x);
        double a4 = (double)(this.if - 1) * Math.log(a3) + (double)(this.new - this.if) * Math.log(1.0 - a3);
        double a5 = new LogBeta().evaluate(this.if, this.new - this.if + 1);
        double a6 = a2 + a4 - a5;
        return a6;
    }

    static {
        Package.validate("NMDEV_EVT");
    }

    @Override
    public double variance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double cdf(double x) {
        double a2 = this.void.cdf(x);
        BetaRegularized a3 = new BetaRegularized(this.if, this.new - this.if + 1);
        return a3.evaluate(a2);
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    public OrderStatisticsDistribution(ProbabilityDistribution dist, int nIIDs, int order) {
        ArgumentAssertion.assertPositive(nIIDs, "number of independent variables");
        ArgumentAssertion.assertPositive(order, "order");
        ArgumentAssertion.assertTrue(order <= nIIDs, "order (%d) cannot be greater than nIIDs (%d)", order, nIIDs);
        this.void = dist;
        this.new = nIIDs;
        this.if = order;
    }
}

