/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.multivariate;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.special.gamma.Gamma;
import dev.nm.analysis.function.special.gamma.GammaLanczosQuick;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.distribution.multivariate.MultivariateProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateTDistribution
implements MultivariateProbabilityDistribution {
    private final Gamma short = new GammaLanczosQuick();
    private final Matrix enum;
    private final ImmutableVector false;
    private final ImmutableMatrix void;
    private final double if;
    private final double new;

    public MultivariateTDistribution(int v, Vector mu, Matrix Sigma) {
        ArgumentAssertion.assertTrue(mu.size() == Sigma.nCols() && Sigma.nCols() == Sigma.nRows(), "the size of the mean vector must match the size of the covariance matrix", new Object[0]);
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(Sigma, 0.0), "the covariance matrix must be symmetric", new Object[0]);
        this.if = v;
        this.false = new ImmutableVector(mu);
        this.void = new ImmutableMatrix(Sigma);
        this.enum = new Inverse(Sigma);
        this.new = this.final();
    }

    public MultivariateTDistribution(int dim, int v) {
        this(v, new DenseVector(dim), new DenseMatrix(dim, dim).ONE().scaled((double)(v - 2) / (double)v));
    }

    @Override
    public double density(Vector x) {
        double a2 = this.false.size();
        Vector a3 = x.minus(this.false);
        double a4 = a3.innerProduct(this.enum.multiply(a3));
        double a5 = Math.pow(a4 / this.if + 1.0, (this.if + a2) / 2.0);
        double a6 = this.new / a5;
        return a6;
    }

    @Override
    public Matrix covariance() {
        if (this.if <= 2.0) {
            throw new RuntimeException("covariance undefined when v <= 2");
        }
        DenseMatrix a2 = new DenseMatrix(this.void);
        double a3 = this.if / (this.if - 2.0);
        a2.scaled(a3);
        return a2;
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("not yet supported");
    }

    private double final() {
        MultivariateTDistribution a2;
        double a3 = a2.false.size();
        double a4 = MatrixMeasure.det(a2.void);
        double a5 = a2.short.evaluate((a2.if + a3) / 2.0);
        double a6 = a2.short.evaluate(a2.if / 2.0);
        double a7 = Math.pow(a2.if * Math.PI, a3 / 2.0);
        double a8 = Math.sqrt(a4);
        double a9 = a5 / a6 / a7 / a8;
        return a9;
    }

    @Override
    public Vector mean() {
        if (this.if <= 1.0) {
            throw new RuntimeException("mean undefined when v <= 1");
        }
        return this.false;
    }

    @Override
    public double moment(Vector t) {
        throw new UnsupportedOperationException("not yet supported");
    }

    @Override
    public Vector mode() {
        return this.false;
    }

    @Override
    public double cdf(Vector x) {
        throw new UnsupportedOperationException("not yet supported");
    }
}

