/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.unconstrained.annealing;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.misc.algorithm.stopcondition.StopCondition;
import dev.nm.solver.IterativeSolution;
import dev.nm.solver.multivariate.unconstrained.IterativeMinimizer;
import dev.nm.solver.multivariate.unconstrained.annealing.acceptanceprobabilityfunction.MetropolisAcceptanceProbabilityFunction;
import dev.nm.solver.multivariate.unconstrained.annealing.acceptanceprobabilityfunction.TemperedAcceptanceProbabilityFunction;
import dev.nm.solver.multivariate.unconstrained.annealing.annealingfunction.AnnealingFunction;
import dev.nm.solver.multivariate.unconstrained.annealing.annealingfunction.BoltzAnnealingFunction;
import dev.nm.solver.multivariate.unconstrained.annealing.temperaturefunction.BoltzTemperatureFunction;
import dev.nm.solver.multivariate.unconstrained.annealing.temperaturefunction.TemperatureFunction;
import dev.nm.solver.problem.OptimProblem;
import dev.nm.stat.random.rng.univariate.BernoulliTrial;
import dev.nm.stat.random.rng.univariate.RandomLongGenerator;
import dev.nm.stat.random.rng.univariate.normal.Zignor2005;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimulatedAnnealingMinimizer
implements IterativeMinimizer<OptimProblem> {
    private final TemperatureFunction short;
    private final StopCondition enum;
    private final RandomLongGenerator false;
    private final int void;
    private final AnnealingFunction if;
    private final TemperedAcceptanceProbabilityFunction new;

    public SimulatedAnnealingMinimizer(int dim, double initialTemperature, StopCondition stopCondition, RandomLongGenerator uniform) {
        this(new BoltzTemperatureFunction(initialTemperature), new BoltzAnnealingFunction(dim, new Zignor2005(uniform)), new MetropolisAcceptanceProbabilityFunction(), dim, stopCondition, uniform);
    }

    @Override
    public IterativeSolution<Vector> solve(final OptimProblem problem) throws Exception {
        final RealScalarFunction a2 = problem.f();
        return new IterativeSolution<Vector>(){
            double bestEnergy;
            double currentEnergy;
            private int if = 0;
            Vector currentState;
            private Vector new = null;
            Vector bestState;

            @Override
            public double minimum() {
                double a22 = (Double)problem.f().evaluate(this.minimizer());
                return a22;
            }

            public void setInitials(Vector ... initials) {
                this.currentState = initials[0];
                this.currentEnergy = (Double)a2.evaluate(this.currentState);
                this.bestState = this.currentState;
                this.bestEnergy = this.currentEnergy;
            }

            @Override
            public Vector minimizer() {
                if (this.new == null) {
                    try {
                        this.search(this.currentState);
                    }
                    catch (Exception a22) {
                        this.new = null;
                    }
                }
                return this.new;
            }
            {
                1 a3;
            }

            public Vector search(Vector ... initials) throws Exception {
                this.setInitials(initials);
                this.if = 0;
                while (!SimulatedAnnealingMinimizer.this.enum.isStopped(this.bestState, this.bestEnergy)) {
                    this.step();
                    ++this.if;
                }
                this.new = this.bestState;
                return this.new;
            }

            @Override
            public Object step() throws Exception {
                double a22 = SimulatedAnnealingMinimizer.this.short.visitingTemperature(this.if);
                double a3 = SimulatedAnnealingMinimizer.this.short.acceptanceTemperature(this.if);
                for (int a4 = 0; a4 < SimulatedAnnealingMinimizer.this.void; ++a4) {
                    Vector a5 = SimulatedAnnealingMinimizer.this.if.nextProposal(this.currentState, a22);
                    double a6 = (Double)a2.evaluate(a5);
                    double a7 = SimulatedAnnealingMinimizer.this.new.acceptanceProbability(this.currentState, this.currentEnergy, a5, a6, a3);
                    if (!BernoulliTrial.nextTrial(SimulatedAnnealingMinimizer.this.false, a7)) continue;
                    this.currentState = a5;
                    this.currentEnergy = a6;
                    if (!(this.currentEnergy < this.bestEnergy)) continue;
                    this.bestState = this.currentState;
                    this.bestEnergy = this.currentEnergy;
                }
                return this.bestState;
            }
        };
    }

    public SimulatedAnnealingMinimizer(TemperatureFunction temperatureFunction, AnnealingFunction annealingFunction, TemperedAcceptanceProbabilityFunction probabilityFunction, int markovLength, StopCondition stopCondition, RandomLongGenerator uniform) {
        this.short = temperatureFunction;
        this.if = annealingFunction;
        this.new = probabilityFunction;
        this.void = markovLength;
        this.enum = stopCondition;
        this.false = uniform;
    }
}

