/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.geneticalgorithm.minimizer.simplegrid;

import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.misc.Constants;
import dev.nm.solver.IterativeSolution;
import dev.nm.solver.multivariate.geneticalgorithm.Chromosome;
import dev.nm.solver.multivariate.geneticalgorithm.GeneticAlgorithm;
import dev.nm.solver.multivariate.geneticalgorithm.minimizer.simplegrid.SimpleCellFactory;
import dev.nm.solver.multivariate.geneticalgorithm.minimizer.simplegrid.firstgeneration.UniformMeshOverRegion;
import dev.nm.solver.multivariate.unconstrained.IterativeMinimizer;
import dev.nm.solver.problem.OptimProblem;
import dev.nm.stat.random.rng.univariate.RandomLongGenerator;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;
import java.util.List;

public class SimpleGridMinimizer
implements IterativeMinimizer<OptimProblem> {
    protected final int nStableIterations;
    public static final int DEFAULT_STABLE_ITERATION_COUNT = 10;
    protected final double epsilon;
    protected final RandomLongGenerator uniform;
    protected final int maxIterations;
    protected final NewCellFactoryCtor factoryCtor;

    public SimpleGridMinimizer(final RandomLongGenerator uniform, double epsilon, int maxIterations) {
        this(new NewCellFactoryCtor(){
            {
                1 a2;
            }

            @Override
            public SimpleCellFactory newCellFactory() {
                return new SimpleCellFactory(0.1, uniform);
            }
        }, uniform, epsilon, maxIterations, 10);
    }

    public SimpleGridMinimizer(double epsilon, int maxIterations) {
        this(new UniformRNG(1234567890L), epsilon, maxIterations);
    }

    @Override
    public IterativeSolution<Vector> solve(OptimProblem problem) throws Exception {
        return new Solution(problem.f());
    }

    public SimpleGridMinimizer(NewCellFactoryCtor factoryCtor, RandomLongGenerator uniform, double epsilon, int maxIterations, int nStableIterations) {
        this.factoryCtor = factoryCtor;
        this.uniform = uniform;
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
        this.nStableIterations = nStableIterations;
    }

    protected class Solution
    extends GeneticAlgorithm
    implements IterativeSolution<Vector> {
        protected final RealScalarFunction f;
        protected Vector xmin;
        protected int iteration;
        protected double fmin;
        protected Vector[] initials;
        protected double fminLast;
        protected int nNoChanges;
        protected final SimpleCellFactory factory;

        @Override
        protected List<? extends Chromosome> getFirstGeneration() {
            UniformMeshOverRegion a2 = new UniformMeshOverRegion(this.f, this.factory, SimpleGridMinimizer.this.uniform, 2, this.initials, SimpleGridMinimizer.this.epsilon);
            return a2.getFirstGeneration();
        }

        @Override
        protected boolean isConverged() {
            double a2 = this.minimum();
            double a3 = Math.abs(a2 - this.fminLast);
            if (a2 < this.fminLast) {
                this.fminLast = a2;
            }
            this.nNoChanges = a3 < SimpleGridMinimizer.this.epsilon * Math.abs(a2) + Constants.EPSILON ? ++this.nNoChanges : 0;
            if (this.nNoChanges > SimpleGridMinimizer.this.nStableIterations) {
                return true;
            }
            return this.iteration >= SimpleGridMinimizer.this.maxIterations;
        }

        @Override
        public ImmutableVector minimizer() {
            return new ImmutableVector(this.xmin);
        }

        protected Solution(RealScalarFunction f2) {
            super(SimpleGridMinimizer.this.uniform);
            this.iteration = 0;
            this.nNoChanges = 0;
            this.fminLast = Double.POSITIVE_INFINITY;
            this.fmin = Double.POSITIVE_INFINITY;
            this.f = f2;
            this.factory = SimpleGridMinimizer.this.factoryCtor.newCellFactory();
        }

        @Override
        public Object step() {
            ++this.iteration;
            super.step();
            SimpleCellFactory.SimpleCell a2 = (SimpleCellFactory.SimpleCell)this.getBest(0);
            this.xmin = a2.x();
            this.fmin = this.getBest(0).fitness();
            return true;
        }

        @Override
        public double minimum() {
            return this.fmin;
        }

        public Vector search(Vector ... initials) {
            this.setInitials(initials);
            super.run();
            return this.minimizer();
        }

        public void setInitials(Vector ... initials) {
            this.initials = initials;
        }
    }

    public static interface NewCellFactoryCtor {
        public SimpleCellFactory newCellFactory();
    }
}

