/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.number.big;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import java.math.BigInteger;

public final class BigIntegerUtils {
    static {
        Package.validate("NMDEV_BASIC");
    }

    public static BigInteger combination(int n, int k2) {
        ArgumentAssertion.assertTrue(k2 >= 0, "n, k must be 0s or natural numbers", new Object[0]);
        ArgumentAssertion.assertTrue(n >= k2, "n >= k", new Object[0]);
        if (n == 0 || k2 == 0 || k2 == n) {
            return BigInteger.valueOf(1L);
        }
        if ((double)k2 > (double)n / 2.0) {
            k2 = n - k2;
        }
        BigInteger a2 = BigIntegerUtils.permutation(n, k2);
        BigInteger a3 = BigIntegerUtils.factorial(k2);
        a2 = a2.divide(a3);
        return a2;
    }

    private BigIntegerUtils() {
        BigIntegerUtils a2;
    }

    public static BigInteger factorial(int n) {
        ArgumentAssertion.assertTrue(n >= 0, "n must be 0 or a natural number", new Object[0]);
        BigInteger a2 = BigInteger.valueOf(1L);
        for (int a3 = 2; a3 <= n; ++a3) {
            a2 = a2.multiply(BigInteger.valueOf(a3));
        }
        return a2;
    }

    public static BigInteger permutation(int n, int k2) {
        ArgumentAssertion.assertTrue(k2 >= 0, "n, k must be 0s or natural numbers", new Object[0]);
        ArgumentAssertion.assertTrue(n >= k2, "n >= k", new Object[0]);
        if (n == 0 || k2 == 0 || k2 == n) {
            return BigInteger.valueOf(1L);
        }
        BigInteger a2 = BigInteger.valueOf(1L);
        for (int a3 = n; a3 > n - k2; --a3) {
            a2 = a2.multiply(BigInteger.valueOf(a3));
        }
        return a2;
    }
}

