/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.misc;

import java.text.DecimalFormat;

public final class ArgumentAssertion {
    private static final String new = "#.##";

    public static <T extends Number> void assertEqual(T x1, T x2, String variableName1, String variableName2) {
        if (((Comparable)((Object)x1)).compareTo(x2) != 0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' and '%s' must be equal: %s, %s", variableName1, variableName2, a2.format(x1), a2.format(x2)));
        }
    }

    public static <T extends Number> void assertLessThan(T x, T bound, String variableName) {
        if (((Comparable)((Object)x)).compareTo(bound) >= 0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must be less than %s: %s", variableName, a2.format(bound), a2.format(x)));
        }
    }

    public static void assertFalse(boolean condition, String errorMessage, Object ... args) {
        if (condition) {
            throw new IllegalArgumentException(String.format(errorMessage, args));
        }
    }

    public static <T extends Number> void assertPositive(T x, String variableName) {
        if (x.doubleValue() <= 0.0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must be positive : %s", variableName, a2.format(x)));
        }
    }

    public static void assertNotNaN(float f2, String variableName) {
        if (Float.isNaN(f2)) {
            throw new IllegalArgumentException(String.format("'%s' must not be NaN", variableName));
        }
    }

    public static void assertNotNaN(double d2, String variableName) {
        if (Double.isNaN(d2)) {
            throw new IllegalArgumentException(String.format("'%s' must not be NaN", variableName));
        }
    }

    public static void assertTrue(boolean condition, String errorMessage, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(errorMessage, args));
        }
    }

    public static <T extends Number> void assertRangeLeftOpen(T x, T low, T high, String variableName) {
        if (((Comparable)((Object)x)).compareTo(low) < 0 || ((Comparable)((Object)x)).compareTo(high) > 0 || ((Comparable)((Object)x)).compareTo(low) == 0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must be in range (%s %s]: %s", variableName, a2.format(low), a2.format(high), a2.format(x)));
        }
    }

    public static <T extends Number> void assertNotGreaterThan(T x, T bound, String variableName) {
        if (((Comparable)((Object)x)).compareTo(bound) > 0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must not be greater than %s: %s", variableName, a2.format(bound), a2.format(x)));
        }
    }

    public static <T extends Number> void assertEqual(T x, T bound, String variableName) {
        if (((Comparable)((Object)x)).compareTo(bound) != 0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must be equal to %s: %s", variableName, a2.format(bound), a2.format(x)));
        }
    }

    public static void assertNull(Object obj, String variableName) {
        ArgumentAssertion.assertTrue(obj == null, "'%s' must be null", variableName);
    }

    private ArgumentAssertion() {
        ArgumentAssertion a2;
    }

    public static <T extends Number> void assertRangeOpen(T x, T low, T high, String variableName) {
        if (((Comparable)((Object)x)).compareTo(low) < 0 || ((Comparable)((Object)x)).compareTo(high) > 0 || ((Comparable)((Object)x)).compareTo(high) == 0 || ((Comparable)((Object)x)).compareTo(low) == 0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must be in range (%s %s): %s", variableName, a2.format(low), a2.format(high), a2.format(x)));
        }
    }

    public static <T extends Number> void assertNotLessThan(T x, T bound, String variableName) {
        if (((Comparable)((Object)x)).compareTo(bound) < 0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must not be less than %s: %s", variableName, a2.format(bound), a2.format(x)));
        }
    }

    public static <T extends Number> void assertNonPositive(T x, String variableName) {
        if (x.doubleValue() > 0.0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must be non-positive : %s", variableName, a2.format(x)));
        }
    }

    public static <T extends Number> void assertNonNegative(T x, String variableName) {
        if (x.doubleValue() < 0.0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must be non-negative : %s", variableName, a2.format(x)));
        }
    }

    public static <T extends Number> void assertGreaterThan(T x, T bound, String variableName) {
        if (((Comparable)((Object)x)).compareTo(bound) <= 0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must be greater than %s: %s", variableName, a2.format(bound), a2.format(x)));
        }
    }

    public static void assertNotInfinity(float f2, String variableName) {
        if (Float.isInfinite(f2)) {
            throw new IllegalArgumentException(String.format("'%s' must not be infinite", variableName));
        }
    }

    public static <T extends Number> void assertRangeRightOpen(T x, T low, T high, String variableName) {
        if (((Comparable)((Object)x)).compareTo(low) < 0 || ((Comparable)((Object)x)).compareTo(high) > 0 || ((Comparable)((Object)x)).compareTo(high) == 0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must be in range [%s %s): %s", variableName, a2.format(low), a2.format(high), a2.format(x)));
        }
    }

    public static <T extends Number> void assertRange(T x, T low, T high, String variableName) {
        if (((Comparable)((Object)x)).compareTo(low) < 0 || ((Comparable)((Object)x)).compareTo(high) > 0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' must be in range [%s %s]: %s", variableName, a2.format(low), a2.format(high), a2.format(x)));
        }
    }

    public static void assertNotInfinity(double d2, String variableName) {
        if (Double.isInfinite(d2)) {
            throw new IllegalArgumentException(String.format("'%s' must not be infinite", variableName));
        }
    }

    public static void assertNormalFloat(float f2, String variableName) {
        if (Float.isNaN(f2) || Float.isInfinite(f2)) {
            throw new IllegalArgumentException(String.format("'%s' must be a normal value: %f", variableName, Float.valueOf(f2)));
        }
    }

    public static <T extends Number> void assertNegative(T x, String variableName) {
        if (x.doubleValue() >= 0.0) {
            DecimalFormat a2 = new DecimalFormat(new);
            throw new IllegalArgumentException(String.format("'%s' is not negative : %s", variableName, a2.format(x)));
        }
    }

    public static void assertNormalDouble(double d2, String variableName) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(String.format("'%s' must be a normal value: %f", variableName, d2));
        }
    }

    public static void assertNotNull(Object obj, String variableName) {
        ArgumentAssertion.assertTrue(obj != null, "'%s' must not be null", variableName);
    }
}

