/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.interval;

import dev.nm.interval.IntervalRelation;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import java.util.EnumSet;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Interval<T extends Comparable<? super T>> {
    private final T if;
    private final T new;

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        a2.append("[");
        a2.append(this.new.toString());
        a2.append(", ");
        a2.append(this.if.toString());
        a2.append("]");
        return a2.toString();
    }

    public boolean is(IntervalRelation relation, Interval<T> Y) {
        return relation.isBetween(this, Y);
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 19 * a2 + (this.new != null ? this.new.hashCode() : 0);
        a2 = 19 * a2 + (this.if != null ? this.if.hashCode() : 0);
        return a2;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public T end() {
        return this.if;
    }

    public Set<IntervalRelation> relations(Interval<T> Y) {
        EnumSet<IntervalRelation> a2 = EnumSet.noneOf(IntervalRelation.class);
        for (IntervalRelation a3 : EnumSet.allOf(IntervalRelation.class)) {
            if (!this.is(a3, Y)) continue;
            a2.add(a3);
        }
        return a2;
    }

    public Interval(T begin, T end) {
        ArgumentAssertion.assertTrue(begin.compareTo(end) <= 0, "begin (%s) must start before end (%s)", begin, end);
        this.new = begin;
        this.if = end;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval a2 = (Interval)obj;
        if (!this.new.getClass().isInstance(a2.new)) {
            return false;
        }
        if (this.new != a2.new && (this.new == null || this.new.compareTo(a2.new) != 0)) {
            return false;
        }
        return this.if == a2.if || this.if != null && this.if.compareTo(a2.if) == 0;
    }

    public T begin() {
        return this.new;
    }
}

