/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.graph.type;

import dev.nm.graph.Arc;
import dev.nm.graph.DiGraph;
import dev.nm.graph.type.SparseGraph;
import dev.nm.misc.datastructure.IdentityHashSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class SparseDiGraph<V, E extends Arc<V>>
extends SparseGraph<V, E>
implements DiGraph<V, E> {
    @Override
    public Set<E> incomingArcs(V v) {
        Set a2 = super.edges(v);
        Iterator a3 = a2.iterator();
        while (a3.hasNext()) {
            Arc a4 = (Arc)a3.next();
            if (a4.tail().equals(v)) continue;
            a3.remove();
        }
        return a2;
    }

    @Override
    public Set<E> outgoingArcs(V v) {
        Set a2 = super.edges(v);
        Iterator a3 = a2.iterator();
        while (a3.hasNext()) {
            Arc a4 = (Arc)a3.next();
            if (a4.head().equals(v)) continue;
            a3.remove();
        }
        return a2;
    }

    public SparseDiGraph() {
    }

    @Override
    public Set<V> parents(V v) {
        IdentityHashSet a2 = new IdentityHashSet();
        Set<E> a3 = this.incomingArcs(v);
        for (Arc a4 : a3) {
            Object a5 = a4.head();
            a2.add(a5);
        }
        return a2;
    }

    @Override
    public SortedSet<V> vertices() {
        TreeSet a2 = new TreeSet(new Comparator<V>(){
            {
                1 a3;
            }

            @Override
            public int compare(V v1, V v2) {
                int a2;
                int a3 = SparseDiGraph.this.incomingArcs(v1).size();
                int a4 = Double.compare(a3, a2 = SparseDiGraph.this.incomingArcs(v2).size());
                if (a4 != 0) {
                    return a4;
                }
                return new Integer(System.identityHashCode(v1)).compareTo(System.identityHashCode(v2));
            }
        });
        a2.addAll(super.vertices());
        return a2;
    }

    @Override
    public String toString() {
        StringBuilder a2 = new StringBuilder();
        for (Object a3 : this.vertices()) {
            Set<E> a4 = this.outgoingArcs(a3);
            if (a4.isEmpty()) continue;
            a2.append(a3.toString()).append(": ");
            for (Arc a5 : a4) {
                a2.append(a5.toString()).append(",");
            }
            a2.append("; ");
        }
        return a2.toString();
    }

    @Override
    public Set<V> children(V v) {
        IdentityHashSet a2 = new IdentityHashSet();
        Set<E> a3 = this.outgoingArcs(v);
        for (Arc a4 : a3) {
            Object a5 = a4.tail();
            a2.add(a5);
        }
        return a2;
    }

    public SparseDiGraph(DiGraph<V, E> g2) {
        super(g2);
    }
}

