/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.integration.univariate.riemann.newtoncotes;

import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.integration.univariate.riemann.IterativeIntegrator;
import dev.nm.analysis.integration.univariate.riemann.newtoncotes.Trapezoidal;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Simpson
implements IterativeIntegrator {
    private final Trapezoidal enum;
    private final double false;
    private final int void;
    private double if;
    private double new;

    public Simpson(double precision, int maxIterations) {
        this.enum = new Trapezoidal(precision, maxIterations);
        this.void = maxIterations;
        this.false = precision;
    }

    @Override
    public double integrate(UnivariateRealFunction f2, double a2, double b2) {
        double a3 = Double.NaN;
        double a4 = Double.NaN;
        for (int a5 = 1; a5 <= this.void; ++a5) {
            a3 = a4;
            a4 = this.next(a5, f2, a2, b2, a3);
            if (a5 > 3 && DoubleUtils.relativeError(a4, a3) < this.false) break;
        }
        return a4;
    }

    @Override
    public double h() {
        return this.enum.h();
    }

    @Override
    public double next(int iteration, UnivariateRealFunction f2, double a2, double b2, double sum) {
        if (iteration == 1) {
            this.new = this.enum.next(1, f2, a2, b2, sum);
            this.if = this.enum.next(2, f2, a2, b2, this.new);
        } else {
            this.new = this.if;
            this.if = this.enum.next(iteration + 1, f2, a2, b2, this.new);
        }
        double a3 = (4.0 * this.if - this.new) / 3.0;
        return a3;
    }

    @Override
    public int getMaxIterations() {
        return this.void;
    }

    @Override
    public double getPrecision() {
        return this.false;
    }
}

