/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.integration.univariate.riemann.newtoncotes;

import dev.nm.analysis.curvefit.interpolation.NevilleTable;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.function.tuple.PartialFunction;
import dev.nm.analysis.integration.univariate.riemann.Integrator;
import dev.nm.analysis.integration.univariate.riemann.IterativeIntegrator;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Romberg
implements Integrator {
    private final NevilleTable if;
    private IterativeIntegrator new;

    @Override
    public double getPrecision() {
        return this.new.getPrecision();
    }

    private double final() {
        Romberg a2;
        int a3 = a2.if.N();
        double a4 = Double.NaN;
        if (a3 >= 2) {
            a4 = a2.if.get(0, a3 - 2);
        }
        return a4;
    }

    @Override
    public double integrate(UnivariateRealFunction f2, double a2, double b2) {
        double a3 = 0.0;
        double a4 = 0.0;
        double a5 = 0.0;
        for (int a6 = 1; a6 <= this.new.getMaxIterations(); ++a6) {
            a3 = this.new.next(a6, f2, a2, b2, a3);
            double a7 = this.new.h();
            a5 = this.final(a7, a3);
            a4 = this.final();
            if (a6 > 3 && DoubleUtils.relativeError(a5, a4) < this.getPrecision()) break;
        }
        return a5;
    }

    private double final(double a2, double a3) {
        Romberg a4;
        a4.if.addData(new PartialFunction(new double[]{a2}, new double[]{a3}));
        double a5 = Double.NaN;
        if (a4.if.N() >= 2) {
            a5 = a4.if.evaluate(0.0);
        }
        return a5;
    }

    public Romberg(IterativeIntegrator integrator) {
        ArgumentAssertion.assertNotLessThan(integrator.getMaxIterations(), 2, "the number of iterations");
        this.new = integrator;
        this.if = new NevilleTable();
    }
}

