/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.special.gamma;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.number.DoubleUtils;

public class Trigamma
extends AbstractUnivariateRealFunction {
    private static final double if = 1.0E-4;
    private static final double new = 30.0;

    @Override
    public double evaluate(double x) {
        double a2 = 0.0;
        if (Double.isNaN(x)) {
            throw new RuntimeException("x = NaN");
        }
        if (DoubleUtils.isZero(x, 0.0)) {
            a2 = Double.POSITIVE_INFINITY;
        } else if (DoubleUtils.isNegative(x, 0.0)) {
            double a3 = Math.PI / Math.sin(Math.PI * x);
            a2 = a3 * a3 - this.evaluate(1.0 - x);
        } else if (DoubleUtils.isPositive(x, 0.0) && x < 1.0E-4) {
            a2 = 1.0 / x / x + 1.6449340668482264 + -2.4041138063191885 * x;
        } else if (x >= 30.0) {
            double a4 = 1.0 / x / x;
            a2 = 0.5 * a4 + (1.0 + a4 * (0.16666666666666666 + a4 * (-0.03333333333333333 + a4 * (0.023809523809523808 + a4 * (-0.03333333333333333 + a4 * 5.0 / 66.0))))) / x;
        } else {
            a2 = this.evaluate(x + 1.0);
            a2 += 1.0 / x / x;
        }
        return a2;
    }
}

