/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.ode.ivp.solver.multistep.adamsbashforthmoulton;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.differentialequation.ode.ivp.problem.DerivativeFunction;
import dev.nm.analysis.differentialequation.ode.ivp.problem.ODE1stOrder;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODEIntegrator;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolution;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolver;
import dev.nm.analysis.differentialequation.ode.ivp.solver.multistep.adamsbashforthmoulton.ABMPredictorCorrector;
import dev.nm.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKutta2;
import dev.nm.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKuttaIntegrator;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AdamsBashforthMoulton
implements ODESolver {
    private final ABMPredictorCorrector void;
    private final ODEIntegrator if;
    private final double new;

    static {
        Package.validate("NMDEV_OPDE");
    }

    @Override
    public ODESolution solve(ODE1stOrder ode) {
        int a2;
        Object a3;
        double a4;
        int a5 = this.void.order();
        ArgumentAssertion.assertTrue((double)a5 * this.new < (a4 = ode.x1() - ode.x0()), "the initialization exhausts the range for the approximation; select a smaller step size or order, or a larger range", new Object[0]);
        int a6 = (int)(a4 / this.new) + 1;
        double[] a7 = new double[a6];
        Vector[] a8 = new Vector[a6];
        if (a5 > 1) {
            a3 = new double[a5];
            for (a2 = 0; a2 < a5; ++a2) {
                a3[a2] = this.new * (double)a2;
            }
            System.arraycopy(a3, 0, a7, 0, a5);
            System.arraycopy(this.if.integrate(ode, (double[])a3), 0, a8, 0, a5);
        } else {
            a7[0] = 0.0;
            a8[0] = ode.y0();
        }
        a3 = ode.dy();
        for (a2 = a5 - 1; a2 < a6 - 1; ++a2) {
            Vector a9;
            double[] a10 = AdamsBashforthMoulton.final(a7, a2, a5);
            Vector[] a11 = AdamsBashforthMoulton.final(a8, a2, a5);
            Vector a12 = this.void.predict((DerivativeFunction)a3, this.new, a10, a11);
            a7[a2 + 1] = a7[a2] + this.new;
            a8[a2 + 1] = a12;
            a10 = AdamsBashforthMoulton.final(a7, a2 + 1, a5 + 1);
            a11 = AdamsBashforthMoulton.final(a8, a2 + 1, a5 + 1);
            a8[a2 + 1] = a9 = this.void.correct((DerivativeFunction)a3, this.new, a10, a11);
        }
        return new ODESolution(a7, a8);
    }

    private static Vector[] final(Vector[] a2, int a3, int a4) {
        Vector[] a5 = new Vector[a4];
        for (int a6 = 0; a6 < a4; ++a6) {
            a5[a6] = a2[a3 - a6];
        }
        return a5;
    }

    public AdamsBashforthMoulton(ABMPredictorCorrector predictorCorrector, double stepSize, ODEIntegrator integrator) {
        this.void = predictorCorrector;
        this.new = stepSize;
        this.if = integrator;
    }

    private static double[] final(double[] a2, int a3, int a4) {
        double[] a5 = new double[a4];
        for (int a6 = 0; a6 < a4; ++a6) {
            a5[a6] = a2[a3 - a6];
        }
        return a5;
    }

    public AdamsBashforthMoulton(ABMPredictorCorrector predictorCorrector, double stepSize) {
        this(predictorCorrector, stepSize, new RungeKuttaIntegrator(new RungeKutta2()));
    }
}

