/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.LU;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.Chol;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.BackwardSubstitution;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.ForwardSubstitution;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.PermutationMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.operation.Basis;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.ParallelExecutor;
import dev.nm.number.DoubleUtils;
import java.util.concurrent.ExecutionException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Inverse
extends DenseMatrix {
    private static Matrix goto(Matrix a2, final double a3) {
        final ForwardSubstitution a4 = new ForwardSubstitution();
        final LowerTriangularMatrix a5 = new LowerTriangularMatrix(a2);
        final int a6 = a2.nRows();
        final DenseMatrix a7 = new DenseMatrix(a6, a6);
        try {
            ParallelExecutor.getSharedInstance().forLoop(1, a6 + 1, new LoopBody(){

                @Override
                public void run(int j2) throws Exception {
                    Basis a2 = new Basis(a6, j2);
                    Vector a32 = a4.solve(a5, a2, a3);
                    a7.setColumn(j2, a32);
                }
                {
                    3 a2;
                }
            });
        }
        catch (MultipleExecutionException a8) {
            for (ExecutionException a9 : a8.getExceptions()) {
                if (a9 == null) continue;
                throw new RuntimeException("failed to compute inverse", a9.getCause());
            }
        }
        return a7;
    }

    private static Matrix break(Matrix a2, double a3) {
        try {
            Chol a4 = new Chol(a2, a3);
            LowerTriangularMatrix a5 = a4.L();
            return Inverse.final(a5, a5.t(), a3);
        }
        catch (RuntimeException a6) {
            return Inverse.do(a2, a3);
        }
    }

    private static Matrix do(Matrix a2, double a3) {
        LU a4 = new LU(a2, a3);
        LowerTriangularMatrix a5 = a4.L();
        UpperTriangularMatrix a6 = a4.U();
        PermutationMatrix a7 = a4.P();
        return Inverse.final(a5, a6, a7, a3);
    }

    private static Matrix char(Matrix a2, final double a3) {
        final BackwardSubstitution a4 = new BackwardSubstitution();
        final UpperTriangularMatrix a5 = new UpperTriangularMatrix(a2);
        final int a6 = a2.nRows();
        final DenseMatrix a7 = new DenseMatrix(a6, a6);
        try {
            ParallelExecutor.getSharedInstance().forLoop(1, a6 + 1, new LoopBody(){

                @Override
                public void run(int j2) throws Exception {
                    Basis a2 = new Basis(a6, j2);
                    Vector a32 = a4.solve(a5, a2, a3);
                    a7.setColumn(j2, a32);
                }
                {
                    2 a2;
                }
            });
        }
        catch (MultipleExecutionException a8) {
            for (ExecutionException a9 : a8.getExceptions()) {
                if (a9 == null) continue;
                throw new RuntimeException("failed to compute inverse", a9.getCause());
            }
        }
        return a7;
    }

    private static Matrix final(final LowerTriangularMatrix a2, final UpperTriangularMatrix a3, final int[] a4, final double a5) {
        final ForwardSubstitution a6 = new ForwardSubstitution();
        final BackwardSubstitution a7 = new BackwardSubstitution();
        final int a8 = a2.nRows();
        final DenseMatrix a9 = new DenseMatrix(a8, a8);
        try {
            ParallelExecutor.getSharedInstance().forLoop(1, a8 + 1, new LoopBody(){

                @Override
                public void run(int j2) throws Exception {
                    Basis a22 = new Basis(a8, j2);
                    Vector a32 = a6.solve(a2, a22, a5);
                    Vector a42 = a7.solve(a3, a32, a5);
                    a9.setColumn(a4[j2], a42);
                }
                {
                    1 a22;
                }
            });
        }
        catch (MultipleExecutionException a10) {
            for (ExecutionException a11 : a10.getExceptions()) {
                if (a11 == null) continue;
                throw new RuntimeException("failed to compute inverse", a11.getCause());
            }
        }
        return a9;
    }

    private static Matrix final(Matrix a2, double a3) {
        if (!DimensionCheck.isSquare(a2)) {
            throw new IllegalArgumentException("Inverse applies to square matrix only");
        }
        if (MatrixPropertyUtils.isSymmetric(a2, a3)) {
            return Inverse.break(a2, a3);
        }
        if (MatrixPropertyUtils.isUpperTriangular(a2, a3)) {
            return Inverse.char(a2, a3);
        }
        if (MatrixPropertyUtils.isLowerTriangular(a2, a3)) {
            return Inverse.goto(a2, a3);
        }
        return Inverse.do(a2, a3);
    }

    private static Matrix final(LowerTriangularMatrix a2, UpperTriangularMatrix a3, PermutationMatrix a4, double a5) {
        int a6 = a4.nRows();
        DenseMatrix a7 = new DenseMatrix(1, a6);
        for (int a8 = 1; a8 <= a6; ++a8) {
            a7.set(1, a8, a8);
        }
        Matrix a9 = a4.rightMultiply(a7);
        int[] a10 = new int[a6 + 1];
        for (int a11 = 1; a11 <= a6; ++a11) {
            a10[(int)Math.round((double)a9.get((int)1, (int)a11))] = a11;
        }
        return Inverse.final(a2, a3, a10, a5);
    }

    private static Matrix final(LowerTriangularMatrix a2, UpperTriangularMatrix a3, double a4) {
        int[] a5 = DoubleUtils.seq(0, a2.nCols());
        return Inverse.final(a2, a3, a5, a4);
    }

    public Inverse(Matrix A2, double epsilon) {
        super(Inverse.final(A2, epsilon));
    }

    public Inverse(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2));
    }
}

