/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.algorithm.iterative.monitor.IterationMonitor;
import dev.nm.misc.algorithm.iterative.monitor.NullMonitor;
import dev.nm.misc.algorithm.iterative.tolerance.Tolerance;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JacobiSolver
implements IterativeLinearSystemSolver {
    private final int if;
    private final Tolerance new;

    public JacobiSolver(int maxIteration, Tolerance tolerance) {
        this.if = maxIteration;
        this.new = tolerance;
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(problem.A()), "the matrix A must be square", new Object[0]);
        JacobiSolver.final(problem.A());
        return new IterativeLinearSystemSolver.Solution(){
            int count;
            Vector x;
            private final Matrix if;
            Vector r;
            final int n;
            boolean isConverged;
            private final Vector new;

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.x);
                Vector a2 = new DenseVector(this.n).ZERO();
                for (int a3 = 1; a3 <= this.n; ++a3) {
                    double a4 = 0.0;
                    for (int a5 = 1; a5 <= this.n; ++a5) {
                        if (a5 == a3) continue;
                        a4 += this.if.get(a3, a5) * this.x.get(a5);
                    }
                    a4 = (this.new.get(a3) - a4) / this.if.get(a3, a3);
                    a2.set(a3, a4);
                }
                this.x = a2;
                this.r = this.new.minus(this.if.multiply(this.x));
                return monitor;
            }
            {
                1 a3;
                a3.if = a3.problem.A();
                a3.new = a3.problem.b();
                a3.n = a3.problem.size();
                a3.count = 0;
            }

            public void setInitials(Vector ... initials) {
                this.x = initials[0];
                this.r = this.new.minus(this.if.multiply(this.x));
                this.isConverged = JacobiSolver.this.new.isResidualSmall(this.r.norm());
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.count < JacobiSolver.this.if && !this.isConverged) {
                    this.step();
                    ++this.count;
                    this.isConverged |= JacobiSolver.this.new.isResidualSmall(this.r.norm());
                }
                monitor.addIterate(this.x);
                if (!this.isConverged) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, JacobiSolver.this.if + " exceeded");
                }
                return this.x;
            }
        };
    }

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }

    private static void final(Matrix a2) {
        for (int a3 = 1; a3 <= a2.nCols(); ++a3) {
            if (Double.compare(a2.get(a3, a3), 0.0) != 0) continue;
            throw new IllegalArgumentException("diagonal entries must be non-zero");
        }
    }
}

