/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.IdentityPreconditioner;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.PreconditionerFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.algorithm.iterative.monitor.IterationMonitor;
import dev.nm.misc.algorithm.iterative.monitor.NullMonitor;
import dev.nm.misc.algorithm.iterative.tolerance.Tolerance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BiconjugateGradientSolver
implements IterativeLinearSystemSolver {
    private final int false;
    private final int void;
    private final PreconditionerFactory if;
    private final Tolerance new;
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;

    public BiconjugateGradientSolver(PreconditionerFactory leftPreconditionerFactory, int residualRefreshRate, int maxIteration, Tolerance tolerance) {
        this.if = leftPreconditionerFactory;
        this.false = residualRefreshRate;
        this.void = maxIteration;
        this.new = tolerance;
    }

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }

    public BiconjugateGradientSolver(int maxIteration, Tolerance tolerance) {
        this(new PreconditionerFactory(){

            @Override
            public Preconditioner newInstance(Matrix A2) {
                return new IdentityPreconditioner();
            }
            {
                1 a2;
            }
        }, 50, maxIteration, tolerance);
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        return new IterativeLinearSystemSolver.Solution(){
            private Vector const;
            private final Vector this;
            private final Matrix else;
            private Vector goto;
            private Vector try;
            private final Preconditioner float;
            private Vector short;
            private Vector enum;
            private boolean false;
            private final Matrix void;
            private double if;
            private int new;

            public void setInitials(Vector ... initials) {
                this.short = initials[0];
                this.enum = this.this.minus(this.else.multiply(this.short));
                this.try = this.enum.deepCopy();
                this.goto = this.short.ZERO();
                this.const = this.short.ZERO();
                this.false = BiconjugateGradientSolver.this.new.isResidualSmall(this.enum.norm());
            }

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.short);
                Vector a2 = this.float.solve(this.enum);
                Vector a3 = this.float.transposeSolve(this.try);
                double a4 = this.try.innerProduct(a2);
                if (Double.compare(a4, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<z, rTilde> = 0");
                }
                double a5 = a4 / this.if;
                this.goto = a2.add(this.goto.scaled(a5));
                this.const = a3.add(this.const.scaled(a5));
                Vector a6 = this.else.multiply(this.goto);
                Vector a7 = this.void.multiply(this.const);
                double a8 = a6.innerProduct(this.const);
                if (Double.compare(a8, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<Ap, pTilde> = 0");
                }
                double a9 = a4 / a8;
                this.short = this.short.add(this.goto.scaled(a9));
                if ((this.new + 1) % BiconjugateGradientSolver.this.false != 0) {
                    this.enum = this.enum.minus(a6.scaled(a9));
                    this.try = this.try.minus(a7.scaled(a9));
                } else {
                    this.enum = this.this.minus(this.else.multiply(this.short));
                    this.try = this.this.minus(this.void.multiply(this.short));
                }
                this.if = a4;
                return monitor;
            }
            {
                2 a3;
                a3.else = a3.problem.A();
                a3.this = a3.problem.b();
                a3.void = a3.else.t();
                a3.float = a3.BiconjugateGradientSolver.this.if.newInstance(a3.else);
                a3.if = 1.0;
                a3.new = 0;
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.new < BiconjugateGradientSolver.this.void && !this.false) {
                    this.step();
                    ++this.new;
                    this.false |= BiconjugateGradientSolver.this.new.isResidualSmall(this.enum.norm());
                }
                monitor.addIterate(this.short);
                if (!this.false) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, BiconjugateGradientSolver.this.void + " iterations exceeded");
                }
                return this.short;
            }
        };
    }
}

