/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseStructure;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.number.Real;
import dev.nm.number.doublearray.DoubleArrayMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SparseVector
implements Vector,
SparseStructure,
Iterable<Entry> {
    private final LinkedList<Entry> if;
    private final int new;

    private SparseVector final(SparseVector a2, int a3) {
        Entry a4;
        SparseVector a5;
        MatrixPropertyUtils.throwIfNotEqualSize(a5, a2);
        LinkedList<Entry> a6 = new LinkedList<Entry>();
        java.util.Iterator a7 = a5.if.iterator();
        java.util.Iterator a8 = a2.if.iterator();
        Entry a9 = a7.hasNext() ? (Entry)a7.next() : null;
        Entry entry = a4 = a8.hasNext() ? (Entry)a8.next() : null;
        while (a9 != null || a4 != null) {
            if (a9 != null && (a4 == null || a9.new < a4.new)) {
                a6.add(new Entry(a9.new, a9.if));
                a9 = a7.hasNext() ? (Entry)a7.next() : null;
                continue;
            }
            if (a4 != null && (a9 == null || a9.new > a4.new)) {
                a6.add(new Entry(a4.new, (double)a3 * a4.if));
                a4 = a8.hasNext() ? (Entry)a8.next() : null;
                continue;
            }
            double a10 = a9.if + (double)a3 * a4.if;
            if (Double.compare(0.0, a10) != 0) {
                a6.add(new Entry(a9.new, a10));
            }
            a9 = a7.hasNext() ? (Entry)a7.next() : null;
            a4 = a8.hasNext() ? (Entry)a8.next() : null;
        }
        return new SparseVector(a5.new, a6);
    }

    @Override
    public double norm(double p) {
        if (p == Double.POSITIVE_INFINITY) {
            return DoubleArrayMath.max(DoubleArrayMath.abs(this.toArray()));
        }
        if (p == Double.NEGATIVE_INFINITY) {
            return DoubleArrayMath.min(DoubleArrayMath.abs(this.toArray()));
        }
        ArgumentAssertion.assertNotLessThan(p, 1.0, "p");
        double a2 = 0.0;
        for (Entry a3 : this.if) {
            a2 += Math.pow(a3.value(), p);
        }
        a2 = Math.pow(a2, 1.0 / p);
        return a2;
    }

    @Override
    public java.util.Iterator<Entry> iterator() {
        return new Iterator(this.if.listIterator());
    }

    @Override
    public SparseVector opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public int nNonZeros() {
        return this.if.size();
    }

    public SparseVector(double ... v) {
        this.new = v.length;
        this.if = new LinkedList();
        for (int a2 = 0; a2 < this.new; ++a2) {
            double a3 = v[a2];
            if (a3 == 0.0) continue;
            Entry a4 = new Entry(a2 + 1, a3);
            this.if.add(a4);
        }
    }

    @Override
    public SparseVector ZERO() {
        return new SparseVector(this.new);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        if (!SparseVector.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Vector)obj, 0.0);
        }
        SparseVector a2 = (SparseVector)obj;
        if (this.new != a2.new) {
            return false;
        }
        return this.if == a2.if || this.if != null && this.final(this.if, a2.if);
    }

    private boolean final(LinkedList<Entry> a2, LinkedList<Entry> a3) {
        SparseVector a4;
        if (a4.if.size() != a4.if.size()) {
            return false;
        }
        java.util.Iterator a5 = a2.iterator();
        java.util.Iterator a6 = a3.iterator();
        while (a5.hasNext()) {
            Entry a7 = (Entry)a5.next();
            Entry a8 = (Entry)a6.next();
            if (a7.new != a8.new) {
                return false;
            }
            if (a7.if == a8.if) continue;
            return false;
        }
        return true;
    }

    public SparseVector(Vector v) {
        this.new = v.size();
        this.if = new LinkedList();
        for (int a2 = 1; a2 <= this.new; ++a2) {
            double a3 = v.get(a2);
            if (a3 == 0.0) continue;
            Entry a4 = new Entry(a2, a3);
            this.if.add(a4);
        }
    }

    @Override
    public double[] toArray() {
        double[] a2 = new double[this.new];
        for (Entry a3 : this.if) {
            a2[((Entry)a3).new - 1] = a3.if;
        }
        return a2;
    }

    @Override
    public Vector divide(Vector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        SparseVector a2 = new SparseVector(this);
        for (Entry a3 : a2.if) {
            a2.set(a3.new, a3.if / that.get(a3.new));
        }
        return a2;
    }

    @Override
    public double innerProduct(SparseVector that) {
        Entry a2;
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double a3 = 0.0;
        java.util.Iterator a4 = this.if.iterator();
        java.util.Iterator a5 = that.if.iterator();
        Entry a6 = a4.hasNext() ? (Entry)a4.next() : null;
        Entry entry = a2 = a5.hasNext() ? (Entry)a5.next() : null;
        while (a6 != null && a2 != null) {
            if (a6.new < a2.new) {
                a6 = a4.hasNext() ? (Entry)a4.next() : null;
                continue;
            }
            if (a6.new > a2.new) {
                a2 = a5.hasNext() ? (Entry)a5.next() : null;
                continue;
            }
            a3 += a6.if * a2.if;
            a6 = a4.hasNext() ? (Entry)a4.next() : null;
            a2 = a5.hasNext() ? (Entry)a5.next() : null;
        }
        return a3;
    }

    @Override
    public Vector add(Vector that) {
        if (that instanceof SparseVector) {
            return this.add((SparseVector)that);
        }
        return this.char(that);
    }

    @Override
    public double innerProduct(Vector that) {
        if (that instanceof SparseVector) {
            return this.innerProduct((SparseVector)that);
        }
        return this.final(that);
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    @Override
    public SparseVector multiply(Vector that) {
        if (that instanceof SparseVector) {
            return this.multiply((SparseVector)that);
        }
        return this.final(that);
    }

    private double final(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        double a4 = 0.0;
        for (Entry a5 : a3.if) {
            a4 += a5.if * a2.get(a5.new);
        }
        return a4;
    }

    private Vector char(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        DenseVector a4 = new DenseVector(a2);
        for (Entry a5 : a3.if) {
            a4.set(a5.new, a5.if + a4.get(a5.new));
        }
        return a4;
    }

    @Override
    public Vector minus(double c2) {
        return this.add(-c2);
    }

    @Override
    public SparseVector add(SparseVector that) {
        return this.final(that, 1);
    }

    public SparseVector(int size, List<Entry> entries) {
        this(size, entries, false);
    }

    private Vector final(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        Object a4 = a2.opposite();
        for (Entry a5 : a3.if) {
            a4.set(a5.new, a5.if + a4.get(a5.new));
        }
        return a4;
    }

    public Vector leftMultiply(Matrix A2) {
        double[] a2 = new double[A2.nRows()];
        for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
            for (Entry a4 : this.if) {
                int n = a3 - 1;
                a2[n] = a2[n] + a4.if * A2.get(a3, a4.new);
            }
        }
        return new DenseVector(a2);
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        a2.append("size: ").append(this.new).append("\n");
        for (Entry a3 : this.if) {
            a2.append(a3.toString()).append("\n");
        }
        return a2.toString();
    }

    SparseVector(int a2, List<Entry> a3, boolean a4) {
        List<Entry> a5;
        SparseVector a6;
        a6.new = a2;
        if (!a4) {
            a5 = new ArrayList<Entry>(a3);
            Collections.sort(a5, Entry.Comparator.INSTANCE);
        } else {
            a5 = a3;
        }
        a6.if = new LinkedList();
        int a7 = 0;
        for (Entry a8 : a5) {
            if (a7 >= a8.new) {
                throw new IllegalArgumentException("duplicated indices: " + a8.new);
            }
            a7 = a8.new;
            a6.if.add(a8);
        }
    }

    public SparseVector(SparseVector that) {
        this(that.new);
        for (Entry a2 : that.if) {
            this.if.add(new Entry(a2.new, a2.if));
        }
    }

    @Override
    public void set(int index, double value) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, index);
        ListIterator<Entry> a2 = this.if.listIterator();
        while (a2.hasNext()) {
            Entry a3 = (Entry)a2.next();
            if (a3.new == index) {
                if (Double.compare(0.0, value) != 0) {
                    a3.if = value;
                } else {
                    a2.remove();
                }
                return;
            }
            if (a3.new <= index) continue;
            if (Double.compare(0.0, value) != 0) {
                a2.previous();
                a2.add(new Entry(index, value));
            }
            return;
        }
        if (Double.compare(0.0, value) != 0) {
            this.if.addLast(new Entry(index, value));
        }
    }

    private SparseVector final(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        SparseVector a4 = new SparseVector(a3);
        for (Entry a5 : a4.if) {
            a4.set(a5.new, a5.if * a2.get(a5.new));
        }
        return a4;
    }

    @Override
    public int size() {
        return this.new;
    }

    @Override
    public Vector add(double c2) {
        double[] a2 = DoubleUtils.rep(c2, this.new);
        for (Entry a3 : this.if) {
            int n = a3.new - 1;
            a2[n] = a2[n] + a3.if;
        }
        return new DenseVector(a2);
    }

    @Override
    public double angle(Vector that) {
        double a2 = this.innerProduct(that);
        a2 /= this.norm();
        a2 /= that.norm();
        a2 = Math.acos(a2);
        return a2;
    }

    @Override
    public SparseVector minus(SparseVector that) {
        return this.final(that, -1);
    }

    @Override
    public Vector minus(Vector that) {
        if (that instanceof SparseVector) {
            return this.minus((SparseVector)that);
        }
        return this.final(that);
    }

    public SparseVector(int size) {
        this.new = size;
        this.if = new LinkedList();
    }

    public SparseVector multiply(SparseVector that) {
        Entry a2;
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        LinkedList<Entry> a3 = new LinkedList<Entry>();
        java.util.Iterator a4 = this.if.iterator();
        java.util.Iterator a5 = that.if.iterator();
        Entry a6 = a4.hasNext() ? (Entry)a4.next() : null;
        Entry entry = a2 = a5.hasNext() ? (Entry)a5.next() : null;
        while (a6 != null && a2 != null) {
            if (a6.new < a2.new) {
                a6 = a4.hasNext() ? (Entry)a4.next() : null;
                continue;
            }
            if (a6.new > a2.new) {
                a2 = a5.hasNext() ? (Entry)a5.next() : null;
                continue;
            }
            double a7 = a6.if * a2.if;
            if (Double.compare(0.0, a7) != 0) {
                a3.add(new Entry(a6.new, a7));
            }
            a6 = a4.hasNext() ? (Entry)a4.next() : null;
            a2 = a5.hasNext() ? (Entry)a5.next() : null;
        }
        return new SparseVector(this.new, a3);
    }

    private SparseVector(int a2, LinkedList<Entry> a3) {
        SparseVector a4;
        a4.new = a2;
        a4.if = a3;
    }

    @Override
    public double norm() {
        return this.norm(2.0);
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this(size, SparseVector.final(size, indices, values));
    }

    private static List<Entry> final(int a2, int[] a3, double[] a4) {
        ArgumentAssertion.assertTrue(a3.length == a4.length, "sizes of input arrays mismatch", new Object[0]);
        ArrayList<Entry> a5 = new ArrayList<Entry>();
        for (int a6 = 0; a6 < a4.length; ++a6) {
            if (a3[a6] < 1 || a3[a6] > a2) {
                throw new IndexOutOfBoundsException("out-of-range index: " + a3[a6]);
            }
            a5.add(new Entry(a3[a6], a4[a6]));
        }
        return a5;
    }

    @Override
    public SparseVector deepCopy() {
        return new SparseVector(this);
    }

    @Override
    public SparseVector scaled(double c2) {
        if (Double.compare(0.0, c2) == 0) {
            return new SparseVector(this.new);
        }
        LinkedList<Entry> a2 = new LinkedList<Entry>();
        for (Entry a3 : this.if) {
            a2.add(new Entry(a3.new, c2 * a3.if));
        }
        return new SparseVector(this.new, a2);
    }

    @Override
    public SparseVector scaled(Real c2) {
        return this.scaled(c2.doubleValue());
    }

    @Override
    public double get(int index) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, index);
        for (Entry a2 : this.if) {
            if (a2.new == index) {
                return a2.if;
            }
            if (a2.new <= index) continue;
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public Vector pow(double c2) {
        double a2 = Math.pow(0.0, c2);
        if (Double.compare(0.0, a2) != 0) {
            double[] a3 = DoubleUtils.rep(a2, this.new);
            for (Entry a4 : this.if) {
                a3[((Entry)a4).new - 1] = Math.pow(a4.if, c2);
            }
            return new DenseVector(a3);
        }
        LinkedList<Entry> a5 = new LinkedList<Entry>();
        for (Entry a6 : this.if) {
            a5.add(new Entry(a6.new, Math.pow(a6.if, c2)));
        }
        return new SparseVector(this.new, a5);
    }

    public int hashCode() {
        int a2 = 5;
        a2 = 59 * a2 + this.new;
        a2 = 59 * a2 + (this.if != null ? this.if.hashCode() : 0);
        return a2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Iterator
    implements java.util.Iterator<Entry> {
        private final ListIterator<Entry> new;

        private Iterator(ListIterator<Entry> a2) {
            Iterator a3;
            a3.new = a2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove an element in a vector; set it to zero instead");
        }

        @Override
        public Entry next() {
            return this.new.next();
        }

        @Override
        public boolean hasNext() {
            return this.new.hasNext();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Entry {
        private double if;
        private int new;

        public int hashCode() {
            int a2 = 3;
            a2 = 59 * a2 + this.new;
            a2 = 59 * a2 + (int)(Double.doubleToLongBits(this.if) ^ Double.doubleToLongBits(this.if) >>> 32);
            return a2;
        }

        public String toString() {
            return String.format("[%d] %.4f", this.new, this.if);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry a2 = (Entry)obj;
            if (this.new != a2.new) {
                return false;
            }
            return Double.doubleToLongBits(this.if) == Double.doubleToLongBits(a2.if);
        }

        public double value() {
            return this.if;
        }

        public int index() {
            return this.new;
        }

        public Entry(int index, double value) {
            this.new = index;
            this.if = value;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public static enum Comparator implements java.util.Comparator<Entry>
        {
            INSTANCE;


            private Comparator() {
                Comparator a2;
            }

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1.new < o2.new) {
                    return -1;
                }
                if (o1.new > o2.new) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

