/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.qr;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.qr.QRDecomposition;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.PermutationMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.Householder4SubVector;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.Householder4ZeroGenerator;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.HouseholderContext;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.HouseholderInPlace;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.HouseholderReflection;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HouseholderQR
implements QRDecomposition {
    private final double enum;
    private final int false;
    private final HouseholderInPlace void;
    private final int if;
    private final HouseholderInPlace.Householder[] new;

    @Override
    public Matrix Q() {
        HouseholderInPlace a2 = new HouseholderInPlace(this.false, this.if);
        for (int a3 = this.new.length - 1; a3 >= 0; --a3) {
            a2.reflect(this.new[a3], a3 + 1, this.if);
        }
        return a2.getTransformedMatrix();
    }

    @Override
    public Matrix tallR() {
        return this.void.getTransformedMatrix();
    }

    @Override
    public PermutationMatrix P() {
        return new PermutationMatrix(this.if);
    }

    @Override
    public int rank() {
        int a2 = 0;
        for (int a3 = 1; a3 <= this.if; ++a3) {
            if (DoubleUtils.isZero(this.void.get(a3, a3), this.enum)) continue;
            ++a2;
        }
        return a2;
    }

    public HouseholderQR(Matrix A2, double epsilon) {
        this.false = A2.nRows();
        this.if = A2.nCols();
        ArgumentAssertion.assertTrue(this.false >= this.if, "QR decomposition by Householder Reflection applies to matrix where the number of rows >= the number of columns", new Object[0]);
        this.enum = epsilon;
        this.void = new HouseholderInPlace(A2, epsilon);
        int a2 = Math.min(this.if, this.false - 1);
        ArrayList<HouseholderInPlace.Householder> a3 = new ArrayList<HouseholderInPlace.Householder>(a2);
        for (int a4 = 1; a4 <= a2; ++a4) {
            HouseholderInPlace.Householder a5 = this.void.generateAndReflectColumns(a4, this.if, a4, this.false);
            a3.add(a5);
        }
        this.new = a3.toArray(new HouseholderInPlace.Householder[a2]);
    }

    public HouseholderQR(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2));
    }

    public HouseholderReflection[] getHouseholderMatrices() {
        HouseholderReflection[] a2 = new HouseholderReflection[this.new.length];
        for (int a3 = 0; a3 < this.new.length; ++a3) {
            HouseholderContext a4 = HouseholderInPlace.Householder.toContext(this.new[a3]);
            a2[a3] = DoubleUtils.isZero(a4.lambda, this.enum) ? new Householder4ZeroGenerator(this.false) : new Householder4SubVector(this.false, a4);
        }
        return a2;
    }

    @Override
    public Matrix squareQ() {
        return this.void.U().t();
    }

    @Override
    public UpperTriangularMatrix R() {
        Matrix a2 = this.void.getTransformedMatrix();
        double[][] a3 = new double[this.if][];
        for (int a4 = 1; a4 <= this.if; ++a4) {
            double[] a5 = new double[this.if - a4 + 1];
            int a6 = a4;
            int a7 = 0;
            while (a6 <= this.if) {
                a5[a7] = a2.get(a4, a6);
                ++a6;
                ++a7;
            }
            a3[a4 - 1] = a5;
        }
        return new UpperTriangularMatrix(a3);
    }
}

